/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.CommunicationHandleManger;
import com.wovoe.framework.communication.DirectSendTask;
import com.wovoe.framework.communication.OpType;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.impl.MappedTimeoutObjectPool;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasicCommunicationHandle
implements CommunicationHandle {
    protected String name;
    protected ProtocolHandlerChain protocolChain;
    protected Map<String, String> config;
    protected Logger logger;
    protected LinkedBlockingDeque<Object> sendDeque;
    protected ConcurrentLinkedQueue<DirectSendTask> maxPriorityTaskQueue;
    private AtomicBoolean stopThread = new AtomicBoolean(true);
    protected Thread sendThread;
    protected int attemptsToSend = 2;
    protected long waitAckTimeout = 300L;
    protected TimeUnit WaitAckTimeoutUnit = TimeUnit.MILLISECONDS;
    protected Collection<CommunicationHandle.ExceptionEventHandler> exceptionEventhandlers;
    private TimeoutObjectPool timeoutObjectPool;
    private boolean localcreatePool;

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Thread getSendThread() {
        return this.sendThread;
    }

    @Override
    public TimeoutObjectPool getTimeoutObjectPool() {
        return this.timeoutObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutObjectPool(TimeoutObjectPool timeoutObjectPool) {
        if (timeoutObjectPool != null && this.timeoutObjectPool != timeoutObjectPool) {
            if (this.localcreatePool && this.timeoutObjectPool != null) {
                BasicCommunicationHandle basicCommunicationHandle = this;
                synchronized (basicCommunicationHandle) {
                    if (this.localcreatePool && this.timeoutObjectPool != null) {
                        ((MappedTimeoutObjectPool)this.timeoutObjectPool).close();
                        this.timeoutObjectPool = null;
                        this.localcreatePool = false;
                    }
                }
            }
            this.timeoutObjectPool = timeoutObjectPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object start() throws IOException {
        if (this.useSendThread()) {
            AtomicBoolean atomicBoolean = this.stopThread;
            synchronized (atomicBoolean) {
                if (this.stopThread.compareAndSet(true, false)) {
                    this.maxPriorityTaskQueue = new ConcurrentLinkedQueue();
                    this.sendDeque = new LinkedBlockingDeque();
                    String n = this.getName();
                    if (n == null) {
                        n = "";
                    }
                    this.sendThread = new Thread(this.newSendThreadTask(), String.valueOf(n) + " send thread");
                    this.sendThread.start();
                }
            }
        }
        Object startObj = this.localStart();
        CommunicationHandleManger.addCommunicationHandle(this);
        if (this.timeoutObjectPool == null) {
            this.timeoutObjectPool = new MappedTimeoutObjectPool();
            this.localcreatePool = true;
        }
        return startObj;
    }

    protected abstract Object localStart() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object shutdown() throws IOException {
        CommunicationHandleManger.removeCommunicationHandle(this);
        Object shutdownobj = this.localShutdown();
        if (this.useSendThread()) {
            AtomicBoolean atomicBoolean = this.stopThread;
            synchronized (atomicBoolean) {
                if (this.stopThread.compareAndSet(false, true)) {
                    if (this.sendDeque != null) {
                        this.sendDeque.offerFirst(this.maxPriorityTaskQueue);
                    }
                    if (this.sendThread != null) {
                        this.sendThread.interrupt();
                        this.sendThread = null;
                    }
                    if (this.maxPriorityTaskQueue != null) {
                        DirectSendTask t;
                        while ((t = this.maxPriorityTaskQueue.poll()) != null) {
                            if (t.getSendCallbackHandler() == null) continue;
                            try {
                                t.getSendCallbackHandler().onSendException(new Exception("CommunicationHandle: " + t.getCommunicationHandle().getName() + " has been closed!"), t.getCommunicationHandle());
                            }
                            catch (Exception ex) {
                                this.notifyException("onSendException error!", OpType.OP_WRITE, ex);
                            }
                        }
                    }
                    if (this.sendDeque != null) {
                        Object obj;
                        while ((obj = this.sendDeque.poll()) != null) {
                            DirectSendTask t;
                            if (!(obj instanceof DirectSendTask) || (t = (DirectSendTask)obj).getSendCallbackHandler() == null) continue;
                            try {
                                t.getSendCallbackHandler().onSendException(new Exception("CommunicationHandle: " + t.getCommunicationHandle().getName() + " has been closed!"), t.getCommunicationHandle());
                            }
                            catch (Exception ex) {
                                this.notifyException("onSendException error!", OpType.OP_WRITE, ex);
                            }
                        }
                    }
                }
            }
        }
        if (this.timeoutObjectPool != null && this.localcreatePool) {
            ((MappedTimeoutObjectPool)this.timeoutObjectPool).close();
            this.localcreatePool = false;
            this.timeoutObjectPool = null;
        }
        return shutdownobj;
    }

    protected abstract Object localShutdown() throws IOException;

    protected boolean useSendThread() {
        return true;
    }

    protected Runnable newSendThreadTask() {
        return new Runnable(){

            @Override
            public void run() {
                while (!BasicCommunicationHandle.this.stopThread.get()) {
                    DirectSendTask task;
                    block17: {
                        Object obj;
                        block18: {
                            obj = BasicCommunicationHandle.this.sendDeque.poll(1L, TimeUnit.SECONDS);
                            if (obj != null) {
                                if (obj instanceof DirectSendTask) {
                                    task = (DirectSendTask)obj;
                                } else if (obj instanceof Queue) {
                                    task = (DirectSendTask)((Queue)obj).poll();
                                } else {
                                    task = null;
                                    if (BasicCommunicationHandle.this.logger != null) {
                                        BasicCommunicationHandle.this.logger.warning("unknown task object:" + obj);
                                    }
                                }
                            } else {
                                task = null;
                            }
                            if (task == null) break block17;
                            if (!BasicCommunicationHandle.this.stopThread.get()) break block18;
                            if (task.getSendCallbackHandler() != null) {
                                task.getSendCallbackHandler().onSendException(new Exception("CommunicationHandle: " + task.getCommunicationHandle().getName() + " has been closed!"), task.getCommunicationHandle());
                            }
                            task = null;
                            obj = null;
                            break;
                        }
                        try {
                            try {
                                BasicCommunicationHandle.this.handleDirectSendTask(task);
                            }
                            catch (Throwable ex) {
                                if (BasicCommunicationHandle.this.stopThread.get() && ex instanceof InterruptedException) {
                                    if (BasicCommunicationHandle.this.logger != null && BasicCommunicationHandle.this.logger.isLoggable(Level.INFO)) {
                                        BasicCommunicationHandle.this.logger.info("Stopping Send Thread!");
                                    }
                                } else {
                                    BasicCommunicationHandle.this.notifyException("send data error!", OpType.OP_WRITE, ex);
                                }
                                task = null;
                                obj = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            task = null;
                            obj = null;
                            throw throwable;
                        }
                    }
                    task = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    @Override
    public void notifyException(String msg, OpType opType, Throwable e) {
        Collection<CommunicationHandle.ExceptionEventHandler> exceptionEventhandlers = this.exceptionEventhandlers;
        if (exceptionEventhandlers != null && !exceptionEventhandlers.isEmpty()) {
            for (CommunicationHandle.ExceptionEventHandler handler : exceptionEventhandlers) {
                try {
                    handler.onException(msg, opType, e);
                }
                catch (Throwable ex) {
                    if (this.getLogger() == null) continue;
                    this.getLogger().log(Level.SEVERE, "call ExceptionEventHandler error!", ex);
                    this.getLogger().log(Level.SEVERE, opType == null ? msg : String.valueOf(opType.toString()) + ":" + msg, e);
                }
            }
        } else if (this.getLogger() != null) {
            this.getLogger().log(Level.SEVERE, opType == null ? msg : String.valueOf(opType.toString()) + ":" + msg, e);
        }
    }

    protected void handleDirectSendTask(final DirectSendTask task) throws Throwable {
        ByteArrayPacket[] sendDatas;
        if (task != null && (sendDatas = task.getDirectSendPackets()) != null && task.getDirectSendPacketsLength() > 0) {
            if (task.getWaitAckKey() != null) {
                if (task.getSendTimes() > 0) {
                    if (this.logger != null && this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("remain SendTimes()" + task.getSendTimes() + " WaitAckKey=" + task.getWaitAckKey());
                    }
                    task.setSendTimes(task.getSendTimes() - 1);
                    try {
                        boolean b = task.getTimeoutObjectPool().addObject(task.getWaitAckKey(), task, task, task.getEachSendTimeout(), task.getEachSendTimeoutTimeUnit());
                        if (!b) {
                            throw new Exception("timeoutObjectPool.addObject return false!");
                        }
                        task.setPriority(DirectSendTask.Priority.MAX_PRIORITY);
                        this.localSend(sendDatas, task.getDirectSendPacketsOffset(), task.getDirectSendPacketsLength(), new SendCallbackHandler(){
                            long currentNanoTime = System.nanoTime();

                            @Override
                            public void onSendCompleted(CommunicationHandle handle) {
                                long a2;
                                long x1;
                                long a1 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.currentNanoTime);
                                if (!task.getTimeoutObjectPool().restTimeout(task.getWaitAckKey(), task.getEachSendTimeout(), task.getEachSendTimeoutTimeUnit()) && (x1 = task.getEachSendTimeoutTimeUnit().toMillis(task.getEachSendTimeout())) < a1 && BasicCommunicationHandle.this.logger != null && BasicCommunicationHandle.this.logger.isLoggable(Level.WARNING)) {
                                    BasicCommunicationHandle.this.logger.warning("\u91cd\u65b0\u8bbe\u7f6eACK\u7b49\u5f85\u8d85\u65f6\u65f6\u95f4:" + x1 + "\u6beb\u79d2\u5931\u8d25!" + "\u6570\u636e\u53d1\u9001\u5b8c\u6210\uff0c\u8017\u65f6:" + a1 + "\u6beb\u79d2!\u5efa\u8bae\u589e\u5927\u7b49\u5f85ACK\u7684\u8d85\u65f6\u65f6\u95f4!");
                                }
                                if (BasicCommunicationHandle.this.logger != null && BasicCommunicationHandle.this.logger.isLoggable(Level.FINEST)) {
                                    BasicCommunicationHandle.this.logger.finest("\u6570\u636e\u53d1\u9001\u5b8c\u6210\uff0c\u8017\u65f6:" + a1 + "\u6beb\u79d2!");
                                }
                                if (task.getEachSendTimeoutTimeUnit() != null && task.getEachSendTimeout() > 0L && (a2 = task.getEachSendTimeoutTimeUnit().toMillis(task.getEachSendTimeout())) < a1 && BasicCommunicationHandle.this.logger != null && BasicCommunicationHandle.this.logger.isLoggable(Level.WARNING)) {
                                    BasicCommunicationHandle.this.logger.warning("\u7b49\u5f85ACK\u8d85\u65f6\u65f6\u95f4\u8bbe\u7f6e\u4e3a:" + a2 + "\u6beb\u79d2! \u800c\u53d1\u9001\u8017\u65f6\uff1a" + a1 + "\u6beb\u79d2! \u5efa\u8bae\u589e\u5927\u7b49\u5f85ACK\u7684\u8d85\u65f6\u65f6\u95f4!");
                                }
                            }

                            @Override
                            public void onSendException(Throwable exception, CommunicationHandle handle) {
                                if (task.getSendCallbackHandler() != null) {
                                    task.getSendCallbackHandler().onSendException(exception, task.getCommunicationHandle());
                                }
                            }

                            @Override
                            public void onSendTimeout(CommunicationHandle handle) {
                                if (task.getSendCallbackHandler() != null) {
                                    task.getSendCallbackHandler().onSendTimeout(task.getCommunicationHandle());
                                }
                            }
                        });
                    }
                    catch (Throwable ex) {
                        if (task.getSendCallbackHandler() != null) {
                            task.getSendCallbackHandler().onSendException(ex, task.getCommunicationHandle());
                        }
                        throw ex;
                    }
                } else {
                    if (this.logger != null && this.logger.isLoggable(Level.WARNING)) {
                        this.logger.warning("\u53d1\u9001\u6570\u636e\u7b49\u5f85ACK\u8d85\u65f6\uff01");
                    }
                    if (task.getSendCallbackHandler() != null) {
                        task.getSendCallbackHandler().onSendTimeout(task.getCommunicationHandle());
                    }
                }
            } else {
                try {
                    this.localSend(sendDatas, task.getDirectSendPacketsOffset(), task.getDirectSendPacketsLength(), task.getSendCallbackHandler());
                }
                catch (Throwable ex) {
                    if (task.getSendCallbackHandler() != null) {
                        task.getSendCallbackHandler().onSendException(ex, task.getCommunicationHandle());
                    }
                    throw ex;
                }
            }
        }
    }

    @Override
    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    @Override
    public ProtocolContext pollContext(OpType opType) {
        ProtocolContext context = ProtocolContext.createContext(opType);
        context.setProtocolHandlerChain(this.protocolChain);
        context.setCommunicationHandle(this);
        return context;
    }

    @Override
    public void send(AppProtocolPacket sendAppPacket, SendCallbackHandler hanler) {
        if (sendAppPacket == null) {
            return;
        }
        ProtocolContext context = this.pollContext(OpType.OP_WRITE);
        try {
            if (!this.isStart()) {
                throw new Exception("not start yet!");
            }
            Enumeration<String> atrrNames = sendAppPacket.getAttributeNames();
            if (atrrNames != null) {
                while (atrrNames.hasMoreElements()) {
                    String name = atrrNames.nextElement();
                    context.setAttribute(name, sendAppPacket.getAttribute(name));
                }
            }
            if (hanler != null) {
                context.setAttribute("send.callback.handler", hanler);
            }
            context.setMessage(sendAppPacket);
            this.getProtocolHandlerChain().execute(context);
        }
        catch (Exception ex) {
            if (hanler != null) {
                hanler.onSendException(ex, this);
            }
            this.notifyException("send data error!", OpType.OP_WRITE, ex);
        }
    }

    @Override
    public void submit(DirectSendTask task) {
        if (this.useSendThread()) {
            if (!this.stopThread.get()) {
                if (task.getPriority() == DirectSendTask.Priority.MAX_PRIORITY) {
                    this.maxPriorityTaskQueue.offer(task);
                    this.sendDeque.offerFirst(this.maxPriorityTaskQueue);
                } else {
                    this.sendDeque.offerLast(task);
                }
            } else {
                Exception ex = new Exception("CommunicationHandle: " + this.getName() + " has been closed!");
                if (task.getSendCallbackHandler() != null) {
                    task.getSendCallbackHandler().onSendException(ex, task.getCommunicationHandle());
                }
                this.notifyException("send Data error!", OpType.OP_WRITE, ex);
            }
        } else {
            try {
                this.handleDirectSendTask(task);
            }
            catch (Throwable ex) {
                this.notifyException("send Data error!", OpType.OP_WRITE, ex);
            }
        }
    }

    protected void localSend(ByteArrayPacket[] packets, int offset, int length, SendCallbackHandler writeCallback) throws IOException {
        if (length == 0) {
            if (writeCallback != null) {
                writeCallback.onSendCompleted(this);
            }
            return;
        }
        int end = offset + length;
        if (packets == null || offset < 0 || length < 0 || end > packets.length) {
            throw new IOException("invalid offset:" + offset + " length:" + length + " packets.length:" + (packets == null ? 0 : packets.length));
        }
        SendCallbackHandle0 handle1 = writeCallback == null || !(writeCallback instanceof SendCallbackHandle0) ? new SendCallbackHandle0(packets, offset, length, writeCallback) : (SendCallbackHandle0)writeCallback;
        this.localSend0(packets[offset], handle1);
    }

    @Override
    public ProtocolHandlerChain getProtocolHandlerChain() {
        return this.protocolChain;
    }

    @Override
    public void setProtocolHandlerChain(ProtocolHandlerChain handlerChain) {
        this.protocolChain = handlerChain;
    }

    @Override
    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public int getAttemptsToSend() {
        return this.attemptsToSend;
    }

    @Override
    public void setAttemptsToSend(int attemptsToSend) {
        if (attemptsToSend > 0) {
            this.attemptsToSend = attemptsToSend;
        }
    }

    @Override
    public long getWaitAckTimeout() {
        return this.waitAckTimeout;
    }

    @Override
    public void setWaitAckTimeout(long timeout) {
        this.waitAckTimeout = timeout;
    }

    @Override
    public TimeUnit getWaitAckTimeoutTimeUnit() {
        return this.WaitAckTimeoutUnit;
    }

    @Override
    public void setWaitAckTimeoutTimeUnit(TimeUnit timeoutUnit) {
        if (timeoutUnit != null) {
            this.WaitAckTimeoutUnit = timeoutUnit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExceptionEventHandler(CommunicationHandle.ExceptionEventHandler eventHandler) {
        if (this.exceptionEventhandlers == null) {
            BasicCommunicationHandle basicCommunicationHandle = this;
            synchronized (basicCommunicationHandle) {
                if (this.exceptionEventhandlers == null) {
                    this.exceptionEventhandlers = new CopyOnWriteArrayList<CommunicationHandle.ExceptionEventHandler>();
                }
            }
        }
        this.exceptionEventhandlers.add(eventHandler);
    }

    @Override
    public void removeExceptionEventHandler(CommunicationHandle.ExceptionEventHandler eventHandler) {
        Collection<CommunicationHandle.ExceptionEventHandler> h = this.exceptionEventhandlers;
        if (h != null) {
            h.remove(eventHandler);
        }
    }

    @Override
    public Enumeration<CommunicationHandle.ExceptionEventHandler> getExceptionEventHandlers() {
        Collection<CommunicationHandle.ExceptionEventHandler> h = this.exceptionEventhandlers;
        if (h == null) {
            h = new LinkedList<CommunicationHandle.ExceptionEventHandler>();
        }
        return Collections.enumeration(h);
    }

    @Override
    public void restart() throws IOException {
        this.shutdown();
        this.start();
    }

    protected void handleLocalReceivedPacket(Object receivedMessage, SocketAddress socketAddress) throws Exception {
        if (receivedMessage != null) {
            ProtocolContext context = this.pollContext(OpType.OP_READ);
            context.setMessage(receivedMessage);
            context.setAttribute("receive.source.address", socketAddress);
            this.beforeExeReadChanin(context);
            this.getProtocolHandlerChain().execute(context);
        }
    }

    protected void beforeExeReadChanin(ProtocolContext context) {
    }

    protected abstract void localSend0(Object var1, SendCallbackHandler var2) throws IOException;

    protected class SendCallbackHandle0
    implements SendCallbackHandler {
        ByteArrayPacket[] packets1;
        int offset1;
        int length1;
        SendCallbackHandler writeCallback1;

        SendCallbackHandle0(ByteArrayPacket[] packets, int offset, int length, SendCallbackHandler writeCallback) {
            this.packets1 = packets;
            this.offset1 = offset;
            this.length1 = length;
            this.writeCallback1 = writeCallback;
        }

        @Override
        public void onSendCompleted(CommunicationHandle handle) {
            ++this.offset1;
            --this.length1;
            if (this.length1 <= 0) {
                if (this.writeCallback1 != null) {
                    this.writeCallback1.onSendCompleted(handle);
                }
            } else {
                try {
                    BasicCommunicationHandle.this.localSend(this.packets1, this.offset1, this.length1, this);
                }
                catch (Throwable ex) {
                    this.onSendException(ex, handle);
                }
            }
        }

        @Override
        public void onSendException(Throwable e, CommunicationHandle handle) {
            if (this.writeCallback1 != null) {
                this.writeCallback1.onSendException(e, handle);
            } else if (handle.getLogger() != null) {
                handle.getLogger().log(Level.SEVERE, "Send data error!", e);
            }
        }

        @Override
        public void onSendTimeout(CommunicationHandle handle) {
            if (this.writeCallback1 != null) {
                this.writeCallback1.onSendTimeout(handle);
            }
        }
    }
}

