/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.communication.ByteArrayPacket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class ByteBufferPacket
implements ByteArrayPacket {
    private ByteBuffer byteBuffer;
    private SocketAddress socketAddress;
    private byte[] data;
    private int offset;
    private int length;
    private boolean isinit;

    public ByteBufferPacket(ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    public ByteBufferPacket(ByteBuffer byteBuffer, SocketAddress socketAddress) {
        if (byteBuffer != null) {
            this.offset = byteBuffer.position();
            this.length = byteBuffer.limit();
        }
        this.byteBuffer = byteBuffer;
        this.socketAddress = socketAddress;
    }

    private void init() {
        if (!this.isinit) {
            if (this.byteBuffer != null) {
                int pos = this.byteBuffer.position();
                int limit = this.byteBuffer.limit();
                this.byteBuffer.position(this.offset);
                this.byteBuffer.limit(this.length);
                if (this.byteBuffer.hasArray()) {
                    this.data = this.byteBuffer.array();
                    this.offset = this.byteBuffer.arrayOffset() + this.byteBuffer.position();
                    this.length = this.byteBuffer.remaining();
                } else {
                    this.data = new byte[this.byteBuffer.remaining()];
                    this.byteBuffer.get(this.data);
                    this.offset = 0;
                    this.length = this.data.length;
                }
                this.byteBuffer.position(pos);
                this.byteBuffer.limit(limit);
            } else {
                this.data = null;
                this.offset = 0;
                this.length = 0;
            }
            this.isinit = true;
        }
    }

    @Override
    public byte[] getByteArray() {
        this.init();
        return this.data;
    }

    @Override
    public int getByteArrayOffset() {
        this.init();
        return this.offset;
    }

    @Override
    public int getByteArrayLength() {
        this.init();
        return this.length;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        if (this.byteBuffer != byteBuffer) {
            this.byteBuffer = byteBuffer;
            this.isinit = false;
        }
    }
}

