/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.communication.ByteArrayPacket;
import java.net.DatagramPacket;

public class DatagramByteArrayPacket
implements ByteArrayPacket {
    private DatagramPacket packet;

    public DatagramByteArrayPacket(DatagramPacket packet) {
        this.packet = packet;
    }

    public DatagramByteArrayPacket(byte[] buf, int offset, int length) {
        this.packet = new DatagramPacket(buf, offset, length);
    }

    public DatagramByteArrayPacket(int size) {
        this.packet = new DatagramPacket(new byte[size], 0, size);
    }

    public void setByteArray(byte[] array, int offset, int length) {
        this.packet.setData(array, offset, length);
    }

    @Override
    public byte[] getByteArray() {
        return this.packet.getData();
    }

    @Override
    public int getByteArrayLength() {
        return this.packet.getLength();
    }

    @Override
    public int getByteArrayOffset() {
        return this.packet.getOffset();
    }

    public void recycle() {
        this.clear();
    }

    public DatagramPacket getDatagramPacket() {
        return this.packet;
    }

    public void setDatagramPacket(DatagramPacket packet) {
        this.packet = packet;
    }

    public void clear() {
        this.packet.setAddress(null);
        this.packet.setPort(0);
        this.packet.setData(this.packet.getData(), 0, this.packet.getData().length);
    }

    public String toString() {
        StringBuilder sbr = new StringBuilder((this.getByteArrayLength() << 1) + 64);
        sbr.append("socket address:").append(this.packet == null ? "null" : this.packet.getSocketAddress());
        sbr.append(", data:").append(this.packet == null ? "null" : BytesTool.byteArrayToHexString(this.getByteArray(), this.getByteArrayOffset(), this.getByteArrayLength()));
        return sbr.toString();
    }
}

