/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.DirectSendTask;
import com.wovoe.framework.communication.SendCallbackHandler;
import java.util.concurrent.TimeUnit;

public class DefaultDirectSendTask
implements DirectSendTask {
    private ByteArrayPacket[] sendPackets;
    private int sendPacketsOffset;
    private int sendPacketsLength;
    private SendCallbackHandler sendCallbackHandler;
    private TimeoutObjectPool timeoutObjectPool;
    private int sendTimes;
    private Object waitAckKey;
    private long waitAckTimeout;
    private TimeUnit timeUnit;
    private CommunicationHandle communicationHandle;
    private DirectSendTask.Priority priority;

    public DefaultDirectSendTask(DirectSendTask.Priority priority, CommunicationHandle communicationHandle, ByteArrayPacket[] sendPackets, int sendPacketsOffset, int sendPacketsLength, SendCallbackHandler sendCallbackHandler, TimeoutObjectPool timeoutObjectPool, int sendTimes, Object waitAckKey, long waitAckTimeout, TimeUnit timeUnit) {
        this.set(priority, communicationHandle, sendPackets, sendPacketsOffset, sendPacketsLength, sendCallbackHandler, timeoutObjectPool, sendTimes, waitAckKey, waitAckTimeout, timeUnit);
    }

    public DefaultDirectSendTask() {
    }

    public void set(DirectSendTask.Priority priority, CommunicationHandle communicationHandle, ByteArrayPacket[] sendPackets, int sendPacketsOffset, int sendPacketsLength, SendCallbackHandler sendCallbackHandler, TimeoutObjectPool timeoutObjectPool, int sendTimes, Object waitAckKey, long waitAckTimeout, TimeUnit timeUnit) {
        this.priority = priority;
        this.communicationHandle = communicationHandle;
        this.sendPackets = sendPackets;
        this.sendPacketsOffset = sendPacketsOffset;
        this.sendPacketsLength = sendPacketsLength;
        this.sendCallbackHandler = sendCallbackHandler;
        this.timeoutObjectPool = timeoutObjectPool;
        this.sendTimes = sendTimes;
        this.waitAckKey = waitAckKey;
        this.waitAckTimeout = waitAckTimeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public long getEachSendTimeout() {
        return this.waitAckTimeout;
    }

    @Override
    public TimeUnit getEachSendTimeoutTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public SendCallbackHandler getSendCallbackHandler() {
        return this.sendCallbackHandler;
    }

    @Override
    public int getSendTimes() {
        return this.sendTimes;
    }

    @Override
    public Object getWaitAckKey() {
        return this.waitAckKey;
    }

    @Override
    public CommunicationHandle getCommunicationHandle() {
        return this.communicationHandle;
    }

    @Override
    public TimeoutObjectPool getTimeoutObjectPool() {
        return this.timeoutObjectPool;
    }

    @Override
    public DirectSendTask.Priority getPriority() {
        if (this.priority == null) {
            return DirectSendTask.Priority.NORM_PRIORITY;
        }
        return this.priority;
    }

    @Override
    public void setPriority(DirectSendTask.Priority priority) {
        this.priority = priority;
    }

    @Override
    public void setSendTimes(int sendTimes) {
        this.sendTimes = sendTimes;
    }

    @Override
    public ByteArrayPacket[] getDirectSendPackets() {
        return this.sendPackets;
    }

    @Override
    public int getDirectSendPacketsOffset() {
        return this.sendPacketsOffset;
    }

    @Override
    public int getDirectSendPacketsLength() {
        return this.sendPacketsLength;
    }

    @Override
    public void onTimeout(Object key, Object object) throws Exception {
        if (this.communicationHandle != null) {
            this.communicationHandle.submit(this);
        }
    }
}

