/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.communication.Protocol;

public class ParkingProtocol
implements Protocol {
    private static final ParkingProtocol instance = new ParkingProtocol();
    public static final byte TYPE_SINGLE_FRAME_BROADCAST_4 = 4;
    public static final byte TYPE_SINGLE_FRAME_BROADCAST_5 = 5;
    public static final byte TYPE_SINGLE_FRAME_ACK_0 = 0;
    public static final byte TYPE_SINGLE_FRAME_POINTTOPOINT_1 = 1;
    public static final byte TYPE_NONEND_MULTI_FRAME_BROADCAST = 7;
    public static final byte TYPE_END_MULTI_FRAME_BROADCAST = 6;
    public static final byte TYPE_NONEND_MULTI_FRAME_POINTTOPOINT = 3;
    public static final byte TYPE_END_MULTI_FRAME_POINTTOPOINT = 2;
    public static final byte HEX_0X01 = 1;
    public static final byte HEX_0X00 = 0;

    public static ParkingProtocol getInstance() {
        return instance;
    }

    public int generateId(int head, int tag, int dir, int priority, int address, int device, int port, int needACK, int type, int crypt) {
        int id = 0;
        id |= head << 30;
        id |= tag << 31 >>> 2;
        id |= dir << 31 >>> 3;
        id |= priority << 28 >>> 4;
        id |= address << 21 >>> 8;
        id |= device << 27 >>> 19;
        id |= port << 29 >>> 24;
        id |= needACK << 31 >>> 27;
        id |= type << 29 >>> 28;
        return id |= crypt << 31 >>> 31;
    }

    public int getHead(int id) {
        return id >>> 30;
    }

    public int getTag(int id) {
        return id << 2 >>> 31;
    }

    public int getDir(int id) {
        return id << 3 >>> 31;
    }

    public int getPriority(int id) {
        return id << 4 >>> 28;
    }

    public int getAddress(int id) {
        return id << 8 >>> 21;
    }

    public int getDevice(int id) {
        return id << 19 >>> 27;
    }

    public int getPort(int id) {
        return id << 24 >>> 29;
    }

    public int getNeedACK(int id) {
        return id << 27 >>> 31;
    }

    public int getType(int id) {
        return id << 28 >>> 29;
    }

    public int getCrypt(int id) {
        return id << 31 >>> 31;
    }

    public boolean isComeFromPC(int id) {
        return this.isMasterToSlave(id);
    }

    public boolean isMasterToSlave(int id) {
        return this.getDir(id) == 0;
    }

    public int setSingleFrameBit(int id) {
        return id >> 3 << 3 | id << 30 >>> 30;
    }

    public int setNonendMultiFrameBit(int id) {
        return id >> 3 << 3 | id << 31 >>> 31 | 6;
    }

    public int setEndMultiFrameBit(int id) {
        return id >> 3 << 3 | id << 31 >>> 31 | 4;
    }

    public boolean isBroadcast(int id) {
        return (byte)(id << 28 >>> 31) == 1;
    }

    public boolean isMutiFrame(int id) {
        return (byte)(id << 29 >>> 31) == 1;
    }

    public boolean isEndFrame(int id) {
        return (byte)(id << 30 >>> 31) == 0;
    }

    public boolean isCrypt(int id) {
        return (byte)(id << 31 >>> 31) == 1;
    }

    public boolean isACK(int id) {
        return (byte)this.getType(id) == 0;
    }

    public boolean isNeedACK(int id) {
        return (byte)this.getNeedACK(id) == 1;
    }

    public int setBroadcast(int id) {
        return this.setIntBitValue(id, 4, 1);
    }

    public int setPointToPoint(int id) {
        return this.setIntBitValue(id, 4, 0);
    }

    public int setMutiFrame(int id) {
        return this.setIntBitValue(id, 3, 1);
    }

    public int setSingleFrame(int id) {
        return this.setIntBitValue(id, 3, 0);
    }

    public int setEndFrame(int id) {
        return this.setIntBitValue(id, 2, 0);
    }

    public int setNotEndFrame(int id) {
        return this.setIntBitValue(id, 2, 1);
    }

    public int setIntBitValue(int intValue, int n, int bitValue) {
        int xn = 33 - n;
        return (intValue >> n << 1 | bitValue) << n - 1 | intValue << xn >>> xn;
    }

    public static void main(String[] args) {
        int h = BytesTool.makeInt((byte)16, (byte)0, (byte)48, (byte)34);
        ParkingProtocol p = ParkingProtocol.getInstance();
        System.out.println(p.isMasterToSlave(h));
        System.out.println(p.isACK(h));
        System.out.println(p.getDevice(h));
    }
}

