/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.DirectSendTask;
import com.wovoe.framework.communication.ParkingDataFrame;
import com.wovoe.framework.communication.ParkingDataFramePacket;
import com.wovoe.framework.communication.ParkingProtocol;
import com.wovoe.framework.communication.ParkingSocketAddress;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.SimpleAttributeHolder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ParkingProtocolHandler
extends AbstractProtocolHandler {
    private final Object lockPool = new Object();
    private AtomicInteger sequenceCouter;

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        Boolean isAckFrame;
        ParkingDataFramePacket framesPacket = null;
        ParkingSocketAddress communicationAddress = (ParkingSocketAddress)ctx.getAttribute("send.target.address");
        if (communicationAddress == null) {
            throw new IllegalStateException("Unknown ParkingSocketAddress!");
        }
        Object message = ctx.getMessage();
        ByteBuffer appByteBuf = null;
        if (message instanceof AckPacket) {
            isAckFrame = Boolean.TRUE;
        } else {
            isAckFrame = Boolean.FALSE;
            appByteBuf = (ByteBuffer)message;
        }
        if (appByteBuf == null) {
            if (isAckFrame.booleanValue()) {
                appByteBuf = ByteBuffer.allocate(0);
            } else {
                throw new IllegalStateException("Unknown send message!");
            }
        }
        int rem = appByteBuf.remaining();
        int oldPosition = appByteBuf.position();
        try {
            int id_needAck;
            int id_crypt;
            Boolean isNeedEncrypt = (Boolean)ctx.getAttribute("send.need.encrypt");
            if (isNeedEncrypt == null) {
                isNeedEncrypt = this.getDefaultNeedEncrypt();
            }
            if (isNeedEncrypt.booleanValue()) {
                appByteBuf = this.encrypt(appByteBuf);
                id_crypt = 1;
            } else {
                id_crypt = 0;
            }
            Integer id_head = (Integer)ctx.getAttribute("send.id.head");
            Integer id_tag = (Integer)ctx.getAttribute("send.id.tag");
            Integer id_dir = (Integer)ctx.getAttribute("send.id.dir");
            Boolean needACK = (Boolean)ctx.getAttribute("send.need.ack");
            if (needACK == null) {
                needACK = this.getDefaultNeedACK(communicationAddress);
            }
            int n = id_needAck = needACK != false ? 1 : 0;
            int id_type = isAckFrame != false ? 0 : (communicationAddress.isBroadCastType() ? 4 : 1) & 0xFF;
            ParkingProtocol protocol = ParkingProtocol.getInstance();
            int sendId = protocol.generateId(id_head == null ? this.getDefaultHead() : id_head.intValue(), id_tag == null ? this.getDefaultTag() : id_tag.intValue(), id_dir == null ? this.getDefaultDir() : id_dir.intValue(), communicationAddress.getPriority() & 0xFF, communicationAddress.getAddress(), communicationAddress.getDevice() & 0xFF, communicationAddress.getPort() & 0xFF, id_needAck, id_type, id_crypt);
            Integer sendSeq = (Integer)ctx.getAttribute("send.packet.sequence");
            int seq = sendSeq == null ? this.getNextSendSequence(communicationAddress) : sendSeq.intValue();
            seq = this.handleSeq(seq, ctx, sendId);
            int maxLen = this.getSingleMaxDataLength();
            if (++rem <= maxLen - 1) {
                int n2 = 1;
                framesPacket = new ParkingDataFramePacket(n2);
                framesPacket.setSequence((byte)seq);
                ParkingDataFrame frame = this.poll(rem + 1);
                frame.setId(protocol.setSingleFrame(sendId));
                framesPacket.getFrameList().add(frame);
                frame.setIndex((byte)0);
                this.parseToParkingDataFrame(appByteBuf, appByteBuf.remaining(), framesPacket.getSequence(), frame, protocol);
            } else {
                if (!this.isSuportMutiFrame()) {
                    throw new Exception("\u4e0d\u652f\u6301\u591a\u5e27\u53d1\u9001\uff01\u53d1\u9001\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e27\u6700\u5927\u6570\u636e\u91cf\u9650\u5236\uff0c\u4e00\u5e27\u6700\u5927\u4e3a:" + (maxLen - 1) + "\uff0c\u4f46\u5b9e\u9645:" + appByteBuf.remaining());
                }
                int multiLen = maxLen - 1;
                int n3 = rem % multiLen;
                n3 = n3 == 0 ? rem / multiLen : rem / multiLen + 1;
                framesPacket = new ParkingDataFramePacket(n3);
                framesPacket.setSequence((byte)seq);
                int i = 0;
                while (i < n3) {
                    ParkingDataFrame frame;
                    if (i != n3 - 1) {
                        frame = this.poll(maxLen);
                        frame.setId(protocol.setNonendMultiFrameBit(sendId));
                        if (i == 0) {
                            frame.setDataLength(multiLen - 1);
                        } else {
                            frame.setDataLength(multiLen);
                        }
                    } else {
                        frame = this.poll(appByteBuf.remaining() + 1);
                        frame.setId(protocol.setEndMultiFrameBit(sendId));
                        frame.setDataLength(appByteBuf.remaining());
                    }
                    frame.setIndex((byte)i);
                    framesPacket.getFrameList().add(frame);
                    this.parseToParkingDataFrame(appByteBuf, frame.getDataLength(), framesPacket.getSequence(), frame, protocol);
                    ++i;
                }
            }
            framesPacket.setSocketAddress(communicationAddress);
            if (needACK.booleanValue()) {
                Object ackkey = this.getAckKey(communicationAddress, framesPacket.getSequence());
                ctx.setAttribute("send.ack.key", ackkey);
            }
            this.handleFramePacket(framesPacket, ctx);
        }
        finally {
            appByteBuf.position(oldPosition);
        }
        return true;
    }

    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        Logger logger = ctx.getCommunicationHandle().getLogger();
        ByteArrayPacket byteArray = (ByteArrayPacket)ctx.getMessage();
        if (byteArray == null) {
            return false;
        }
        if (byteArray.getByteArrayLength() < this.getFrameHeadLength() + 1) {
            if (logger != null && logger.isLoggable(Level.FINEST)) {
                logger.finest("\u6536\u5230\u4e00\u5e27\u975e\u6cd5\u6570\u636e,\u4e0d\u4f5c\u5904\u7406,data:" + BytesTool.byteArrayToHexString(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength()) + " \u6570\u636e\u957f\u5ea6:" + byteArray.getByteArrayLength() + " \u5c0f\u4e8e\u6700\u5c0f\u957f\u5ea6: " + (this.getFrameHeadLength() + 1));
            }
            return false;
        }
        ParkingSocketAddress sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
        if (sourceAddress == null) {
            sourceAddress = new ParkingSocketAddress();
            ctx.setAttribute("receive.source.address", sourceAddress);
        }
        ParkingProtocol protocol = ParkingProtocol.getInstance();
        int id = this.getIdFromByteArrayPacket(byteArray);
        sourceAddress.setAddress((short)protocol.getAddress(id));
        sourceAddress.setPort((byte)protocol.getPort(id));
        sourceAddress.setDevice((byte)protocol.getDevice(id));
        sourceAddress.setPriority((byte)protocol.getPriority(id));
        sourceAddress.setBroadCastType(protocol.isBroadcast(id));
        if (protocol.isComeFromPC(id) && !this.isReceiveFromPcFrame(ctx, id, protocol, sourceAddress)) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.warning("\u6536\u5230\u4e00\u4e2a\u6765\u81eapc\u7684\u6570\u636e\u5e27,\u4e0d\u4f5c\u5904\u7406,data:" + BytesTool.byteArrayToHexString(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength()) + " source:" + sourceAddress);
            }
        } else if (sourceAddress.isBroadCastType() && !this.isReceiveBroadcast(ctx, id, protocol, sourceAddress)) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.warning("\u6536\u5230\u4e00\u4e2a\u5e7f\u64ad\u6570\u636e\u5e27,\u4e0d\u4f5c\u5904\u7406,data:" + BytesTool.byteArrayToHexString(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength()) + " source:" + sourceAddress + " dir:" + protocol.getDir(id));
            }
        } else {
            if (protocol.isMutiFrame(id)) {
                if (logger != null && logger.isLoggable(Level.FINEST)) {
                    logger.finest("\u6536\u5230\u4e00\u4e2a\u591a\u5e27\u4e2d\u7684\u4e00\u5e27,data\uff1a" + BytesTool.byteArrayToHexString(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength()) + " source:" + sourceAddress + " dir:" + protocol.getDir(id) + " index:" + byteArray.getByteArray()[byteArray.getByteArrayOffset() + this.getFrameHeadLength()] + " isEnd:" + protocol.isEndFrame(id));
                }
                if (!this.isSuportMutiFrame()) {
                    if (logger != null && logger.isLoggable(Level.WARNING)) {
                        logger.warning("\u4e0d\u652f\u6301\u591a\u5e27\uff0c\u8be5\u5e27\u88ab\u4e22\u5f03!");
                    }
                    return false;
                }
                return this.handleReceiveMultiFrame(ctx, byteArray, id, protocol);
            }
            boolean isAck = protocol.isACK(id);
            if (logger != null && logger.isLoggable(Level.FINEST)) {
                logger.finest("\u6536\u5230\u4e00\u4e2a\u6570\u636e\u5e27,data:" + BytesTool.byteArrayToHexString(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength()) + " source:" + sourceAddress + " dir:" + protocol.getDir(id) + " ack:" + isAck + " need-reply-ack:" + protocol.isNeedACK(id));
            }
            if (isAck) {
                this.handleACK(ctx, sourceAddress, byteArray.getByteArray()[byteArray.getByteArrayOffset() + this.getFrameHeadLength() + 1], id);
                return false;
            }
            int offset = byteArray.getByteArrayOffset() + this.getFrameHeadLength() + 1;
            byte seq = byteArray.getByteArray()[offset++];
            ByteBuffer buf = ByteBuffer.wrap(byteArray.getByteArray(), offset, byteArray.getByteArrayLength() - offset);
            return this.handleReceiveByteBuffer(buf, ctx, seq, protocol, id);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleReceiveMultiFrame(ProtocolContext ctx, ByteArrayPacket byteArrayPacket, int id, ParkingProtocol protocol) throws Exception {
        Object object;
        ParkingDataFrame frame;
        boolean returnValue = false;
        if (!protocol.isMutiFrame(id)) {
            return returnValue;
        }
        final Logger logger = ctx.getCommunicationHandle().getLogger();
        boolean isEndMultiFrame = protocol.isEndFrame(id);
        ParkingSocketAddress communicationAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
        if (byteArrayPacket instanceof ParkingDataFrame) {
            frame = (ParkingDataFrame)byteArrayPacket;
        } else {
            frame = new ParkingDataFrame();
            frame.setByteArray(byteArrayPacket.getByteArray());
            frame.setByteArrayOffset(byteArrayPacket.getByteArrayOffset());
            frame.setByteArrayLength(byteArrayPacket.getByteArrayLength());
        }
        frame.setId(id);
        int offset = byteArrayPacket.getByteArrayOffset();
        offset += this.getFrameHeadLength();
        frame.setIndex(byteArrayPacket.getByteArray()[offset++]);
        frame.setDataOffset(offset);
        frame.setDataLength(byteArrayPacket.getByteArrayLength() - offset);
        TimeoutObjectPool pool = ctx.getCommunicationHandle().getTimeoutObjectPool();
        Object key = this.getUniqueFrameKey(communicationAddress, id);
        FrameArrayQueue queue = (FrameArrayQueue)pool.getObject(key);
        int index = frame.getIndex() & 0xFF;
        if (queue == null) {
            if (index != 0) {
                if (logger != null && logger.isLoggable(Level.WARNING)) {
                    StringBuilder bu = new StringBuilder(256);
                    bu.append("\u51fa\u73b0\u5e27\u4e22\u5931,\u6536\u5230\u5e27\u7d22\u5f15:").append(index);
                    bu.append(", \u4f46\u4e4b\u524d\u6ca1\u6709\u6536\u5230\u7b2c1\u5e27,\u8be5\u5e27\u5c06\u88ab\u4e22\u5f03!");
                    bu.append(" id=").append(" source=").append(communicationAddress).append(" data=").append(BytesTool.byteArrayToHexString(frame.getByteArray(), frame.getByteArrayOffset(), frame.getByteArrayLength()));
                    logger.warning(bu.toString());
                }
                return returnValue;
            }
            object = this.lockPool;
            synchronized (object) {
                queue = (FrameArrayQueue)pool.getObject(key);
                if (queue == null) {
                    queue = new FrameArrayQueue();
                    pool.addObject(key, queue, new TimeoutObjectPool.TimeoutCallback(){

                        @Override
                        public void onTimeout(Object key, Object object) throws Exception {
                            FrameArrayQueue queue;
                            if (logger != null && logger.isLoggable(Level.WARNING) && (queue = (FrameArrayQueue)object) != null) {
                                StringBuilder bu = new StringBuilder(256);
                                bu.append("\u7b49\u5f85\u5e27\u8d85\u65f6,\u8d85\u65f6\u65f6\u95f4\u4e3a5\u79d2\uff01 ");
                                bu.append("\u5305\u5e8f\u5217:").append(queue.sequence);
                                if (!queue.lostIndex.isEmpty()) {
                                    bu.append(" \u4e22\u5931\u5e27\u7d22\u5f15:").append(queue.lostIndex);
                                }
                                bu.append(" \u662f\u5426\u5df2\u6536\u5230\u7ed3\u675f\u591a\u5e27:");
                                if (queue.finishIndex == -1) {
                                    bu.append("\u5426");
                                } else {
                                    bu.append("\u662f ,\u7ed3\u675f\u591a\u5e27\u7d22\u5f15:").append(queue.finishIndex);
                                }
                                bu.append(" \u8d85\u65f6\u7b49\u5f85\u4e00\u4e2a\u591a\u5e27\u5305! ").append(key);
                                ParkingDataFrame e = queue.get(0);
                                if (e != null) {
                                    bu.append(" \u7b2c\u4e00\u5e27:");
                                    bu.append(" id=").append(e.getId()).append(" data=").append(BytesTool.byteArrayToHexString(e.getByteArray(), e.getByteArrayOffset(), e.getByteArrayLength()));
                                }
                                logger.warning(bu.toString());
                            }
                        }
                    }, 5L, TimeUnit.SECONDS);
                }
            }
        }
        object = queue;
        synchronized (object) {
            if (index == 0) {
                int seq = frame.getByteArray()[frame.getDataOffset()] & 0xFF;
                frame.setDataOffset(frame.getDataOffset() + 1);
                frame.setDataLength(frame.getDataLength() - 1);
                if (queue.sequence == -1) {
                    queue.offer(index, frame);
                    queue.sequence = seq;
                    queue.currentIndex = index;
                    if (isEndMultiFrame) {
                        queue.finishIndex = index;
                    }
                } else if (queue.sequence == seq) {
                    if (logger != null && logger.isLoggable(Level.WARNING)) {
                        StringBuilder bu = new StringBuilder(256);
                        bu.append("\u5305\u5e8f\u5217:").append(seq);
                        bu.append(" \u6536\u5230\u91cd\u590d\u5e27\u7d22\u5f15:").append(index).append(" \u8be5\u5e27\u5c06\u88ab\u4e22\u5f03!");
                        if (!queue.lostIndex.isEmpty()) {
                            bu.append(" \u4e22\u5931\u5e27\u7d22\u5f15:").append(queue.lostIndex);
                        }
                        bu.append(" \u662f\u5426\u5df2\u6536\u5230\u7ed3\u675f\u591a\u5e27:");
                        if (queue.finishIndex == -1) {
                            bu.append("\u5426");
                        } else {
                            bu.append("\u662f ,\u7ed3\u675f\u591a\u5e27\u7d22\u5f15:").append(queue.finishIndex);
                        }
                        bu.append(" id=").append(id).append(" source=").append(communicationAddress).append(" data=").append(BytesTool.byteArrayToHexString(frame.getByteArray(), frame.getByteArrayOffset(), frame.getByteArrayLength()));
                        logger.warning(bu.toString());
                    }
                } else {
                    if (logger != null && logger.isLoggable(Level.WARNING)) {
                        StringBuilder bu = new StringBuilder(256);
                        bu.append("\u51fa\u73b0\u5e27\u4e22\u5931,\u5305\u5e8f\u5217\u4e0d\u6b63\u786e,\u524d\u9762\u7684\u5305\u4e22\u5f03! \u671f\u5f85\u5305\u5e8f\u5217:");
                        bu.append(queue.sequence).append(" \u5f53\u524d\u5305\u5e8f\u5217:").append(seq);
                        bu.append(" \u671f\u5f85\u5305 \u5df2\u7ecf\u6536\u5230\u5e27\u7d22\u5f15:").append(queue.position);
                        if (!queue.lostIndex.isEmpty()) {
                            bu.append(" \u671f\u5f85\u5e27\u7d22\u5f15:").append(queue.lostIndex);
                        }
                        bu.append(" \u662f\u5426\u5df2\u6536\u5230\u7ed3\u675f\u591a\u5e27:");
                        if (queue.finishIndex == -1) {
                            bu.append("\u5426");
                        } else {
                            bu.append("\u662f ,\u7ed3\u675f\u591a\u5e27\u7d22\u5f15:").append(queue.finishIndex);
                        }
                        bu.append(" id=").append(id).append(" source=").append(communicationAddress).append(" data=").append(BytesTool.byteArrayToHexString(frame.getByteArray(), frame.getByteArrayOffset(), frame.getByteArrayLength()));
                        logger.warning(bu.toString());
                    }
                    queue.clear();
                    queue.offer(index, frame);
                    queue.sequence = seq;
                    queue.currentIndex = index;
                    if (isEndMultiFrame) {
                        queue.finishIndex = index;
                    }
                }
            } else if (queue.sequence == -1) {
                if (logger != null && logger.isLoggable(Level.WARNING)) {
                    StringBuilder bu = new StringBuilder(256);
                    bu.append("\u51fa\u73b0\u5e27\u4e22\u5931,\u6536\u5230\u5e27\u7d22\u5f15:").append(index);
                    bu.append(", \u4f46\u4e4b\u524d\u6ca1\u6709\u6536\u5230\u7b2c1\u5e27,\u8be5\u5e27\u5c06\u88ab\u4e22\u5f03!");
                    bu.append(" id=").append(" source=").append(communicationAddress).append(" data=").append(BytesTool.byteArrayToHexString(frame.getByteArray(), frame.getByteArrayOffset(), frame.getByteArrayLength()));
                    logger.warning(bu.toString());
                }
            } else {
                ParkingDataFrame e = queue.get(index);
                if (e == null) {
                    int g = index - queue.currentIndex;
                    if (g > 1) {
                        boolean f = false;
                        int i = queue.currentIndex + 1;
                        while (i < index) {
                            if (queue.get(i) == null) {
                                f = true;
                                queue.lostIndex.add(i);
                            }
                            ++i;
                        }
                        if (f && logger != null && logger.isLoggable(Level.WARNING)) {
                            StringBuilder bu = new StringBuilder(256);
                            bu.append(" \u51fa\u73b0\u5e27\u4e22\u5931, \u53ef\u80fd\u7684\u5305\u5e8f\u5217:").append(queue.sequence).append(" \u5f53\u524d\u6536\u5230\u7684\u5e27\u7d22\u5f15:").append(index).append(" \u5df2\u7ecf\u6536\u5230\u7684\u5e27\u7d22\u5f15:").append(queue.position).append(" \u4e22\u5931\u7684\u5e27\u7d22\u5f15:").append(queue.lostIndex);
                            logger.warning(bu.toString());
                        }
                    }
                    queue.offer(index, frame);
                    queue.lostIndex.remove(index);
                    queue.currentIndex = index;
                    if (isEndMultiFrame) {
                        queue.finishIndex = index;
                    }
                } else if (logger != null && logger.isLoggable(Level.WARNING)) {
                    StringBuilder bu = new StringBuilder(256);
                    bu.append(" \u53ef\u80fd\u7684\u5305\u5e8f\u5217:").append(queue.sequence);
                    bu.append(" \u6536\u5230\u91cd\u590d\u5e27\u7d22\u5f15:").append(index).append(" \u8be5\u5e27\u5c06\u88ab\u4e22\u5f03!");
                    if (!queue.lostIndex.isEmpty()) {
                        bu.append(" \u4e22\u5931\u5e27\u7d22\u5f15:").append(queue.lostIndex);
                    }
                    bu.append(" \u662f\u5426\u5df2\u6536\u5230\u7ed3\u675f\u591a\u5e27:");
                    if (queue.finishIndex == -1) {
                        bu.append("\u5426");
                    } else {
                        bu.append("\u662f ,\u7ed3\u675f\u591a\u5e27\u7d22\u5f15:").append(queue.finishIndex);
                    }
                    bu.append(" id=").append(id).append(" source=").append(communicationAddress).append(" data=").append(BytesTool.byteArrayToHexString(frame.getByteArray(), frame.getByteArrayOffset(), frame.getByteArrayLength()));
                    logger.warning(bu.toString());
                }
            }
            if (queue.finishIndex != -1 && queue.lostIndex.isEmpty()) {
                pool.removeObject(key);
                if (queue.size() == queue.finishIndex + 1) {
                    returnValue = this.handleFrameArrayQueue(queue, id, ctx, protocol);
                } else if (logger != null) {
                    logger.severe("\u51fa\u9519\u4e86,\u961f\u5217\u5927\u5c0f\u4e0e\u7ed3\u675f\u591a\u5e27\u6307\u5b9a\u7684\u7d22\u5f15\u4e0d\u4e00\u81f4!\u5168\u90e8\u5df2\u7ecf\u6536\u5230\u7684\u5e27\u5c06\u4e22\u5f03!!!!!!!!!! queue.size()=" + queue.size() + " \u7ed3\u675f\u5e27\u7d22\u5f15+1:" + (queue.finishIndex + 1));
                }
            }
        }
        return returnValue;
    }

    private boolean handleFrameArrayQueue(FrameArrayQueue queue, int _id, ProtocolContext ctx, ParkingProtocol protocol) throws Exception {
        int nextIndex = 0;
        Logger logger = ctx.getCommunicationHandle().getLogger();
        int len = queue.size();
        ByteBuffer buf = ByteBuffer.allocate(queue.dataCount);
        boolean retf = false;
        Integer zid = null;
        int i = 0;
        while (i < len) {
            block14: {
                ParkingDataFrame xFrame;
                block13: {
                    ParkingSocketAddress sourceAddress;
                    StringBuilder bs;
                    int index;
                    int id;
                    block12: {
                        xFrame = queue.poll(i);
                        if (xFrame == null) {
                            if (logger != null) {
                                logger.severe("\u961f\u5217\u5b58\u53d6\u4e86\u7a7a\u5143\u7d20\uff0c\u81f4\u547d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u961f\u5217\u7ed3\u6784!");
                            }
                            queue.clear();
                            return false;
                        }
                        id = xFrame.getId();
                        if (i == 0) {
                            zid = id;
                        }
                        index = xFrame.getIndex() & 0xFF;
                        if (protocol.isEndFrame(id)) break block12;
                        if (nextIndex == index) break block13;
                        bs = new StringBuilder(256);
                        sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
                        bs.append("\u51fa\u73b0\u4e00\u4e2a\u5e27\u4e22\u5931!\u5f53\u524d\u662f\u975e\u7ed3\u675f\u591a\u5e27.\u671f\u5f85\u5e27\u7d22\u5f15\u4e3a\uff1a").append(nextIndex).append(" \u5f53\u524d\u5e27\u7d22\u5f15\uff1a ").append(xFrame.getIndex()).append(" id=").append(xFrame.getId()).append(" source=").append(sourceAddress).append(" data=").append(BytesTool.byteArrayToHexString(xFrame.getByteArray(), xFrame.getByteArrayOffset(), xFrame.getByteArrayLength()));
                        if (logger != null) {
                            logger.warning(bs.toString());
                        }
                        nextIndex = 0;
                        break block14;
                    }
                    if (nextIndex == 0) {
                        bs = new StringBuilder(256);
                        sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
                        bs.append("\u51fa\u73b0\u4e00\u4e2a\u5e27\u4e22\u5931!\u5f53\u524d\u662f\u7ed3\u675f\u591a\u5e27\uff1a  \u4f46\u4e4b\u524d\u672a\u6536\u5230\u975e\u7ed3\u675f\u591a\u5e27\u7684\u5e27\u5305\uff0c\u6216\u8005\u524d\u9762\u7684\u5e27\u5305\u5df2\u7ecf\u88ab\u4e22\u5f03.").append(" \u5f53\u524d\u5e27\u7d22\u5f15\uff1a ").append(xFrame.getIndex()).append(" id=").append(xFrame.getId()).append(" source=").append(sourceAddress).append(" data=").append(BytesTool.byteArrayToHexString(xFrame.getByteArray(), xFrame.getByteArrayOffset(), xFrame.getByteArrayLength()));
                        if (logger != null) {
                            logger.warning(bs.toString());
                        }
                        nextIndex = 0;
                    } else if (nextIndex != index) {
                        bs = new StringBuilder();
                        sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
                        bs.append("\u51fa\u73b0\u4e00\u4e2a\u5e27\u4e22\u5931!\u5f53\u524d\u662f\u7ed3\u675f\u591a\u5e27.\u671f\u5f85\u5e27\u7d22\u5f15\u4e3a\uff1a ").append(nextIndex).append(" \u5f53\u524d\u5e27\u7d22\u5f15\uff1a ").append(xFrame.getIndex()).append(" id=").append(xFrame.getId()).append(" source=").append(sourceAddress).append(" data=").append(BytesTool.byteArrayToHexString(xFrame.getByteArray(), xFrame.getByteArrayOffset(), xFrame.getByteArrayLength()));
                        if (logger != null) {
                            logger.warning(bs.toString());
                        }
                        nextIndex = 0;
                    } else {
                        buf.put(xFrame.getByteArray(), xFrame.getDataOffset(), xFrame.getDataLength());
                        buf.flip();
                        if (zid == null) {
                            zid = id;
                        }
                        retf = this.handleReceiveByteBuffer(buf, ctx, queue.sequence, protocol, zid);
                    }
                    break block14;
                }
                buf.put(xFrame.getByteArray(), xFrame.getDataOffset(), xFrame.getDataLength());
                ++nextIndex;
            }
            ++i;
        }
        return retf;
    }

    private boolean handleReceiveByteBuffer(ByteBuffer buf, ProtocolContext ctx, int seq, ParkingProtocol protocol, int _id) throws Exception {
        ParkingSocketAddress sourceAddress;
        Logger logger = ctx.getCommunicationHandle().getLogger();
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
            int position = buf.position();
            StringBuilder b = new StringBuilder(256);
            b.append("\u63a5\u6536\u5230\u5b8c\u6574\u5e94\u7528\u6570\u636e\u5305: source:").append(sourceAddress);
            b.append(" sequence:").append(seq).append(" data:").append(BytesTool.byteBufferToHexString(buf));
            logger.finest(b.toString());
            buf.position(position);
        }
        ctx.setMessage(buf);
        if (protocol.isNeedACK(_id)) {
            sourceAddress = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
            this.sendACK(ctx, sourceAddress, (byte)seq, _id, protocol);
        }
        return true;
    }

    protected void handleACK(ProtocolContext ctx, ParkingSocketAddress sourceAddress, byte seq, int id) {
        TimeoutObjectPool timeoutObjectPool = ctx.getCommunicationHandle().getTimeoutObjectPool();
        Logger logger = ctx.getCommunicationHandle().getLogger();
        Object ackkey = this.getAckKey(sourceAddress, seq);
        DirectSendTask task = (DirectSendTask)timeoutObjectPool.removeObject(ackkey);
        if (task != null) {
            if (logger != null && logger.isLoggable(Level.FINEST)) {
                logger.finest("\u6210\u529f\u6536\u5230ACK\u5305,\u5e8f\u5217:" + seq);
            }
            task.setSendTimes(0);
            if (task.getSendCallbackHandler() != null) {
                task.getSendCallbackHandler().onSendCompleted(task.getCommunicationHandle());
            }
        }
    }

    protected void sendACK(ProtocolContext ctx, ParkingSocketAddress sourceAddress, final byte seq, int id, ParkingProtocol protocol) throws Exception {
        AckPacket packet = new AckPacket();
        packet.setAttribute("send.need.ack", Boolean.FALSE);
        packet.setAttribute("send.need.encrypt", Boolean.FALSE);
        packet.setAttribute("send.attempt.times", 1);
        packet.setAttribute("send.direct.priority", 1);
        packet.setAttribute("send.packet.sequence", seq & 0xFF);
        final ParkingSocketAddress communicationAddress = (ParkingSocketAddress)sourceAddress.clone();
        communicationAddress.setBroadCastType(false);
        packet.setAttribute("send.target.address", communicationAddress);
        ctx.getCommunicationHandle().send(packet, new SendCallbackHandler(){

            @Override
            public void onSendTimeout(CommunicationHandle handle) {
                if (handle.getLogger() != null) {
                    handle.getLogger().log(Level.WARNING, "\u53d1\u9001ACK\u8d85\u65f6\u5931\u8d25! seq:" + seq + " destAddress:" + communicationAddress);
                }
            }

            @Override
            public void onSendException(Throwable exception, CommunicationHandle handle) {
                if (handle.getLogger() != null) {
                    handle.getLogger().log(Level.SEVERE, "\u53d1\u9001ACK\u5931\u8d25! seq:" + seq + " destAddress:" + communicationAddress, exception);
                }
            }

            @Override
            public void onSendCompleted(CommunicationHandle handle) {
                if (handle.getLogger() != null && handle.getLogger().isLoggable(Level.FINEST)) {
                    handle.getLogger().log(Level.FINEST, "\u53d1\u9001ACK\u6210\u529f! seq:" + seq + " destAddress:" + communicationAddress);
                }
            }
        });
    }

    protected abstract Object getUniqueFrameKey(ParkingSocketAddress var1, int var2);

    protected abstract Object getAckKey(ParkingSocketAddress var1, byte var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSendSequence() {
        int h;
        if (this.sequenceCouter == null) {
            ParkingProtocolHandler parkingProtocolHandler = this;
            synchronized (parkingProtocolHandler) {
                if (this.sequenceCouter == null) {
                    this.sequenceCouter = new AtomicInteger(-1);
                }
            }
        }
        int MaxSeq = this.getMaxSeqNum();
        while ((h = this.sequenceCouter.incrementAndGet()) > MaxSeq) {
            AtomicInteger atomicInteger = this.sequenceCouter;
            synchronized (atomicInteger) {
                h = this.sequenceCouter.get();
                if (h > MaxSeq) {
                    this.sequenceCouter.set(-1);
                }
            }
        }
        return h;
    }

    protected int getNextSendSequence(ParkingSocketAddress communicationAddress) {
        return this.getNextSendSequence();
    }

    protected int getMaxSeqNum() {
        return 255;
    }

    protected ByteBuffer encrypt(ByteBuffer buffer) throws Exception {
        return buffer;
    }

    protected ByteBuffer decrypt(ByteBuffer buffer) throws Exception {
        return buffer;
    }

    protected int getDefaultHead() {
        return 0;
    }

    protected int getDefaultTag() {
        return 0;
    }

    protected int getDefaultDir() {
        return 0;
    }

    protected boolean getDefaultNeedEncrypt() {
        return false;
    }

    protected boolean getDefaultNeedACK(ParkingSocketAddress communicationAddress) {
        return !communicationAddress.isBroadCastType();
    }

    protected int handleSeq(int seq, ProtocolContext ctx, int sendId) {
        return seq;
    }

    protected abstract int getSingleMaxDataLength();

    protected abstract int getFrameHeadLength();

    protected abstract void handleFramePacket(ParkingDataFramePacket var1, ProtocolContext var2);

    protected boolean isSuportMutiFrame() {
        return true;
    }

    protected ParkingDataFrame poll(int dataLength) {
        ParkingDataFrame frame = new ParkingDataFrame();
        byte[] bs = new byte[dataLength + this.getFrameHeadLength()];
        frame.setByteArray(bs);
        return frame;
    }

    protected void preParseToParkingDataFrame(ByteBuffer appByteBuf, int datalength, byte seq, ParkingDataFrame frame, ParkingProtocol protocol) {
    }

    protected void parseToParkingDataFrame(ByteBuffer appByteBuf, int datalength, byte seq, ParkingDataFrame frame, ParkingProtocol protocol) {
        frame.setByteArrayOffset(0);
        this.preParseToParkingDataFrame(appByteBuf, datalength, seq, frame, protocol);
        int offset = frame.getByteArrayOffset();
        int id = frame.getId();
        byte[] array = frame.getByteArray();
        array[offset++] = (byte)(id << 0 >>> 24);
        array[offset++] = (byte)(id << 8 >>> 24);
        array[offset++] = (byte)(id << 16 >>> 24);
        array[offset++] = (byte)(id << 24 >>> 24);
        if (!protocol.isMutiFrame(id)) {
            array[offset++] = frame.getIndex();
            array[offset++] = seq;
        } else {
            array[offset++] = frame.getIndex();
            if (frame.getIndex() == 0) {
                array[offset++] = seq;
            }
        }
        frame.setDataOffset(offset);
        frame.setDataLength(datalength);
        frame.setByteArrayLength(offset + datalength);
        appByteBuf.get(array, offset, datalength);
    }

    protected boolean isReceiveFromPcFrame(ProtocolContext ctx, int id, ParkingProtocol protocol, ParkingSocketAddress sourceAddress) {
        return true;
    }

    protected boolean isReceiveBroadcast(ProtocolContext ctx, int id, ParkingProtocol protocol, ParkingSocketAddress sourceAddress) {
        return true;
    }

    protected int getIdOffset() {
        return 0;
    }

    public int getIdFromByteArrayPacket(ByteArrayPacket byteArray) {
        int offset = byteArray.getByteArrayOffset() + this.getIdOffset();
        byte[] data = byteArray.getByteArray();
        int id = (data[offset++] & 0xFF) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset++] & 0xFF;
        return id;
    }

    protected static class AckPacket
    extends SimpleAttributeHolder
    implements AppProtocolPacket {
        protected AckPacket() {
        }
    }

    private static class FrameArrayQueue {
        private ParkingDataFrame[] elementData;
        private static int MAX_CAPACITY = 256;
        private Set<Integer> position;
        private Set<Integer> lostIndex;
        private int currentIndex = 0;
        private int sequence = -1;
        private int finishIndex = -1;
        private int dataCount = 0;

        private FrameArrayQueue(int initialCapacity) {
            if (initialCapacity < 0 || initialCapacity > MAX_CAPACITY) {
                initialCapacity = 20;
            }
            this.elementData = new ParkingDataFrame[initialCapacity];
            this.position = new HashSet<Integer>();
            this.lostIndex = new HashSet<Integer>();
        }

        private FrameArrayQueue() {
            this(20);
        }

        private void RangeCheck(int index) {
            if (index >= MAX_CAPACITY || index < 0) {
                String v = "Index: " + index + ", MAX_CAPACITY: " + MAX_CAPACITY + " size:" + this.position.size();
                this.clear();
                throw new IndexOutOfBoundsException(v);
            }
            if (index >= this.elementData.length) {
                int newCapacity;
                if (this.elementData.length == 0) {
                    newCapacity = index + 1;
                } else {
                    newCapacity = this.elementData.length;
                    while (newCapacity <= index) {
                        newCapacity <<= 1;
                    }
                    if (newCapacity > MAX_CAPACITY) {
                        newCapacity = MAX_CAPACITY;
                    }
                }
                this.elementData = Arrays.copyOf(this.elementData, newCapacity);
            }
        }

        private ParkingDataFrame set(int index, ParkingDataFrame element) {
            this.RangeCheck(index);
            ParkingDataFrame oldValue = this.elementData[index];
            this.elementData[index] = element;
            if (element == null && oldValue != null) {
                this.position.remove(index);
            } else if (element != null && oldValue == null) {
                this.position.add(index);
            }
            return oldValue;
        }

        private ParkingDataFrame get(int index) {
            this.RangeCheck(index);
            return this.elementData[index];
        }

        private ParkingDataFrame poll(int index) {
            ParkingDataFrame e = this.get(index);
            this.set(index, null);
            if (e != null) {
                this.dataCount -= e.getDataLength();
            }
            return e;
        }

        private ParkingDataFrame offer(int index, ParkingDataFrame element) {
            if (element != null) {
                this.dataCount += element.getDataLength();
            }
            return this.set(index, element);
        }

        private void clear() {
            if (!this.position.isEmpty()) {
                Iterator<Integer> it = this.position.iterator();
                while (it.hasNext()) {
                    Integer intedx = it.next();
                    ParkingDataFrame frame = this.elementData[intedx];
                    this.elementData[intedx.intValue()] = null;
                    it.remove();
                    if (frame == null) continue;
                    frame.recycle();
                }
            }
            this.lostIndex.clear();
            this.currentIndex = 0;
            this.sequence = -1;
            this.finishIndex = -1;
            this.dataCount = 0;
        }

        private int size() {
            return this.position.size();
        }
    }
}

