/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.communication.OpType;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;

public class ReadWriteProtocolHandlerChain
implements ProtocolHandlerChain {
    private ProtocolHandler readTailHandler;
    private ProtocolHandler writeHeadHandler;

    public ReadWriteProtocolHandlerChain appendNextProtocolHandler(ProtocolHandler protocolHandler) {
        if (protocolHandler != null && !this.isExist(protocolHandler)) {
            if (this.writeHeadHandler == null) {
                this.writeHeadHandler = protocolHandler;
            }
            if (this.readTailHandler != null) {
                this.readTailHandler.setNextProtocolHandler(protocolHandler);
                protocolHandler.setPreviousProtocolHandler(this.readTailHandler);
            }
            this.readTailHandler = protocolHandler;
        }
        return this;
    }

    private boolean isExist(ProtocolHandler protocolHandler) {
        ProtocolHandler head = this.writeHeadHandler;
        while (head != null) {
            if (head == protocolHandler) {
                return true;
            }
            head = head.getNextProtocolHandler();
        }
        return false;
    }

    @Override
    public void execute(ProtocolContext ctx) throws Exception {
        OpType opType = ctx.getOpType();
        if (opType == OpType.OP_READ) {
            if (this.readTailHandler != null) {
                this.readTailHandler.protocolHandle(ctx);
            }
        } else if (opType == OpType.OP_WRITE) {
            if (this.writeHeadHandler != null) {
                this.writeHeadHandler.protocolHandle(ctx);
            }
        } else {
            throw new Exception("Unknown OpType!");
        }
    }
}

