/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.DefaultDirectSendTask;
import com.wovoe.framework.communication.DirectSendTask;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.SendCallbackHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class RootWriteProtocolHandler
extends AbstractProtocolHandler {
    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        return true;
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        Integer px;
        TimeUnit unit;
        long timeout;
        Long tout;
        ByteArrayPacket[] sendPackets = (ByteArrayPacket[])ctx.getMessage();
        if (sendPackets == null) {
            throw new Exception("Send packet is null!");
        }
        Object ackKey = ctx.getAttribute("send.ack.key");
        final SendCallbackHandler sendCallbackHandler1 = (SendCallbackHandler)ctx.getAttribute("send.callback.handler");
        SendCallbackHandler sendCallbackHandler = new SendCallbackHandler(){
            AtomicBoolean recall = new AtomicBoolean(false);

            @Override
            public void onSendCompleted(CommunicationHandle handle) {
                if (this.recall.compareAndSet(false, true) && sendCallbackHandler1 != null) {
                    sendCallbackHandler1.onSendCompleted(handle);
                }
            }

            @Override
            public void onSendException(Throwable exception, CommunicationHandle handle) {
                if (this.recall.compareAndSet(false, true) && sendCallbackHandler1 != null) {
                    sendCallbackHandler1.onSendException(exception, handle);
                }
                if (sendCallbackHandler1 == null) {
                    handle.getLogger().log(Level.SEVERE, "", exception);
                }
            }

            @Override
            public void onSendTimeout(CommunicationHandle handle) {
                if (this.recall.compareAndSet(false, true) && sendCallbackHandler1 != null) {
                    sendCallbackHandler1.onSendTimeout(handle);
                }
            }
        };
        CommunicationHandle communicationHandle = ctx.getCommunicationHandle();
        ctx.setAttribute("send.callback.handler", sendCallbackHandler);
        Integer at = (Integer)ctx.getAttribute("send.attempt.times");
        int attemptTimes = at != null ? at.intValue() : communicationHandle.getAttemptsToSend();
        if (attemptTimes < 1) {
            attemptTimes = 1;
        }
        if ((tout = (Long)ctx.getAttribute("send.wait.ack.timeout")) != null) {
            timeout = tout;
            unit = TimeUnit.MILLISECONDS;
        } else {
            timeout = communicationHandle.getWaitAckTimeout();
            unit = communicationHandle.getWaitAckTimeoutTimeUnit();
        }
        if (timeout < 0L) {
            timeout = 200L;
            unit = TimeUnit.MILLISECONDS;
        }
        if ((px = (Integer)ctx.getAttribute("send.direct.priority")) == null) {
            px = new Integer(0);
        }
        DirectSendTask.Priority p = px <= 0 ? DirectSendTask.Priority.NORM_PRIORITY : DirectSendTask.Priority.MAX_PRIORITY;
        DefaultDirectSendTask task = new DefaultDirectSendTask(p, communicationHandle, sendPackets, 0, sendPackets.length, sendCallbackHandler, communicationHandle.getTimeoutObjectPool(), attemptTimes, ackKey, timeout, unit);
        communicationHandle.submit(task);
        return false;
    }
}

