/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.communication.AppTLVPacket;
import com.wovoe.framework.communication.Protocol;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class TLVProtocol
implements Protocol {
    private static TLVProtocol protocol;
    private static final int MAIN_TAG_TYPE = 0;
    private static final int SUB_TAG_TYPE = 1;
    private static final int VALUE_LEN1_TYPE = 2;
    private static final int VALUE_LEN2_TYPE = 3;
    private static final int DATA_TYPE = 4;

    public static TLVProtocol getInstance() {
        if (protocol == null) {
            protocol = new TLVProtocol();
        }
        return protocol;
    }

    protected TLVProtocol() {
    }

    public boolean haveSubTag(byte mainTag) {
        return mainTag << 24 >>> 31 == 1;
    }

    public boolean isNestedTag(byte mainTag) {
        return mainTag << 25 >>> 31 == 1;
    }

    public byte getMainTagValue(byte mainTag) {
        return (byte)(mainTag << 26 >>> 26);
    }

    public byte generateMainTag(byte mainTagValue, boolean needSubTag, boolean needNestedTag) {
        byte mainTag = (byte)(mainTagValue << 26 >>> 26);
        if (needSubTag && !needNestedTag) {
            mainTag = (byte)(0x80 | mainTag);
        } else if (!needSubTag && needNestedTag) {
            mainTag = (byte)(0x40 | mainTag);
        } else if (needSubTag && needNestedTag) {
            mainTag = (byte)(0xC0 | mainTag);
        }
        return mainTag;
    }

    public int getLengthBytesLength(int length) {
        if (length > 127) {
            return 2;
        }
        return 1;
    }

    public int getTagBytesLength(byte mainTag) {
        if (this.haveSubTag(mainTag)) {
            return 2;
        }
        return 1;
    }

    public ByteBuffer parseTLVPacketToByteBuffer(AppTLVPacket tlv) {
        int size = tlv.calculateValueLength() + tlv.getTagBytesLength() + tlv.getLengthBytesLength();
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.putBuffer(tlv, buf);
        buf.flip();
        return buf;
    }

    protected void putBuffer(AppTLVPacket packet, ByteBuffer buffer) {
        if (packet == null) {
            return;
        }
        if (buffer == null) {
            return;
        }
        buffer.put(packet.getMainTag());
        if (packet.haveSubTag()) {
            buffer.put(packet.getSubTag());
        }
        if (packet.getValueLength() > 127) {
            short l = (short)(packet.getValueLength() << 17 >>> 17 | 0x8000);
            buffer.putShort(l);
        } else {
            buffer.put((byte)packet.getValueLength());
        }
        if (!packet.isNestedTag()) {
            buffer.put(packet.getDataValue(), 0, packet.getValueLength());
            return;
        }
        if (!packet.haveChildren()) {
            return;
        }
        for (AppTLVPacket p : packet.getChildren()) {
            assert (p != packet);
            this.putBuffer(p, buffer);
        }
    }

    public AppTLVPacket parseByteBufferToTLVPacket(byte[] buf, int offset, int length) throws Exception {
        int end = offset + length;
        if (buf == null || length == 0 || buf.length < end) {
            return null;
        }
        int nextType = 0;
        AppTLVPacket tlv = null;
        ArrayDeque<AppTLVPacket> stack = new ArrayDeque<AppTLVPacket>();
        block0: while (offset < end) {
            byte b = buf[offset];
            ++offset;
            if (nextType == 0) {
                tlv = new AppTLVPacket();
                stack.push(tlv);
            }
            if ((nextType = this.handleByte(nextType, tlv, b)) != 4) continue;
            tlv.setDataValue(buf);
            tlv.setDataValueOffset(offset);
            tlv.setDataValueLength(tlv.getValueLength());
            tlv.setCurrentValueLength(tlv.getValueLength());
            offset += tlv.getDataValueLength();
            nextType = 0;
            while (!stack.isEmpty()) {
                tlv = (AppTLVPacket)stack.pop();
                AppTLVPacket p = (AppTLVPacket)stack.peek();
                if (p == null) continue;
                int glength = p.getCurrentValueLength() + tlv.getTagBytesLength() + tlv.getLengthBytesLength() + tlv.getCurrentValueLength();
                if (p.getValueLength() >= glength) {
                    p.appendChild(tlv);
                    tlv.setParent(p);
                    p.setCurrentValueLength(glength);
                    if (p.getValueLength() <= glength) continue;
                    continue block0;
                }
                throw new Exception("TLV\u5b57\u8282\u6d41\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\uff01");
            }
        }
        if (!stack.isEmpty()) {
            throw new Exception("TLV\u5b57\u8282\u6d41\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\uff01");
        }
        return tlv;
    }

    private int handleByte(int type, AppTLVPacket tlv, byte b) {
        int nextType = type;
        switch (type) {
            case 0: {
                nextType = this.haveSubTag(b) ? 1 : 2;
                tlv.setMainTag(b);
                break;
            }
            case 1: {
                tlv.setSubTag(b);
                nextType = 2;
                break;
            }
            case 2: {
                int valueLength = b << 25 >>> 25;
                tlv.setValueLength(valueLength);
                if (b << 24 >>> 31 == 1) {
                    nextType = 3;
                    break;
                }
                if (tlv.isNestedTag()) {
                    nextType = 0;
                    break;
                }
                nextType = 4;
                break;
            }
            case 3: {
                tlv.setValueLength(tlv.getValueLength() << 8 | b << 24 >>> 24);
                nextType = tlv.isNestedTag() ? 0 : 4;
            }
        }
        return nextType;
    }

    public AppTLVPacket parseByteBufferToTLVPacket(ByteBuffer tlvByteBuffer) throws Exception {
        int length;
        int offset;
        byte[] buf;
        if (tlvByteBuffer == null || !tlvByteBuffer.hasRemaining()) {
            return null;
        }
        if (tlvByteBuffer.hasArray()) {
            buf = tlvByteBuffer.array();
            offset = tlvByteBuffer.arrayOffset() + tlvByteBuffer.position();
            length = tlvByteBuffer.remaining();
        } else {
            offset = 0;
            length = tlvByteBuffer.remaining();
            buf = new byte[length];
            int pos = tlvByteBuffer.position();
            tlvByteBuffer.get(buf);
            tlvByteBuffer.position(pos);
        }
        try {
            return this.parseByteBufferToTLVPacket(buf, offset, length);
        }
        catch (Exception ex) {
            Exception e = new Exception("\u9519\u8bef\u89e3\u6790TLV,\u6570\u636e:" + BytesTool.byteArrayToHexString(buf, offset, length));
            e.initCause(ex.getCause());
            throw e;
        }
    }
}

