/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.AppTLVPacket;
import com.wovoe.framework.communication.ParkingSocketAddress;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.TLVProtocol;
import java.nio.ByteBuffer;

public class TLVProtocolHandler
extends AbstractProtocolHandler {
    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer buf = (ByteBuffer)ctx.getMessage();
        if (buf != null) {
            ParkingSocketAddress address = (ParkingSocketAddress)ctx.getAttribute("receive.source.address");
            AppTLVPacket tlvPacket = TLVProtocol.getInstance().parseByteBufferToTLVPacket(buf);
            tlvPacket.setAttribute("receive.source.address", address);
            ctx.setMessage(tlvPacket);
        }
        return true;
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        AppProtocolPacket appPacket = (AppProtocolPacket)ctx.getMessage();
        if (appPacket == null) {
            return false;
        }
        if (appPacket instanceof AppTLVPacket) {
            AppTLVPacket rootTLV = (AppTLVPacket)appPacket;
            ByteBuffer tlvBuf = TLVProtocol.getInstance().parseTLVPacketToByteBuffer(rootTLV);
            ctx.setMessage(tlvBuf);
        }
        return true;
    }
}

