/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.TransportProtocol;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.Sender;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class HMPAppPacket
implements AppProtocolPacket,
Receiver,
Sender {
    protected Map<String, Object> attributes;
    private Map<String, Object> headerMap = new LinkedHashMap<String, Object>();
    private String charset;
    private byte[] data;
    private int dataOffset;
    private int dataLength;
    private String actionName;
    private boolean needEncrypt = false;
    private int sendId;
    private int remoteSendId;
    private TransportProtocol transportProtocol;
    private SocketAddress remoteAddress;
    private SocketAddress localAddress;
    private HMPResponseSenderFactory senderFactory;
    private boolean response;
    private ReceiveCallback receiveCallback;

    protected Map<String, Object> newAttributesMap() {
        return new HashMap<String, Object>();
    }

    Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Object removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = this.newAttributesMap();
        }
        this.attributes.put(name, value);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.enumeration(new ArrayList(0));
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    @Override
    public String getHeaderValue(String name) {
        Object obj = this.headerMap.get(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Queue) {
                Queue c = (Queue)obj;
                Object xo = c.peek();
                if (xo != null) {
                    if (xo instanceof String) {
                        return (String)xo;
                    }
                    return xo.toString();
                }
                return null;
            }
            String[] s = this.getHeaderValues(name);
            if (s == null || s.length == 0) {
                return null;
            }
            return s[0];
        }
        return null;
    }

    @Override
    public String[] getHeaderValues(String name) {
        Object obj = this.headerMap.get(name);
        if (obj != null) {
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            if (obj instanceof Collection) {
                Collection c = (Collection)obj;
                return c.toArray(new String[c.size()]);
            }
            return new String[]{obj.toString()};
        }
        return null;
    }

    @Override
    public void addHeader(String name, String value) {
        this.addHeader(name, value, true);
    }

    public void addHeader(String name, String value, boolean last) {
        if (name == null || value == null) {
            return;
        }
        Object obj = this.headerMap.get(name);
        if (obj == null) {
            this.headerMap.put(name, value);
        } else {
            LinkedList<String> list;
            if (obj instanceof String) {
                list = new LinkedList<String>();
                this.headerMap.put(name, list);
                list.addLast((String)obj);
            } else {
                list = (LinkedList<String>)obj;
            }
            if (last) {
                list.addLast(value);
            } else {
                list.addFirst(value);
            }
        }
    }

    public void addFirstHeader(String name, String value) {
        this.addHeader(name, value, false);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name != null && value != null) {
            this.headerMap.put(name, value);
        }
    }

    public String removeHeaderValue(String name, boolean last) {
        if (name == null) {
            return null;
        }
        Object obj = this.headerMap.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)this.headerMap.remove(name);
        }
        LinkedList list = (LinkedList)obj;
        obj = last ? list.removeLast() : list.removeFirst();
        if (list.isEmpty()) {
            this.headerMap.remove(name);
        }
        return (String)obj;
    }

    public String removeFirstHeaderValue(String name) {
        return this.removeHeaderValue(name, false);
    }

    public String removeLastHeaderValue(String name) {
        return this.removeHeaderValue(name, true);
    }

    @Override
    public void resetHeader() {
        this.headerMap.clear();
    }

    @Override
    public void setSendData(byte[] data) {
        this.setSendData(data, 0, data == null ? 0 : data.length);
    }

    @Override
    public void setSendData(byte[] data, int offset, int length) {
        this.setData(data, offset, length);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setNeedEncrypt(boolean needEncrypt) {
        this.needEncrypt = needEncrypt;
    }

    @Override
    public boolean isNeedEncrypt() {
        return this.needEncrypt;
    }

    public int getSendId() {
        return this.sendId;
    }

    public void setSendId(int sendId) {
        this.sendId = sendId;
    }

    @Override
    public ResponseSender createResponse() throws IOException {
        return this.senderFactory.createResponseSender(this);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data, int offset, int length) {
        this.data = data;
        this.dataOffset = offset;
        this.dataLength = length;
    }

    @Override
    public int getDataOffset() {
        return this.dataOffset;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(TransportProtocol p) {
        this.transportProtocol = p;
    }

    @Override
    public int getRemoteSendId() {
        return this.remoteSendId;
    }

    public void setRemoteSendId(int remoteSendId) {
        this.remoteSendId = remoteSendId;
    }

    public int getRemoteRequestId() {
        return this.getRemoteSendId();
    }

    public HMPResponseSenderFactory getSenderFactory() {
        return this.senderFactory;
    }

    public void setSenderFactory(HMPResponseSenderFactory senderFactory) {
        this.senderFactory = senderFactory;
    }

    public boolean isResponse() {
        return this.response;
    }

    public void setResponse(boolean response) {
        this.response = response;
    }

    public ReceiveCallback getReceiveCallback() {
        return this.receiveCallback;
    }

    public void setReceiveCallback(ReceiveCallback receiveCallback) {
        this.receiveCallback = receiveCallback;
    }
}

