/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class HMPAppProtocolHandler
extends AbstractProtocolHandler {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final char a = '?';
    private static final String b = "&";
    private static final char c = '=';
    private static final char g = '&';
    private static final String HEAD_RESPONSE = "R";
    private static final String HEAD_RQUESTID = "D";
    private static final String HEAD_TRUE = "1";
    private static final String HEAD_FALSE = "0";
    private static final String WAIT_KEYP_PREX = "parks-response@_*callbck%!-#";
    private HMPResponseSenderFactory senderFactory;
    private ServiceActionManager actionManager;

    public HMPAppProtocolHandler(HMPResponseSenderFactory senderFactory, ServiceActionManager actionManager) {
        this.senderFactory = senderFactory;
        this.actionManager = actionManager;
    }

    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer appBuf = (ByteBuffer)ctx.getMessage();
        if (appBuf == null || appBuf.remaining() == 0) {
            ctx.getCommunicationHandle().getLogger().warning("\u6570\u636e\u4e3a\u7a7a!");
            return false;
        }
        Integer id = (Integer)ctx.getAttribute("receive.request.id");
        if (id == null) {
            ctx.getCommunicationHandle().getLogger().warning("\u8bf7\u6c42id\u4e3a\u7a7a!");
            return false;
        }
        HMPAppPacket appPacket = new HMPAppPacket();
        appPacket.setRemoteSendId(id);
        appPacket.setTransportProtocol(ctx.getCommunicationHandle().protocol());
        appPacket.setLocalAddress(ctx.getCommunicationHandle().getLocalAddress());
        SocketAddress receiveAddress = (SocketAddress)ctx.getAttribute("receive.source.address");
        appPacket.setRemoteAddress(receiveAddress);
        appPacket.setSenderFactory(this.senderFactory);
        if (this.handleDataPacket(appPacket, ctx, appBuf, receiveAddress)) {
            ServiceAction action;
            String R = appPacket.removeFirstHeaderValue(HEAD_RESPONSE);
            if (HEAD_TRUE.equals(R)) {
                String D = appPacket.removeFirstHeaderValue(HEAD_RQUESTID);
                int sendId = Integer.parseInt(D);
                ReceiveCallback callback = (ReceiveCallback)ctx.getCommunicationHandle().getTimeoutObjectPool().removeObject(this.getWaitKey(sendId));
                if (callback != null) {
                    callback.doReceiver(appPacket, sendId);
                }
                return false;
            }
            if (this.actionManager != null && (action = this.actionManager.getAction(appPacket.getActionName())) != null) {
                action.service(appPacket);
            }
            return false;
        }
        return false;
    }

    protected Object getWaitKey(int id) {
        return new XWaitKey(WAIT_KEYP_PREX, this.hashCode(), id);
    }

    private String getString(ByteBuffer packet, int len, String charset) throws UnsupportedEncodingException {
        int offset;
        byte[] array;
        if (packet.hasArray()) {
            array = packet.array();
            offset = packet.arrayOffset() + packet.position();
            packet.position(packet.position() + len);
        } else {
            array = new byte[len];
            packet.get(array);
            offset = 0;
        }
        String str = new String(array, offset, len, charset);
        return str;
    }

    protected boolean handleDataPacket(HMPAppPacket appPacket, ProtocolContext ctx, ByteBuffer packet, SocketAddress receiveAddress) throws Exception {
        int plen;
        if (!packet.hasRemaining()) {
            ctx.getCommunicationHandle().getLogger().warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,\u7f3a\u5c11\u57dfCHARSET\u957f\u5ea6");
            return false;
        }
        int len = packet.get() & 0xFF;
        if (len > packet.remaining()) {
            ctx.getCommunicationHandle().getLogger().warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,CHARSET\u957f\u5ea6\u975e\u6cd5:" + len);
            return false;
        }
        String charset = this.getString(packet, len, ISO_8859_1);
        if (packet.remaining() < 4) {
            ctx.getCommunicationHandle().getLogger().warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,\u7f3a\u5c11\u57dfHEAD\u957f\u5ea6");
            return false;
        }
        len = packet.getInt();
        if (len > packet.remaining()) {
            ctx.getCommunicationHandle().getLogger().warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,HEAD\u957f\u5ea6\u975e\u6cd5:" + len);
            return false;
        }
        String url = this.getString(packet, len, charset);
        int gindex = url.indexOf(63);
        String actionName = gindex != -1 ? url.substring(0, gindex) : url;
        appPacket.setCharset(charset);
        appPacket.setActionName(actionName);
        if (url.length() > actionName.length() + 1) {
            String param = url.substring(actionName.length() + 1);
            StringTokenizer tokens = new StringTokenizer(param, b);
            while (tokens.hasMoreTokens()) {
                int g;
                String entry = tokens.nextToken();
                if (entry.length() <= 0 || (g = entry.indexOf(61)) == -1) continue;
                String key = URLDecoder.decode(entry.substring(0, g), charset);
                String value = URLDecoder.decode(entry.substring(g + 1, entry.length()), charset);
                appPacket.addHeader(key, value);
            }
        }
        if (packet.remaining() > 4 && (plen = packet.getInt()) <= packet.remaining()) {
            int offset;
            byte[] data;
            if (!packet.hasArray()) {
                data = new byte[plen];
                packet.get(data);
                offset = 0;
            } else {
                data = packet.array();
                offset = packet.arrayOffset() + packet.position();
            }
            appPacket.setData(data, offset, plen);
        }
        ctx.setMessage(appPacket);
        return true;
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        Object mess = ctx.getMessage();
        if (mess == null) {
            return false;
        }
        if (!(mess instanceof HMPAppPacket)) {
            return true;
        }
        HMPAppPacket appPacket = (HMPAppPacket)ctx.getMessage();
        if (appPacket.getCharset() == null) {
            appPacket.setCharset(DEFAULT_CHARSET);
        }
        if (appPacket.isResponse()) {
            appPacket.addFirstHeader(HEAD_RESPONSE, HEAD_TRUE);
            appPacket.addFirstHeader(HEAD_RQUESTID, String.valueOf(appPacket.getRemoteRequestId()));
        } else {
            appPacket.addFirstHeader(HEAD_RESPONSE, HEAD_FALSE);
        }
        StringBuilder bu = new StringBuilder(128);
        bu.append(appPacket.getActionName()).append('?');
        for (Map.Entry<String, Object> entry : appPacket.getHeaderMap().entrySet()) {
            if (entry.getValue() instanceof String) {
                bu.append(URLEncoder.encode(entry.getKey(), appPacket.getCharset())).append('=').append(URLEncoder.encode((String)entry.getValue(), appPacket.getCharset())).append('&');
                continue;
            }
            if (!(entry.getValue() instanceof Collection)) continue;
            Collection s = (Collection)entry.getValue();
            for (Object o : s) {
                bu.append(URLEncoder.encode(entry.getKey(), appPacket.getCharset())).append('=').append(URLEncoder.encode(o.toString(), appPacket.getCharset())).append('&');
            }
        }
        ByteBuffer buf = this.toDataByteBuffer(bu.toString(), appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength(), appPacket.getCharset());
        ctx.setMessage(buf);
        ctx.setAttribute("send.id", appPacket.getSendId());
        ctx.setAttribute("send.need.encrypt", appPacket.isNeedEncrypt());
        final ReceiveCallback rcallback = appPacket.getReceiveCallback();
        if (rcallback != null) {
            ctx.getCommunicationHandle().getTimeoutObjectPool().addObject(this.getWaitKey(appPacket.getSendId()), rcallback, new TimeoutObjectPool.TimeoutCallback(){

                @Override
                public void onTimeout(Object key, Object object) throws Exception {
                    rcallback.onWaitTimeout();
                }
            }, rcallback.getWaitTimeoutMills(), TimeUnit.MILLISECONDS);
        }
        return true;
    }

    protected ByteBuffer toDataByteBuffer(String simpleUrl, byte[] data, int offset, int length, String charset) throws IllegalArgumentException {
        byte[] charsetb;
        byte[] b1;
        if (simpleUrl == null) {
            return null;
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            b1 = simpleUrl.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            charsetb = charset.getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            charsetb = charset.getBytes();
        }
        if (charsetb.length > 255) {
            charsetb = DEFAULT_CHARSET.getBytes();
        }
        int len = 1 + charsetb.length + b1.length + 4 + (data == null ? 0 : length + 4);
        ByteBuffer b = ByteBuffer.allocate(len);
        b.put((byte)charsetb.length);
        b.put(charsetb);
        b.putInt(b1.length);
        b.put(b1);
        if (data != null) {
            b.putInt(length);
            b.put(data, offset, length);
        }
        b.flip();
        return b;
    }

    private static final class XWaitKey {
        private String name;
        private int v;
        private int id;

        public XWaitKey(String name, int v, int id) {
            this.name = name;
            this.v = v;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.v;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XWaitKey other = (XWaitKey)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.v == other.v;
        }
    }
}

