/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.communication.protocol.Client;
import com.wovoe.framework.communication.protocol.ClientManager;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class HMPClientManager
implements ClientManager {
    protected ConcurrentHashMap<SocketAddress, Client> map = new ConcurrentHashMap();

    @Override
    public Enumeration<Client> getClients() {
        return Collections.enumeration(this.map.values());
    }

    @Override
    public Client getClient(SocketAddress address) {
        if (address == null) {
            return null;
        }
        return this.map.get(address);
    }

    @Override
    public synchronized void addClient(Client client) {
        if (client == null) {
            return;
        }
        Client cl = this.map.putIfAbsent(client.getRemoteAddress(), client);
        if (cl != null) {
            if (cl != client) {
                this.removeClient(cl);
                cl.close();
            } else {
                return;
            }
        }
        if (client.isClosing()) {
            this.removeClient(client);
        }
    }

    @Override
    public synchronized void removeClient(Client client) {
        if (client == null) {
            return;
        }
        this.map.remove(client.getRemoteAddress());
    }
}

