/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class HMPFrameProtocolHandler
extends AbstractProtocolHandler {
    public static final int DEFAULTLENTH = 1024;
    private int maxFrameLength;
    private CryptoFactory cryptoFactory;

    public HMPFrameProtocolHandler() {
        this(1024);
    }

    public HMPFrameProtocolHandler(int maxFrameLength) {
        this(maxFrameLength, null);
    }

    public HMPFrameProtocolHandler(int maxFrameLength, CryptoFactory cryptoFactory) {
        if (maxFrameLength <= 0) {
            maxFrameLength = 1024;
        }
        this.maxFrameLength = maxFrameLength;
        if (cryptoFactory == null) {
            cryptoFactory = this.newDefaultCryptoFactory();
        }
        this.cryptoFactory = cryptoFactory;
    }

    protected CryptoFactory newDefaultCryptoFactory() {
        return new CryptoFactory(){

            @Override
            public ByteBuffer encrypt(ByteBuffer dataBuf) throws Exception {
                return dataBuf;
            }

            @Override
            public ByteBuffer decrypt(ByteBuffer encryptBuffer) throws Exception {
                return encryptBuffer;
            }
        };
    }

    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer byteBuf = null;
        Object byteArray1 = ctx.getMessage();
        if (byteArray1 != null) {
            if (byteArray1 instanceof ByteArrayPacket) {
                ByteArrayPacket byteArray = (ByteArrayPacket)byteArray1;
                byteBuf = byteArray instanceof ByteBufferPacket ? ((ByteBufferPacket)byteArray).getByteBuffer() : ByteBuffer.wrap(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength());
            } else if (byteArray1 instanceof ByteBuffer) {
                byteBuf = (ByteBuffer)byteArray1;
            } else {
                ctx.getCommunicationHandle().getLogger().warning(" unknown receive message type!" + byteArray1.getClass());
                return false;
            }
        }
        if (byteBuf == null) {
            ctx.getCommunicationHandle().getLogger().warning("receive bytebuffer is null!");
            return false;
        }
        SocketAddress receiveAddress = (SocketAddress)ctx.getAttribute("receive.source.address");
        if (receiveAddress == null) {
            ctx.getCommunicationHandle().getLogger().warning("receive source address is null!");
            return false;
        }
        return this.handlePacket(ctx.getCommunicationHandle().getLogger(), byteBuf, receiveAddress, ctx);
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        ByteBufferPacket[] bf;
        SocketAddress communicationAddress = (SocketAddress)ctx.getAttribute("send.target.address");
        Integer sendId = (Integer)ctx.getAttribute("send.id");
        if (sendId == null) {
            ctx.getCommunicationHandle().getLogger().warning("send id is null!");
            return false;
        }
        ByteBuffer appByteBuf = (ByteBuffer)ctx.getMessage();
        if (appByteBuf == null) {
            ctx.getCommunicationHandle().getLogger().warning("send appByteBuf is null!");
            return false;
        }
        Boolean isNeedEncrypt = (Boolean)ctx.getAttribute("send.need.encrypt");
        if (isNeedEncrypt == null) {
            isNeedEncrypt = this.getDefaultNeedEncrypt();
        }
        if (isNeedEncrypt.booleanValue()) {
            appByteBuf = this.encrypt(appByteBuf);
        }
        if ((bf = this.toSendBuffers(appByteBuf, sendId, isNeedEncrypt, this.getMaxFrameLength(), communicationAddress)) != null && bf.length > 0) {
            ctx.setMessage(bf);
            return true;
        }
        return false;
    }

    private ByteBufferPacket[] toSendBuffers(ByteBuffer dataBuf, int id, boolean isEncrypted, int multiLen, SocketAddress socketAddress) {
        int xpos = dataBuf.position();
        int x = isEncrypted ? 128 : 0;
        int len = dataBuf.remaining();
        int xlimit = dataBuf.limit();
        int n = len % multiLen;
        n = n == 0 ? len / multiLen : len / multiLen + 1;
        ByteBufferPacket[] bufs = new ByteBufferPacket[n];
        int poxz = 0;
        int i = 0;
        while (i < n) {
            dataBuf.position(poxz);
            if (i == n - 1) {
                x |= 0x20;
                dataBuf.limit(xlimit);
            } else {
                dataBuf.limit(poxz += multiLen);
            }
            int zindex = x << 24 | i << 8 >>> 8;
            ByteBuffer c = ByteBuffer.allocate(dataBuf.remaining() + 8);
            c.putInt(id);
            c.putInt(zindex);
            c.put(dataBuf);
            c.flip();
            bufs[i] = new ByteBufferPacket(c, socketAddress);
            ++i;
        }
        dataBuf.position(xpos);
        return bufs;
    }

    private void cachePacket(final Logger logger, ByteBuffer packet, WaitKey key, TimeoutObjectPool pool, BufferInputStream bi, boolean needCopy) {
        ByteBuffer copyPacket;
        if (needCopy) {
            int pos = packet.position();
            copyPacket = ByteBuffer.allocate(packet.remaining());
            copyPacket.put(packet);
            copyPacket.flip();
            packet.position(pos);
        } else {
            copyPacket = packet;
        }
        bi.append(copyPacket);
        pool.addObject(key, bi, new TimeoutObjectPool.TimeoutCallback(){

            @Override
            public void onTimeout(Object key, Object object) throws Exception {
                BufferInputStream in = (BufferInputStream)object;
                if (logger != null) {
                    logger.warning(key + "\u7b49\u5f85\u591a\u5e27\u4e2d\u7684\u4e0b\u4e00\u5e27\u8d85\u65f65\u79d2\uff0c\u671f\u5f85\u4e0b\u4e00\u5e27\u7d22\u5f15:" + in.getBufferSize() + "\uff0c\u8fd9\u5c06\u4e22\u5f03\u4e4b\u524d\u7684\u6570\u636e\u3002\u5df2\u7ecf\u6536\u5230" + in.getBufferSize() + "\u5e27\u6570\u636e\u3002");
                }
            }
        }, 5L, TimeUnit.SECONDS);
    }

    protected boolean handlePacket(Logger logger, ByteBuffer packet, SocketAddress receiveAddress, ProtocolContext ctx) throws Exception {
        if (packet.remaining() < 8) {
            logger.warning("\u534f\u8bae\u89e3\u6790\u9519\u8bef!\u7f3a\u5c11ID,INDEX!\u4e22\u5f03\u8be5\u5305!");
            return false;
        }
        int id = packet.getInt();
        int index = packet.getInt();
        boolean isEncrypted = index >>> 31 == 1;
        boolean isFrameEncrypted = index << 1 >>> 31 == 1;
        boolean isEnd = index << 2 >>> 31 == 1;
        index = index << 8 >>> 8;
        TimeoutObjectPool pool = ctx.getCommunicationHandle().getTimeoutObjectPool();
        if (index == 0) {
            if (!isEnd) {
                WaitKey key = new WaitKey(receiveAddress, id);
                Object obj = pool.removeObject(key);
                if (obj != null && obj instanceof BufferInputStream) {
                    BufferInputStream in = (BufferInputStream)obj;
                    logger.warning(key + "\u6b64\u65f6\u63a5\u6536\u5230\u975e\u7ed3\u675f\u7684\u5e27\u7d22\u5f15:0,\u4e3a\u5934\u7d22\u5f15\uff0c\u4f46\u662f\u4e4b\u524d\u5df2\u7ecf\u6536\u5230\u5e27\u7d22\u5f15" + (in.getBufferSize() - 1) + " \u671f\u5f85\u5e27\u7d22\u5f15\uff1a" + in.getBufferSize() + "\uff0c\u8fd9\u5c06\u4e22\u5f03\u4e4b\u524d\u6536\u5230\u7684" + in.getBufferSize() + "\u5e27\u6570\u636e!");
                }
                if (isEncrypted && isFrameEncrypted) {
                    packet = this.decrypt(packet);
                }
                this.cachePacket(logger, packet, key, pool, new BufferInputStream(), false);
                return false;
            }
            if (isEncrypted) {
                packet = this.decrypt(packet);
            }
            ctx.setAttribute("receive.request.id", id);
            ctx.setMessage(packet);
            return true;
        }
        WaitKey key = new WaitKey(receiveAddress, id);
        Object obj = pool.removeObject(key);
        if (obj == null || !(obj instanceof BufferInputStream)) {
            logger.warning(key + "\u6b64\u65f6\u63a5\u6536\u5230\u9519\u8bef\u7684\u5e27\u7d22\u5f15:" + index + ",\u4e4b\u524d\u672a\u6536\u5230\u4efb\u4f55\u7d22\u5f15\u5e27\uff0c\u6216\u8005\u4e4b\u524d\u7684\u5e27\u5df2\u7ecf\u4e22\u5f03!\u8be5\u5e27\u4e5f\u5c06\u4e22\u5f03!");
            return false;
        }
        BufferInputStream in = (BufferInputStream)obj;
        if (in.getBufferSize() != index) {
            logger.warning(key + "\u6b64\u65f6\u63a5\u6536\u5230\u9519\u8bef\u7684\u5e27\u7d22\u5f15:" + index + ", \u671f\u5f85\u5e27\u7d22\u5f15\uff1a" + in.getBufferSize() + ", \u8fd9\u5c06\u4e22\u5f03\u4e4b\u524d\u5df2\u7ecf\u6536\u5230\u7684:" + in.getBufferSize() + "\u5e27\u7d22\u5f15,\u4ee5\u53ca\u4ee5\u540e\u5e27\uff01 ");
            return false;
        }
        if (isEncrypted && isFrameEncrypted) {
            packet = this.decrypt(packet);
        }
        if (!isEnd) {
            this.cachePacket(logger, packet, key, pool, in, false);
            return false;
        }
        in.append(packet);
        packet = in.toByteBuffer();
        if (isEncrypted && !isFrameEncrypted) {
            packet = this.decrypt(in.toByteBuffer());
        }
        ctx.setMessage(packet);
        ctx.setAttribute("receive.request.id", id);
        return true;
    }

    protected ByteBuffer encrypt(ByteBuffer packet) throws Exception {
        return this.cryptoFactory.encrypt(packet);
    }

    protected ByteBuffer decrypt(ByteBuffer packet) throws Exception {
        return this.cryptoFactory.decrypt(packet);
    }

    protected boolean getDefaultNeedEncrypt() {
        return false;
    }

    protected int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    protected static class BufferInputStream {
        int pos;
        ByteBuffer currentBuffer;
        int limit;
        LinkedList<ByteBuffer> list = new LinkedList();

        protected BufferInputStream() {
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            int i = 1;
            while (i < len) {
                c = this.read();
                if (c == -1) break;
                b[off + i] = (byte)c;
                ++i;
            }
            return i;
        }

        public int read() {
            while (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
                this.currentBuffer = this.list.poll();
                if (this.currentBuffer == null) {
                    return -1;
                }
                if (this.currentBuffer.hasRemaining()) break;
            }
            int h = this.currentBuffer.get() & 0xFF;
            ++this.pos;
            return h;
        }

        public int available() throws IOException {
            return this.limit - this.pos;
        }

        public BufferInputStream append(ByteBuffer buffer) {
            this.list.offer(buffer);
            this.limit += buffer.remaining();
            return this;
        }

        public int getBufferSize() {
            return this.list.size();
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer bs = ByteBuffer.allocate(this.limit);
            for (ByteBuffer bf : this.list) {
                int pos = bf.position();
                bs.put(bf);
                bf.position(pos);
            }
            bs.flip();
            return bs;
        }
    }

    protected static class WaitKey {
        protected SocketAddress socketAddress;
        protected int id;

        protected WaitKey(SocketAddress socketAddress, int id) {
            this.socketAddress = socketAddress;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.socketAddress == null ? 0 : this.socketAddress.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitKey other = (WaitKey)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.socketAddress == null ? other.socketAddress != null : !this.socketAddress.equals(other.socketAddress));
        }

        public String toString() {
            return this.socketAddress + "[" + this.id + "]";
        }
    }
}

