/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HMPSender
extends HMPAppPacket
implements ResponseSender,
RequestSender {
    private static final AtomicInteger IDSEQ = new AtomicInteger(0);
    private Receiver receiver;
    private CommunicationHandle handle;
    private AtomicBoolean sending = new AtomicBoolean(false);

    public HMPSender(CommunicationHandle handle) {
        this(handle, null);
    }

    public HMPSender(CommunicationHandle handle, Receiver receiver) {
        this.handle = handle;
        this.receiver = receiver;
    }

    @Override
    public void setRequestActionName(String actionName) {
        this.setActionName(actionName);
    }

    @Override
    public String getRequestActionName() {
        return this.getActionName();
    }

    @Override
    public int doRequest(SendCallback sendCallback, ReceiveCallback receiveCallback) throws IOException {
        this.setResponse(false);
        if (this.getRequestActionName() == null || this.getRequestActionName().length() == 0) {
            throw new IOException("ActionName is NULL!");
        }
        return this.doSend(sendCallback, receiveCallback);
    }

    @Override
    public int doResponse(SendCallback sendCallback, ReceiveCallback receiveCallback) throws IOException {
        if (this.receiver != null) {
            this.setResponse(true);
            this.setActionName("/RESPONSE");
            this.setRemoteSendId(this.receiver.getRemoteSendId());
            this.setRemoteAddress(this.receiver.getRemoteAddress());
            this.setLocalAddress(this.receiver.getLocalAddress());
            return this.doSend(sendCallback, receiveCallback);
        }
        throw new IOException("receiver is null! can not response!");
    }

    protected int doSend(final SendCallback sendCallback, ReceiveCallback receiveCallback) throws IOException {
        if (this.sending.compareAndSet(false, true)) {
            int id = IDSEQ.incrementAndGet();
            this.setSendId(id);
            this.setReceiveCallback(receiveCallback);
            SocketAddress address = this.getRemoteAddress();
            if (address != null) {
                this.setAttribute("send.target.address", address);
            }
            this.handle.send(this, new SendCallbackHandler(){

                @Override
                public void onSendTimeout(CommunicationHandle handle) {
                    HMPSender.this.sending.set(false);
                    if (sendCallback != null) {
                        sendCallback.onException(new TimeoutException("send timeout!"));
                    }
                }

                @Override
                public void onSendException(Throwable exception, CommunicationHandle handle) {
                    HMPSender.this.sending.set(false);
                    if (sendCallback != null) {
                        sendCallback.onException(exception);
                    }
                }

                @Override
                public void onSendCompleted(CommunicationHandle handle) {
                    HMPSender.this.sending.set(false);
                    if (sendCallback != null) {
                        sendCallback.onCompleted();
                    }
                }
            });
            return id;
        }
        throw new IOException("\u53d1\u9001\u672a\u5b8c\u6210\uff01\u8bf7\u7a0d\u540e\u518d\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u662f\u5426\u5b8c\u6210\uff0c\u53ef\u4ee5\u901a\u8fc7SendCallback\u7684onException()\u548conCompleted()\u6765\u5224\u65ad!");
    }
}

