/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.communication.protocol.ActionMapping;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class HMPServiceActionManager
implements ServiceActionManager {
    private ConcurrentHashMap<String, ServiceAction> actionMap = new ConcurrentHashMap();

    @Override
    public void register(ServiceAction action) {
        ActionMapping m = action.getClass().getAnnotation(ActionMapping.class);
        if (m == null) {
            throw new IllegalArgumentException("Annotation ActionMapping not defined");
        }
        String[] vs = m.value();
        if (vs.length == 0) {
            vs = m.names();
        }
        if (vs.length == 0) {
            throw new IllegalArgumentException("Annotation ActionMapping's mapping names not defined");
        }
        String[] stringArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            ServiceAction sv = this.actionMap.putIfAbsent(v, action);
            if (sv != null) {
                throw new IllegalArgumentException("the action mapping name: " + v + " already exists!");
            }
            ++n2;
        }
    }

    @Override
    public void unRegister(Class<?> actionClass) {
        ActionMapping m = actionClass.getAnnotation(ActionMapping.class);
        if (m == null) {
            throw new IllegalArgumentException("Annotation ActionMapping not defined");
        }
        String[] vs = m.value();
        if (vs.length == 0) {
            vs = m.names();
        }
        if (vs.length == 0) {
            throw new IllegalArgumentException("Annotation ActionMapping's mapping names not defined");
        }
        String[] stringArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.actionMap.remove(v);
            ++n2;
        }
    }

    @Override
    public ServiceAction getAction(String actionName) {
        if (actionName != null) {
            return this.actionMap.get(actionName);
        }
        return null;
    }

    @Override
    public Enumeration<String> getActionNames() {
        return this.actionMap.keys();
    }

    public void clear() {
        this.actionMap.clear();
    }

    @Override
    public void register(String actionName, ServiceAction action) {
        ServiceAction sv = this.actionMap.putIfAbsent(actionName, action);
        if (sv != null) {
            throw new IllegalArgumentException("the action mapping name: " + actionName + " already exists!");
        }
    }

    @Override
    public void unRegister(String actionName) {
        this.actionMap.remove(actionName);
    }
}

