/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.CRC;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.ProtocolContext;
import java.nio.ByteBuffer;

public class HMPStreamProtocolHandler
extends AbstractProtocolHandler {
    private static final byte DLE = 17;
    private static final byte STX = 34;
    private static final byte ETX = 51;
    private static final byte ENC = 0;
    private static final byte WAIT_BEGIN_DLE = 0;
    private static final byte WAIT_BEGIN_STX = 1;
    private static final byte WAIT_DATA_LEN = 2;
    private static final byte WAIT_DATA = 3;
    private static final byte WAIT_CRC = 4;
    private static final byte WAIT_END_DLE = 5;
    private static final byte WAIT_END_ETX = 6;
    public static final int MAX_DATA_LEN = 0x100000;
    private byte state = 0;
    private int len = 0;
    private ByteBuffer cacheBuf;
    private boolean waitENC = false;
    private CRC crc = new CRC();
    private int maxBufLength;

    public HMPStreamProtocolHandler() {
        this(0x100000);
    }

    public HMPStreamProtocolHandler(int maxBufLength) {
        if (maxBufLength <= 0) {
            maxBufLength = 0x100000;
        }
        this.maxBufLength = maxBufLength;
    }

    private void setSize(int size) {
        if (this.cacheBuf == null || this.cacheBuf.capacity() < size) {
            this.resize(size);
        }
        this.cacheBuf.limit(size);
    }

    protected void resize(int newCapacity) {
        int initialCapacity = 8;
        if (newCapacity >= initialCapacity) {
            initialCapacity = newCapacity;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(initialCapacity);
        if (this.cacheBuf != null) {
            int pos = this.cacheBuf.position();
            this.cacheBuf.position(0);
            bb.put(this.cacheBuf);
            bb.position(pos);
        }
        this.cacheBuf = bb;
    }

    @Override
    protected synchronized boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer byteBuffer = (ByteBuffer)ctx.getMessage();
        if (byteBuffer == null) {
            throw new IllegalStateException("receive bytebuffer is null!");
        }
        int pos = byteBuffer.position();
        if (this.cacheBuf == null) {
            this.setSize(byteBuffer.remaining());
        }
        block12: while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            switch (this.state) {
                case 0: {
                    if (b != 17) continue block12;
                    this.cacheBuf.clear();
                    if (this.cacheBuf.remaining() < 128) {
                        this.setSize(128);
                    }
                    this.len = 0;
                    this.state = 1;
                    this.waitENC = false;
                    this.crc.init();
                    break;
                }
                case 1: {
                    if (b == 34) {
                        this.state = (byte)2;
                        break;
                    }
                    this.state = 0;
                    throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                }
                case 2: {
                    this.crc.updateByte(b);
                    if (this.waitENC) {
                        if (b == 0) {
                            this.waitENC = false;
                            if (this.cacheBuf.position() < 4) {
                                break;
                            }
                        } else {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF) + " 0x11 not escape! Discarded!");
                        }
                    }
                    if (this.cacheBuf.position() < 4) {
                        if (!this.cacheBuf.hasRemaining()) {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                        }
                        this.cacheBuf.put(b);
                        this.waitENC = b == 17;
                    }
                    if (this.waitENC) continue block12;
                    if (this.cacheBuf.position() == 4) {
                        this.cacheBuf.rewind();
                        this.len = this.cacheBuf.getInt();
                        if (this.len <= this.getMaxLength()) {
                            this.cacheBuf.rewind();
                            if (this.len == 0) {
                                this.setSize(this.len + 4);
                                this.state = (byte)4;
                                break;
                            }
                            if (this.len > 0) {
                                this.setSize(this.len + 4);
                                this.state = (byte)3;
                                break;
                            }
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                        }
                        this.state = 0;
                        throw new IllegalStateException("parse data error! data len:" + this.len + " A data frame is too long! Discarded");
                    }
                    if (this.cacheBuf.position() <= 4) continue block12;
                    this.state = 0;
                    throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF) + " A data frame is too long! Discarded");
                }
                case 3: {
                    this.crc.updateByte(b);
                    if (this.waitENC) {
                        if (b == 0) {
                            this.waitENC = false;
                            if (this.cacheBuf.position() < this.len) {
                                break;
                            }
                        } else {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF) + " 0x11 not escape! Discarded!");
                        }
                    }
                    if (this.cacheBuf.position() < this.len) {
                        if (!this.cacheBuf.hasRemaining()) {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                        }
                        this.cacheBuf.put(b);
                        this.waitENC = b == 17;
                    }
                    if (this.waitENC) continue block12;
                    if (this.cacheBuf.position() == this.len) {
                        this.state = (byte)4;
                        break;
                    }
                    if (this.cacheBuf.position() <= this.len) continue block12;
                    this.state = 0;
                    throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                }
                case 4: {
                    if (this.waitENC) {
                        if (b == 0) {
                            this.waitENC = false;
                            if (this.cacheBuf.position() - this.len < 4) {
                                break;
                            }
                        } else {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                        }
                    }
                    if (this.cacheBuf.position() - this.len < 4) {
                        if (!this.cacheBuf.hasRemaining()) {
                            this.state = 0;
                            throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                        }
                        this.cacheBuf.put(b);
                        this.waitENC = b == 17;
                    }
                    if (this.waitENC) continue block12;
                    if (this.cacheBuf.position() - this.len == 4) {
                        this.state = (byte)5;
                        break;
                    }
                    if (this.cacheBuf.position() - this.len <= 4) continue block12;
                    this.state = 0;
                    throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                }
                case 5: {
                    if (b == 17) {
                        this.state = (byte)6;
                        break;
                    }
                    this.state = 0;
                    throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                }
                case 6: {
                    try {
                        if (b == 51) {
                            this.cacheBuf.position(this.len);
                            if (this.cacheBuf.remaining() < 4) {
                                this.state = 0;
                                throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF));
                            }
                            if (this.crc.getDigest() != this.cacheBuf.getInt()) {
                                this.state = 0;
                                throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF) + "CRC check fails! expect:" + this.crc.getDigest() + " actual:" + this.cacheBuf.getInt());
                            }
                            this.cacheBuf.position(this.len);
                            this.cacheBuf.flip();
                            ByteBuffer copyBuffer = ByteBuffer.allocate(this.cacheBuf.remaining());
                            copyBuffer.put(this.cacheBuf);
                            this.cacheBuf.flip();
                            copyBuffer.flip();
                            ctx.setMessage(copyBuffer);
                            copyBuffer = null;
                            if (this.getPreviousProtocolHandler() != null) {
                                this.getPreviousProtocolHandler().protocolHandle(ctx);
                            }
                            this.state = 0;
                            continue block12;
                        }
                        this.state = 0;
                        throw new IllegalStateException("parse data error! invalid byte:0x" + Integer.toHexString(b & 0xFF) + "CRC check fails! expect:" + this.crc.getDigest() + " actual:" + this.cacheBuf.getInt());
                    }
                    finally {
                        this.state = 0;
                    }
                }
                default: {
                    this.state = 0;
                }
            }
        }
        byteBuffer.position(pos);
        return false;
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        ByteBufferPacket[] sendPackets = (ByteBufferPacket[])ctx.getMessage();
        if (sendPackets != null && sendPackets.length > 0) {
            int leng = sendPackets.length;
            int i = 0;
            while (i < leng) {
                ByteBuffer dataBuf = sendPackets[i].getByteBuffer();
                sendPackets[i].setByteBuffer(this.toFrameBuffer(dataBuf));
                ++i;
            }
            return true;
        }
        return false;
    }

    public ByteBuffer toFrameBuffer(ByteBuffer dataBuf) throws IllegalArgumentException {
        int hp = dataBuf.position();
        int len = dataBuf.remaining();
        if (len > this.getMaxFrameDataLength()) {
            throw new IllegalArgumentException("data is to long! max length:" + this.getMaxFrameDataLength());
        }
        ByteBuffer b = ByteBuffer.allocate(2 * (len + 8) + 4);
        b.put((byte)17);
        b.put((byte)34);
        byte[] xb = new byte[4];
        int p1 = b.position();
        b.putInt(len);
        b.position(p1);
        b.get(xb);
        b.position(p1);
        CRC crc = new CRC();
        int i = 0;
        while (i < xb.length) {
            byte xl = xb[i];
            b.put(xl);
            crc.updateByte(xl);
            if (xl == 17) {
                b.put((byte)0);
                crc.updateByte(0);
            }
            ++i;
        }
        while (dataBuf.hasRemaining()) {
            byte b1 = dataBuf.get();
            b.put(b1);
            crc.updateByte(b1);
            if (b1 != 17) continue;
            b.put((byte)0);
            crc.updateByte(0);
        }
        p1 = b.position();
        b.putInt(crc.getDigest());
        b.position(p1);
        b.get(xb, 0, 4);
        b.position(p1);
        int i2 = 0;
        while (i2 < 4) {
            b.put(xb[i2]);
            if (xb[i2] == 17) {
                b.put((byte)0);
            }
            ++i2;
        }
        b.put((byte)17);
        b.put((byte)51);
        b.flip();
        dataBuf.position(hp);
        return b;
    }

    private int getMaxLength() {
        int h = this.getMaxFrameDataLength();
        if (h <= 0) {
            h = 0x100000;
        }
        return h;
    }

    protected int getMaxFrameDataLength() {
        return this.maxBufLength;
    }
}

