/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.protocol.hmp;

import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.communication.SymmetricKeyGetter;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import java.nio.ByteBuffer;
import java.security.Key;

public class SymmetricCryptoFactory
implements CryptoFactory {
    private SymmetricKeyGetter keyGetter;

    public SymmetricCryptoFactory(SymmetricKeyGetter keyGetter) {
        this.keyGetter = keyGetter;
    }

    @Override
    public ByteBuffer decrypt(ByteBuffer encryptBuffer) throws Exception {
        int offset;
        byte[] array;
        Key key = this.keyGetter.getKey();
        int pos = encryptBuffer.position();
        int len = encryptBuffer.remaining();
        if (encryptBuffer.hasArray()) {
            array = encryptBuffer.array();
            offset = pos + encryptBuffer.arrayOffset();
        } else {
            array = new byte[len];
            encryptBuffer.get(array);
            offset = 0;
            encryptBuffer.position(pos);
        }
        return CryptoUtil.crypt(array, offset, len, CryptoUtil.getDecryptCipher(key, key.getAlgorithm()));
    }

    @Override
    public ByteBuffer encrypt(ByteBuffer dataBuf) throws Exception {
        int offset;
        byte[] array;
        Key key = this.keyGetter.getKey();
        int pos = dataBuf.position();
        int len = dataBuf.remaining();
        if (dataBuf.hasArray()) {
            array = dataBuf.array();
            offset = pos + dataBuf.arrayOffset();
        } else {
            array = new byte[len];
            dataBuf.get(array);
            offset = 0;
            dataBuf.position(pos);
        }
        return CryptoUtil.crypt(array, offset, len, CryptoUtil.getEncryptCipher(key, key.getAlgorithm()));
    }
}

