/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.tcp.DefaultTCPCommunicationHandleFactory;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandle;
import com.wovoe.framework.communication.tcp.TcpProtocolHandler;
import org.apache.mina.core.session.IoSession;

public class CommonTCPCommunicationHandleFactory
extends DefaultTCPCommunicationHandleFactory {
    public CommonTCPCommunicationHandleFactory(CryptoFactory defaultCryptoFactory) {
        super(defaultCryptoFactory);
    }

    @Override
    public TCPCommunicationHandle create(TimeoutObjectPool timeoutObjectPool, IoSession session, ServiceActionManager actionManager, CryptoFactory cryptoFactory) {
        TCPCommunicationHandle instance = new TCPCommunicationHandle(session);
        instance.setTimeoutObjectPool(timeoutObjectPool);
        ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
        if (cryptoFactory == null) {
            cryptoFactory = this.defaultCryptoFactory;
        }
        rwchain.appendNextProtocolHandler(new TcpProtocolHandler(instance, actionManager, cryptoFactory));
        rwchain.appendNextProtocolHandler(new RootWriteProtocolHandler());
        instance.setProtocolHandlerChain(rwchain);
        return instance;
    }
}

