/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPAppProtocolHandler;
import com.wovoe.framework.communication.protocol.hmp.HMPFrameProtocolHandler;
import com.wovoe.framework.communication.protocol.hmp.HMPStreamProtocolHandler;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandle;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandleFactory;
import org.apache.mina.core.session.IoSession;

public class DefaultTCPCommunicationHandleFactory
implements TCPCommunicationHandleFactory {
    protected CryptoFactory defaultCryptoFactory;

    public DefaultTCPCommunicationHandleFactory(CryptoFactory defaultCryptoFactory) {
        this.defaultCryptoFactory = defaultCryptoFactory;
    }

    @Override
    public TCPCommunicationHandle create(TimeoutObjectPool timeoutObjectPool, IoSession session, ServiceActionManager actionManager, CryptoFactory cryptoFactory) {
        TCPCommunicationHandle instance = new TCPCommunicationHandle(session);
        instance.setTimeoutObjectPool(timeoutObjectPool);
        ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
        if (cryptoFactory == null) {
            cryptoFactory = this.defaultCryptoFactory;
        }
        rwchain.appendNextProtocolHandler(new HMPAppProtocolHandler(instance, actionManager));
        rwchain.appendNextProtocolHandler(new HMPFrameProtocolHandler(4096, cryptoFactory));
        rwchain.appendNextProtocolHandler(new HMPStreamProtocolHandler());
        rwchain.appendNextProtocolHandler(new RootWriteProtocolHandler());
        instance.setProtocolHandlerChain(rwchain);
        return instance;
    }

    @Override
    public CryptoFactory getDefaultCryptoFactory() {
        return this.defaultCryptoFactory;
    }
}

