/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.FrameworkUtil;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.Client;
import com.wovoe.framework.communication.protocol.ClientManager;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.tcp.TCPClient;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandleFactory;
import com.wovoe.framework.communication.tcp.TCPServerHeartbeatAction;
import com.wovoe.framework.communication.tcp.TcpNetworkHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class DefaultTcpNetworkHandler
extends IoHandlerAdapter
implements TcpNetworkHandler {
    private InetSocketAddress bindAddress;
    private Logger logger;
    private ClientManager clientManager;
    private TimeoutObjectPool timeoutObjectPool;
    private TCPCommunicationHandleFactory tcpCommunicationHandleFactory;
    private ServiceActionManager actionManager;

    public DefaultTcpNetworkHandler(int port, ClientManager clientManager, TimeoutObjectPool timeoutObjectPool, TCPCommunicationHandleFactory tcpCommunicationHandleFactory, ServiceActionManager actionManager) {
        this(null, port, 0, clientManager, timeoutObjectPool, tcpCommunicationHandleFactory, actionManager);
    }

    public DefaultTcpNetworkHandler(String host, int port, int processorCount, ClientManager clientManager, TimeoutObjectPool timeoutObjectPool, TCPCommunicationHandleFactory tcpCommunicationHandleFactory, ServiceActionManager actionManager) {
        this.logger = Logger.getLogger("wovoe.tcp_" + port);
        this.clientManager = clientManager;
        this.actionManager = actionManager;
        this.timeoutObjectPool = timeoutObjectPool;
        this.tcpCommunicationHandleFactory = tcpCommunicationHandleFactory;
        this.bindAddress = host == null || host.length() == 0 ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        if (this.actionManager.getAction("/TCPServerHeartbeat") == null) {
            this.actionManager.register("/TCPServerHeartbeat", new TCPServerHeartbeatAction());
        }
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public int getBindPort() {
        return this.getBindAddress().getPort();
    }

    @Override
    public void onClose() {
        Enumeration<Client> enus = this.clientManager.getClients();
        while (enus.hasMoreElements()) {
            try {
                Client client = enus.nextElement();
                client.close();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, ex.getMessage());
            }
        }
    }

    @Override
    public ClientManager getClientManager() {
        return this.clientManager;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void sessionClosed(IoSession session) throws Exception {
        block18: {
            client = (TCPClient)session.removeAttribute(TCPClient.class.getName());
            if (client != null) {
                try {
                    client.close();
                }
                finally {
                    try {
                        this.clientManager.removeClient(client);
                    }
                    finally {
                        c = client.getCloseListeners0();
                        if (c == null) break block18;
                        ** while ((l = c.poll()) != null)
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        l.onClose(client);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "call ClientCloseListener.onClose error!", e);
                    }
                    continue;
                }
            }
        }
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        TCPClient client = new TCPClient(session);
        client.setCryptoFactory(this.tcpCommunicationHandleFactory.getDefaultCryptoFactory());
        client.setLastReceivedTime(FrameworkUtil.currentTimeMillis());
        client.setCommunicationHandle(this.tcpCommunicationHandleFactory.create(this.timeoutObjectPool, session, this.actionManager, client));
        session.setAttribute(TCPClient.class.getName(), client);
        Client c = this.clientManager.getClient(client.getRemoteAddress());
        if (c != null) {
            this.clientManager.removeClient(c);
            c.close();
        }
        this.clientManager.addClient(client);
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (!(cause instanceof IOException) || cause.getMessage() == null || cause.getMessage().indexOf("\u8fdc\u7a0b\u4e3b\u673a\u5f3a\u8feb\u5173\u95ed\u4e86\u4e00\u4e2a\u73b0\u6709\u7684\u8fde\u63a5") == -1) {
            this.logger.log(Level.SEVERE, "\u51fa\u73b0\u4e00\u4e2aTCP\u901a\u4fe1\u5f02\u5e38", cause);
        }
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        try {
            IoBuffer receiveMessage = (IoBuffer)message;
            TCPClient client = (TCPClient)session.getAttribute(TCPClient.class.getName());
            if (client != null) {
                client.setLastReceivedTime(FrameworkUtil.currentTimeMillis());
                client.getCommunicationHandle().handleRead(receiveMessage);
            }
        }
        catch (Exception ex) {
            session.close(true);
            throw ex;
        }
    }
}

