/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.communication.protocol.Client;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.hmp.HMPSender;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandle;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.session.IoSession;

public class TCPClient
implements Client,
CryptoFactory {
    private CryptoFactory cryptoFactory;
    private IoSession session;
    private volatile long lastReceivedTime;
    private Map<String, Object> attributes;
    private ConcurrentLinkedQueue<Client.ClientCloseListener> closeListeners;
    private ScheduledFuture<?> connectedHandler;
    private TCPCommunicationHandle communicationHandle;
    private int use;
    private SocketAddress remoteAddress;
    private SocketAddress localAddress;
    private long sessionId;
    private final AtomicBoolean closed;

    public TCPClient(IoSession session) {
        this.session = session;
        this.remoteAddress = session.getRemoteAddress();
        this.localAddress = session.getLocalAddress();
        this.sessionId = session.getId();
        this.closed = new AtomicBoolean(false);
    }

    public IoSession getIoSession() {
        return this.session;
    }

    public CryptoFactory getCryptoFactory() {
        return this.cryptoFactory;
    }

    public void setCryptoFactory(CryptoFactory cryptoFactory) {
        if (cryptoFactory != this) {
            this.cryptoFactory = cryptoFactory;
        }
    }

    public long getLastReceivedTime() {
        return this.lastReceivedTime;
    }

    public void setLastReceivedTime(long lastReceivedTime) {
        this.lastReceivedTime = lastReceivedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            TCPClient tCPClient = this;
            synchronized (tCPClient) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.attributes;
    }

    @Override
    public void setAttribute(String attrName, Object value) {
        if (attrName != null && value != null) {
            this.getAttributes().put(attrName, value);
        }
    }

    @Override
    public Object getAttribute(String attrName) {
        if (this.attributes == null || attrName == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    @Override
    public Object removeAttribute(String attrName) {
        if (this.attributes == null || attrName == null) {
            return null;
        }
        return this.attributes.remove(attrName);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.enumeration(new ArrayList(0));
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Client.ClientCloseListener> getCloseListeners() {
        if (this.closeListeners == null) {
            TCPClient tCPClient = this;
            synchronized (tCPClient) {
                if (this.closeListeners == null) {
                    this.closeListeners = new ConcurrentLinkedQueue();
                }
            }
        }
        return this.closeListeners;
    }

    ConcurrentLinkedQueue<Client.ClientCloseListener> getCloseListeners0() {
        return this.closeListeners;
    }

    @Override
    public void addClientCloseListener(Client.ClientCloseListener l) {
        if (this.session.isClosing()) {
            l.onClose(this);
        } else if (l != null) {
            this.getCloseListeners().add(l);
        }
    }

    @Override
    public void removeClientCloseListener(Client.ClientCloseListener l) {
        if (this.closeListeners != null && l != null) {
            this.closeListeners.remove(l);
        }
    }

    @Override
    public Enumeration<Client.ClientCloseListener> getClientCloseListeners() {
        if (this.closeListeners == null) {
            return Collections.enumeration(new ArrayList(0));
        }
        return Collections.enumeration(this.closeListeners);
    }

    @Override
    public boolean containClientCloseListener(Client.ClientCloseListener l) {
        if (this.closeListeners != null && l != null) {
            return this.closeListeners.contains(l);
        }
        return false;
    }

    public ScheduledFuture<?> getConnectedHandler() {
        return this.connectedHandler;
    }

    public void setConnectedHandler(ScheduledFuture<?> connectedHandler) {
        this.connectedHandler = connectedHandler;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.connectedHandler != null && !this.connectedHandler.isDone()) {
                    this.connectedHandler.cancel(false);
                    this.connectedHandler = null;
                }
            }
            finally {
                if (!this.session.isClosing() && this.session.isConnected()) {
                    this.session.close(true);
                }
            }
        }
    }

    @Override
    public boolean isClosing() {
        return this.session.isClosing();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public RequestSender createClientRequest() {
        HMPSender sender = new HMPSender(this.communicationHandle);
        return sender;
    }

    public TCPCommunicationHandle getCommunicationHandle() {
        return this.communicationHandle;
    }

    public void setCommunicationHandle(TCPCommunicationHandle communicationHandle) {
        this.communicationHandle = communicationHandle;
    }

    @Override
    public int getUse() {
        return this.use;
    }

    public void setUse(int use) {
        this.use = use;
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public ByteBuffer decrypt(ByteBuffer encryptBuffer) throws Exception {
        CryptoFactory c = this.cryptoFactory;
        if (c != null && c != this) {
            return c.decrypt(encryptBuffer);
        }
        return encryptBuffer;
    }

    @Override
    public ByteBuffer encrypt(ByteBuffer dataBuf) throws Exception {
        CryptoFactory c = this.cryptoFactory;
        if (c != null && c != this) {
            return c.encrypt(dataBuf);
        }
        return dataBuf;
    }

    @Override
    public long getId() {
        return this.sessionId;
    }
}

