/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.communication.BasicCommunicationHandle;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.TransportProtocol;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import com.wovoe.framework.communication.protocol.hmp.HMPSender;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;

public class TCPCommunicationHandle
extends BasicCommunicationHandle
implements HMPResponseSenderFactory {
    private IoSession session;
    private static int v;
    private static Logger tcpLogger;

    static {
        tcpLogger = Logger.getLogger("MinaTCP");
    }

    private static synchronized int getV() {
        return ++v;
    }

    public IoSession getIoSession() {
        return this.session;
    }

    public void setSession(IoSession session) {
        this.session = session;
    }

    public TCPCommunicationHandle(IoSession session) {
        this(session, null);
    }

    public TCPCommunicationHandle(IoSession session, String name) {
        this.session = session;
        if (name == null) {
            name = "MinaTCP." + TCPCommunicationHandle.getV();
        }
        this.setName(name);
        this.setLogger(tcpLogger);
    }

    @Override
    protected boolean useSendThread() {
        return false;
    }

    @Override
    public boolean isStart() {
        IoSession session0 = this.session;
        return session0 != null && session0.isConnected();
    }

    @Override
    public TransportProtocol protocol() {
        return TransportProtocol.TCP;
    }

    @Override
    public CommunicationHandle.State getState() {
        return this.isStart() ? CommunicationHandle.State.STARTED : CommunicationHandle.State.STOPPED;
    }

    @Override
    public Object start() throws IOException {
        return this.session;
    }

    @Override
    public Object shutdown() throws IOException {
        return this.session.close(true);
    }

    @Override
    protected void localSend0(Object message, SendCallbackHandler handler) throws IOException {
        ByteBuffer buf;
        ByteArrayPacket x1;
        IoSession session = this.session;
        if (session == null) {
            throw new IOException("not start yet!");
        }
        final TCPCommunicationHandle h = this;
        final SendCallbackHandler handle1 = handler;
        if (message instanceof ByteBufferPacket) {
            x1 = (ByteBufferPacket)message;
            buf = ((ByteBufferPacket)x1).getByteBuffer();
        } else if (message instanceof ByteArrayPacket) {
            x1 = (ByteArrayPacket)message;
            buf = ByteBuffer.wrap(x1.getByteArray(), x1.getByteArrayOffset(), x1.getByteArrayLength());
        } else {
            buf = (ByteBuffer)message;
        }
        final StringBuilder logBuf = this.logger != null && this.logger.isLoggable(Level.FINEST) ? new StringBuilder((buf.remaining() << 1) + 64).append("TCP send data finish: ").append(session.getRemoteAddress()).append(", data:").append(BytesTool.byteBufferToHexString(buf)) : null;
        IoBuffer message0 = IoBuffer.getAllocator().wrap(buf);
        final WriteFuture f = session.write(message0);
        f.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

            @Override
            public void operationComplete(IoFuture future) {
                Throwable ex = f.getException();
                if (ex != null) {
                    handle1.onSendException(ex, h);
                } else if (f.isWritten()) {
                    if (TCPCommunicationHandle.this.logger != null && TCPCommunicationHandle.this.logger.isLoggable(Level.FINEST) && logBuf != null) {
                        TCPCommunicationHandle.this.logger.finest(logBuf.toString());
                    }
                    handle1.onSendCompleted(h);
                } else {
                    handle1.onSendException(new Exception("can not write complete!"), h);
                }
            }
        });
    }

    public void handleRead(IoBuffer receiveMessage) throws IOException {
        ByteBuffer buf = receiveMessage.buf();
        try {
            this.handleLocalReceivedPacket(buf, this.session.getRemoteAddress());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    protected Object localStart() throws IOException {
        return null;
    }

    @Override
    protected Object localShutdown() throws IOException {
        return null;
    }

    @Override
    public ResponseSender createResponseSender(HMPAppPacket receiverPacket) {
        HMPSender sender = new HMPSender(this, receiverPacket);
        sender.setRemoteSendId(receiverPacket.getRemoteSendId());
        return sender;
    }

    @Override
    public int getAttemptsToSend() {
        return 1;
    }
}

