/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.Callback;
import com.wovoe.framework.FrameworkUtil;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.CancelException;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.TCPConnection;
import com.wovoe.framework.communication.protocol.TCPConnectionFactory;
import com.wovoe.framework.communication.protocol.hmp.HMPServiceActionManager;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandle;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandleFactory;
import com.wovoe.framework.communication.tcp.TCPRemoteConnection;
import com.wovoe.framework.communication.tcp.TcpConnectContext;
import com.wovoe.framework.impl.DefaultOperationFuture;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class TCPConnectionFactoryCreator
extends IoHandlerAdapter
implements TCPConnectionFactory {
    private TcpConnectContext tcpConnectContext;
    private SocketAddress defaultRemoteAddress;
    private TimeoutObjectPool timeoutObjectPool;
    private TCPCommunicationHandleFactory tcpCommunicationHandleFactory;
    private static final Logger logger = Logger.getLogger(TCPConnectionFactoryCreator.class.getName());
    private ConcurrentHashMap<IoSession, TCPRemoteConnection> connectionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<SocketAddress, ConnectionPool> connectionPoolMap = new ConcurrentHashMap();

    public TCPConnectionFactoryCreator(TcpConnectContext context, SocketAddress defaultRemoteAddress, TimeoutObjectPool timeoutObjectPool, TCPCommunicationHandleFactory tcpCommunicationHandleFactory) {
        this.tcpConnectContext = context;
        this.defaultRemoteAddress = defaultRemoteAddress;
        this.timeoutObjectPool = timeoutObjectPool;
        this.tcpCommunicationHandleFactory = tcpCommunicationHandleFactory;
    }

    public TcpConnectContext getTcpConnectContext() {
        return this.tcpConnectContext;
    }

    public int getAllSessionSize() {
        return this.connectionMap.size();
    }

    public int getPoolConnectionSize(SocketAddress address) {
        if (address == null) {
            return 0;
        }
        ConnectionPool p1 = this.connectionPoolMap.get(address);
        if (p1 == null) {
            return 0;
        }
        return p1.size();
    }

    public void checkConnectionPoolCount() {
        if (this.connectionPoolMap.size() > 20) {
            long timout = 900000L;
            long currentTimeMillis = FrameworkUtil.currentTimeMillis();
            LinkedList<SocketAddress> removeList = null;
            for (Map.Entry<SocketAddress, ConnectionPool> entery : this.connectionPoolMap.entrySet()) {
                ConnectionPool q = entery.getValue();
                if (q.peek() == null) {
                    if (currentTimeMillis - q.useTimeMills <= timout) continue;
                    if (removeList == null) {
                        removeList = new LinkedList<SocketAddress>();
                    }
                    removeList.add(entery.getKey());
                    continue;
                }
                q.useTimeMills = currentTimeMillis;
            }
            if (removeList != null && !removeList.isEmpty()) {
                for (SocketAddress c : removeList) {
                    ConnectionPool p1 = this.connectionPoolMap.get(c);
                    if (p1 == null || p1.peek() != null || currentTimeMillis - p1.useTimeMills <= timout || (p1 = this.connectionPoolMap.remove(c)) == null) continue;
                    for (TCPRemoteConnection z : p1) {
                        try {
                            z.close();
                        }
                        catch (Exception e1) {
                            logger.log(Level.SEVERE, "", e1);
                        }
                    }
                }
            }
        }
    }

    public void close() {
        for (TCPRemoteConnection c : this.connectionMap.values()) {
            try {
                c.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        TCPRemoteConnection conn = this.connectionMap.remove(session);
        if (conn != null) {
            try {
                ConnectionPool q = this.connectionPoolMap.get(conn.getRemoteAddress());
                if (q != null) {
                    q.remove(conn);
                }
                this.timeoutObjectPool.removeObject(new PoolKey(conn, this.getV()));
            }
            finally {
                conn.close();
            }
        }
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        TCPRemoteConnection conn = this.connectionMap.get(session);
        if (conn != null) {
            IoBuffer buffer = (IoBuffer)message;
            conn.setLastReceiveTime(FrameworkUtil.currentTimeMillis());
            conn.getTCPCommunicationHandle().handleRead(buffer);
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        TCPRemoteConnection conn = this.connectionMap.get(session);
        if (conn != null) {
            conn.setLastSentTime(FrameworkUtil.currentTimeMillis());
        }
    }

    @Override
    public void create(SocketAddress remoteAddress, SocketAddress localAddress, ObjectCreateCallback<TCPConnection> callback, int connectTimeoutMills, Map<String, String> conectParameter) {
        this.create(remoteAddress, localAddress, callback, 0, conectParameter, null, connectTimeoutMills);
    }

    public void create(SocketAddress remoteAddress, SocketAddress localAddress, final ObjectCreateCallback<TCPConnection> callback, final int use, final Map<String, String> infoConfig, final HMPServiceActionManager manager, int connectTimeoutMills) {
        if (callback == null) {
            throw new NullPointerException("callback is null!");
        }
        if (remoteAddress == null && (remoteAddress = this.defaultRemoteAddress) == null) {
            throw new NullPointerException("remoteAddress is null!");
        }
        final ConnectFuture furue0 = this.tcpConnectContext.getNioSocketConnector().connect(remoteAddress, localAddress);
        final SocketAddress xz = remoteAddress;
        final Object waitKey = new Object();
        if (connectTimeoutMills <= 0) {
            connectTimeoutMills = 8000;
        }
        this.timeoutObjectPool.addObject(waitKey, remoteAddress, new TimeoutObjectPool.TimeoutCallback(){
            long time1 = FrameworkUtil.currentTimeMillis();

            @Override
            public void onTimeout(Object key, Object object1) throws Exception {
                if (!furue0.isConnected()) {
                    furue0.cancel();
                }
                logger.severe("\u83b7\u53d6IoSession\u8d85\u65f6:" + object1 + " \u8d85\u65f6\u65f6\u95f4\uff1a" + (FrameworkUtil.currentTimeMillis() - this.time1) + "\u6beb\u79d2!");
            }
        }, connectTimeoutMills, TimeUnit.MILLISECONDS);
        final long connectTimeoutMills0 = connectTimeoutMills - 500;
        furue0.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

            @Override
            public void operationComplete(IoFuture f) {
                block13: {
                    try {
                        TCPConnectionFactoryCreator.this.timeoutObjectPool.removeObject(waitKey);
                        if (furue0.getException() != null) {
                            try {
                                logger.severe("\u8fde\u63a5\u8fdc\u7a0b\u7aef\u5f02\u5e38\uff0c\u8fde\u63a5\u5730\u5740:" + xz);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            callback.onException(furue0.getException());
                            return;
                        }
                        if (furue0.isCanceled()) {
                            try {
                                IoSession session = furue0.getSession();
                                if (session != null) {
                                    session.close(true);
                                }
                            }
                            catch (Throwable session) {
                                // empty catch block
                            }
                            callback.onException(new TimeoutException("Connect Timeout! RemosteAddress: " + xz));
                            return;
                        }
                        final IoSession session = furue0.getSession();
                        if (session != null) {
                            session.setAttribute("WOVOE_TCPCONNECTIOHANLER", TCPConnectionFactoryCreator.this);
                            final TCPRemoteConnection connection = new TCPRemoteConnection(new HMPServiceActionManager(), xz);
                            connection.setCryptoFactory(TCPConnectionFactoryCreator.this.tcpCommunicationHandleFactory.getDefaultCryptoFactory());
                            TCPCommunicationHandle handle = TCPConnectionFactoryCreator.this.tcpCommunicationHandleFactory.create(TCPConnectionFactoryCreator.this.timeoutObjectPool, session, connection, connection);
                            connection.setTCPCommunicationHandle(handle);
                            TCPConnectionFactoryCreator.this.connectionMap.put(session, connection);
                            long maxTimout = connectTimeoutMills0 < 5000L ? 5000L : connectTimeoutMills0;
                            OperationFuture<Boolean> future = TCPConnectionFactoryCreator.this.doShakehand(connection, maxTimout, use, infoConfig, manager);
                            future.addCompleteListener(new OperationFuture.CompleteListener<Boolean>(){

                                @Override
                                public void waitCompleteTimeout() {
                                    session.close(true);
                                    callback.onException(new TimeoutException("Shakehand timeout!"));
                                }

                                @Override
                                public void operationComplete(OperationFuture<Boolean> futrue) {
                                    if (futrue.getException() != null) {
                                        session.close(true);
                                        callback.onException(futrue.getException());
                                    } else if (futrue.isCancelled()) {
                                        session.close(true);
                                        callback.onException(new CancelException("cancel!"));
                                    } else {
                                        Boolean result = futrue.getResult();
                                        if (result != null && result.booleanValue()) {
                                            callback.createSuccess(connection);
                                        } else {
                                            session.close(true);
                                            callback.onException(new Exception("create connection false!"));
                                        }
                                    }
                                }
                            }, maxTimout, TimeUnit.MILLISECONDS);
                            break block13;
                        }
                        try {
                            callback.onException(new TimeoutException("Connect Timeout! RemosteAddress: " + xz));
                        }
                        finally {
                            furue0.cancel();
                        }
                    }
                    catch (Throwable e) {
                        callback.onException(e);
                    }
                }
            }
        });
    }

    protected OperationFuture<Boolean> doShakehand(TCPRemoteConnection connection, long MaxTimeout, int use, Map<String, String> infoConfig, HMPServiceActionManager manager) {
        DefaultOperationFuture<Boolean> future = new DefaultOperationFuture<Boolean>(this.timeoutObjectPool);
        future.setResult(Boolean.TRUE);
        return future;
    }

    @Override
    public TCPConnection create(SocketAddress remoteAddress, SocketAddress localAddress, int connectTimeoutMills, Map<String, String> conectParameter) throws IOException {
        if (connectTimeoutMills <= 0) {
            connectTimeoutMills = 8000;
        }
        final DefaultOperationFuture future = new DefaultOperationFuture(this.timeoutObjectPool);
        this.create(remoteAddress, localAddress, new ObjectCreateCallback<TCPConnection>(){

            @Override
            public void createSuccess(TCPConnection e) {
                boolean s = future.setResult(e);
                if (!s && (future.isCancelled() || future.getException() != null)) {
                    try {
                        e.close();
                    }
                    catch (IOException e1) {
                        logger.log(Level.SEVERE, "", e1);
                    }
                }
            }

            @Override
            public void onException(Throwable ex) {
                future.setException(ex);
            }
        }, connectTimeoutMills, conectParameter);
        try {
            TCPConnection c = (TCPConnection)future.get(connectTimeoutMills, TimeUnit.MILLISECONDS);
            if (c == null) {
                if (!future.cancel(true)) {
                    if (future.getException() != null) {
                        throw future.getException();
                    }
                    if (future.getResult() != null) {
                        return (TCPConnection)future.getResult();
                    }
                    throw new TimeoutException("get connection timeout!");
                }
                throw new TimeoutException("get connection timeout!");
            }
            return c;
        }
        catch (Throwable e1) {
            if (e1 instanceof IOException) {
                throw (IOException)e1;
            }
            throw new IOException(e1.getMessage(), e1);
        }
    }

    private int getV() {
        return this.hashCode();
    }

    @Override
    public TCPConnection acquireConnectionFromPool(SocketAddress remoteAddress, int connectTimeoutMills) throws IOException {
        TCPConnection conn;
        ConnectionPool pool0;
        if (remoteAddress == null && (remoteAddress = this.defaultRemoteAddress) == null) {
            throw new NullPointerException("remoteAddress is null!");
        }
        if (connectTimeoutMills <= 0) {
            connectTimeoutMills = 8000;
        }
        if ((pool0 = this.connectionPoolMap.get(remoteAddress)) == null) {
            conn = this.create(remoteAddress, null, connectTimeoutMills, null);
        } else {
            pool0.updateUseTimeMills();
            TCPConnection conn1 = null;
            while ((conn1 = (TCPConnection)pool0.pollFirst()) != null) {
                Object obj = this.timeoutObjectPool.removeObject(new PoolKey(conn1, this.getV()));
                if (obj != null) break;
            }
            conn = conn1 == null ? this.create(remoteAddress, null, connectTimeoutMills, null) : conn1;
        }
        return new DefaultTcpConnectionProxy(conn);
    }

    public static void checkConnection(String actionName, TCPConnection conn, Callback<Map<String, Object>, Object> callback) {
        TCPConnectionFactoryCreator.checkConnection(actionName, conn, callback, 5000L);
    }

    public static void checkConnection(String actionName, TCPConnection conn, final Callback<Map<String, Object>, Object> callback, long timeoutMills) {
        try {
            RequestSender request = conn.createRequest();
            request.setRequestActionName(actionName);
            request.setHeader("cst", String.valueOf(System.currentTimeMillis()));
            request.setHeader("rct", String.valueOf(FrameworkUtil.currentTimeMillis()));
            final long timeoutMills0 = timeoutMills <= 0L ? 5000L : timeoutMills;
            request.doRequest(new SendCallback(){

                @Override
                public void onException(Throwable exception) {
                    callback.onException(exception);
                }

                @Override
                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                @Override
                public void onWaitTimeout() throws Exception {
                    callback.onException(new TimeoutException("wait heartbeat response timeout~"));
                }

                @Override
                public long getWaitTimeoutMills() {
                    return timeoutMills0;
                }

                @Override
                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        Long sst = Long.valueOf(receiver.getHeaderValue("sst"));
                        Long cst = Long.valueOf(receiver.getHeaderValue("cst"));
                        Long rct = Long.valueOf(receiver.getHeaderValue("rct"));
                        HashMap<String, Comparable<Boolean>> callp = new HashMap<String, Comparable<Boolean>>();
                        callp.put("testResult", Boolean.TRUE);
                        callp.put("remoteTimeMill", sst);
                        callp.put("localSendTimeMill", cst);
                        callp.put("localsendNanoTimeMill", rct);
                        callback.callback(callp);
                    }
                    catch (Exception ex) {
                        callback.onException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            callback.onException(ex);
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        logger.log(Level.SEVERE, "\u51fa\u73b0\u4e00\u4e2aTCP\u901a\u4fe1\u5f02\u5e38", cause);
    }

    @Override
    public void acquireConnectionFromPool(SocketAddress remoteAddress, final ObjectCreateCallback<TCPConnection> callback, int connectTimeoutMills) {
        TCPConnection conn;
        ConnectionPool pool0;
        if (callback == null) {
            throw new NullPointerException("callback is null!");
        }
        if (remoteAddress == null && (remoteAddress = this.defaultRemoteAddress) == null) {
            throw new NullPointerException("remoteAddress is null!");
        }
        if (connectTimeoutMills <= 0) {
            connectTimeoutMills = 8000;
        }
        if ((pool0 = this.connectionPoolMap.get(remoteAddress)) == null) {
            conn = null;
        } else {
            pool0.updateUseTimeMills();
            TCPConnection conn1 = null;
            while ((conn1 = (TCPConnection)pool0.pollFirst()) != null) {
                Object obj = this.timeoutObjectPool.removeObject(new PoolKey(conn1, this.getV()));
                if (obj != null) break;
            }
            conn = conn1 == null ? null : conn1;
        }
        if (conn != null) {
            callback.createSuccess(new DefaultTcpConnectionProxy(conn));
        } else {
            this.create(remoteAddress, null, new ObjectCreateCallback<TCPConnection>(){

                @Override
                public void createSuccess(TCPConnection e) {
                    callback.createSuccess(new DefaultTcpConnectionProxy(e));
                }

                @Override
                public void onException(Throwable ex) {
                    callback.onException(ex);
                }
            }, connectTimeoutMills, null);
        }
    }

    private static class ConnectionPool
    extends LinkedBlockingDeque<TCPRemoteConnection> {
        private static final long serialVersionUID = 2804246165619411850L;
        private volatile long useTimeMills = FrameworkUtil.currentTimeMillis();

        private ConnectionPool() {
        }

        private void updateUseTimeMills() {
            this.useTimeMills = FrameworkUtil.currentTimeMillis();
        }
    }

    private class DefaultTcpConnectionProxy
    implements TCPConnection,
    TCPConnection.ConnectionCloseListener {
        private AtomicBoolean bx = new AtomicBoolean(false);
        TCPConnection conn;
        SocketAddress remoteAddress;
        SocketAddress localAddress;
        ConcurrentLinkedQueue<TCPConnection.ConnectionCloseListener> closeListeners;

        DefaultTcpConnectionProxy(TCPConnection conn) {
            this.conn = conn;
            this.conn.addConnectionCloseListener(this);
            this.remoteAddress = conn.getRemoteAddress();
            this.localAddress = conn.getLocalAddress();
        }

        @Override
        public RequestSender createRequest() throws IOException {
            if (this.bx.get()) {
                throw new IllegalStateException("connection is closed!");
            }
            return this.conn.createRequest();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public SocketAddress getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public boolean isConnected() {
            return !this.bx.get();
        }

        @Override
        public void register(ServiceAction action) {
            if (this.bx.get()) {
                throw new IllegalStateException("connection is closed!");
            }
            this.conn.register(action);
        }

        @Override
        public void unRegister(Class<?> actionClass) {
            if (this.bx.get()) {
                throw new IllegalStateException("connection is closed!");
            }
            this.conn.unRegister(actionClass);
        }

        @Override
        public ServiceAction getAction(String actionName) {
            if (this.bx.get()) {
                return null;
            }
            return this.conn.getAction(actionName);
        }

        @Override
        public void register(String actionName, ServiceAction action) {
            if (this.bx.get()) {
                throw new IllegalStateException("connection is closed!");
            }
            this.conn.register(actionName, action);
        }

        @Override
        public void unRegister(String actionName) {
            if (this.bx.get()) {
                throw new IllegalStateException("connection is closed!");
            }
            this.conn.unRegister(actionName);
        }

        @Override
        public Enumeration<String> getActionNames() {
            if (this.bx.get()) {
                return Collections.enumeration(new ArrayList());
            }
            return this.conn.getActionNames();
        }

        private void recyle() {
            TCPRemoteConnection conn = (TCPRemoteConnection)this.conn;
            if (conn.isConnected() && !conn.getTCPCommunicationHandle().getIoSession().isClosing()) {
                if (TCPConnectionFactoryCreator.this.timeoutObjectPool.addObject(new PoolKey(conn, TCPConnectionFactoryCreator.this.getV()), conn, new TimeoutObjectPool.TimeoutCallback(){

                    @Override
                    public void onTimeout(Object key, Object object) throws Exception {
                        try (TCPRemoteConnection conn1 = (TCPRemoteConnection)object;){
                            ConnectionPool q = (ConnectionPool)TCPConnectionFactoryCreator.this.connectionPoolMap.get(conn1.getRemoteAddress());
                            if (q != null) {
                                q.remove(conn1);
                            }
                        }
                    }
                }, 300L, TimeUnit.SECONDS)) {
                    conn.clearActions();
                    ConnectionPool q = (ConnectionPool)TCPConnectionFactoryCreator.this.connectionPoolMap.get(conn.getRemoteAddress());
                    if (q == null) {
                        q = new ConnectionPool();
                        ConnectionPool q1 = TCPConnectionFactoryCreator.this.connectionPoolMap.putIfAbsent(conn.getRemoteAddress(), q);
                        if (q1 != null) {
                            q = q1;
                        }
                    }
                    q.updateUseTimeMills();
                    q.offerFirst(conn);
                } else {
                    try {
                        conn.close();
                    }
                    catch (Exception ex1) {
                        logger.log(Level.SEVERE, "close conn error!", ex1);
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.bx.compareAndSet(false, true)) {
                TCPRemoteConnection conn1 = (TCPRemoteConnection)this.conn;
                conn1.removeConnectionCloseListener(this);
                try {
                    if (conn1.isConnected() && !conn1.getTCPCommunicationHandle().getIoSession().isClosing()) {
                        TCPConnectionFactoryCreator.checkConnection("/TCPServerHeartbeat", this.conn, new Callback<Map<String, Object>, Object>(){

                            @Override
                            public Object callback(Map<String, Object> param) throws Exception {
                                DefaultTcpConnectionProxy.this.recyle();
                                return null;
                            }

                            @Override
                            public void onException(Throwable ex) {
                                try {
                                    try {
                                        DefaultTcpConnectionProxy.this.conn.close();
                                    }
                                    finally {
                                        logger.log(Level.SEVERE, "check connection error!", ex);
                                    }
                                }
                                catch (Exception ex1) {
                                    logger.log(Level.SEVERE, "close conn error!", ex1);
                                }
                            }
                        });
                    }
                }
                finally {
                    this.fireColseListener();
                }
            }
        }

        @Override
        public Map<String, String> getRemoteHostInfo() {
            if (this.bx.get()) {
                return null;
            }
            return this.conn.getRemoteHostInfo();
        }

        protected void fireColseListener() {
            if (this.closeListeners != null) {
                TCPConnection.ConnectionCloseListener l;
                while ((l = this.closeListeners.poll()) != null) {
                    try {
                        l.onClosed(this);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "callback ConnectionColseListener error!", ex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
            if (l != null) {
                if (this.closeListeners == null) {
                    DefaultTcpConnectionProxy defaultTcpConnectionProxy = this;
                    synchronized (defaultTcpConnectionProxy) {
                        if (this.closeListeners == null) {
                            this.closeListeners = new ConcurrentLinkedQueue();
                        }
                    }
                }
                this.closeListeners.add(l);
            }
            if (this.bx.get()) {
                this.fireColseListener();
            }
        }

        @Override
        public void removeConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
            if (this.closeListeners != null) {
                this.closeListeners.remove(l);
            }
        }

        @Override
        public Enumeration<TCPConnection.ConnectionCloseListener> getConnectionCloseListeners() {
            return Collections.enumeration(this.closeListeners == null ? new ArrayList(0) : this.closeListeners);
        }

        @Override
        public boolean containConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
            return this.closeListeners == null ? false : this.closeListeners.contains(l);
        }

        @Override
        public void onClosed(RemoteConnection connection) {
            if (this.bx.compareAndSet(false, true)) {
                this.fireColseListener();
            }
        }
    }

    private static final class PoolKey {
        final TCPConnection connection;
        final String x;
        final int v;

        PoolKey(TCPConnection connection, int v) {
            this.connection = connection;
            this.x = this.getClass().getName();
            this.v = v;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            result = 31 * result + this.v;
            result = 31 * result + (this.x == null ? 0 : this.x.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
                return false;
            }
            if (this.v != other.v) {
                return false;
            }
            return !(this.x == null ? other.x != null : !this.x.equals(other.x));
        }
    }
}

