/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.TCPConnection;
import com.wovoe.framework.communication.protocol.hmp.HMPSender;
import com.wovoe.framework.communication.protocol.hmp.HMPServiceActionManager;
import com.wovoe.framework.communication.tcp.TCPCommunicationHandle;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class TCPRemoteConnection
implements TCPConnection,
CryptoFactory {
    protected HMPServiceActionManager serviceActionManger;
    protected TCPCommunicationHandle communicationHandle;
    protected ConcurrentLinkedQueue<TCPConnection.ConnectionCloseListener> closeListeners;
    protected SocketAddress remoteAddress;
    protected long lastReceiveTime;
    protected long lastSentTime;
    protected CryptoFactory cryptoFactory;
    protected Map<String, String> remoteHostInfo;
    protected AtomicBoolean closed = new AtomicBoolean(false);

    public TCPRemoteConnection(HMPServiceActionManager serviceActionManger, SocketAddress remoteAddress) {
        this.serviceActionManger = serviceActionManger;
        this.remoteAddress = remoteAddress;
    }

    void resetActionManager(HMPServiceActionManager serviceActionManger) {
        if (serviceActionManger != null) {
            this.serviceActionManger = serviceActionManger;
        }
    }

    public void setTCPCommunicationHandle(TCPCommunicationHandle communicationHandle) {
        this.communicationHandle = communicationHandle;
    }

    TCPCommunicationHandle getTCPCommunicationHandle() {
        return this.communicationHandle;
    }

    public CryptoFactory getCryptoFactory() {
        return this.cryptoFactory;
    }

    public void setCryptoFactory(CryptoFactory cryptoFactory) {
        if (cryptoFactory != this) {
            this.cryptoFactory = cryptoFactory;
        }
    }

    public void clearActions() {
        this.serviceActionManger.clear();
    }

    @Override
    public void register(ServiceAction action) {
        this.serviceActionManger.register(action);
    }

    @Override
    public void unRegister(Class<?> actionClass) {
        this.serviceActionManger.unRegister(actionClass);
    }

    @Override
    public ServiceAction getAction(String actionName) {
        return this.serviceActionManger.getAction(actionName);
    }

    @Override
    public Enumeration<String> getActionNames() {
        return this.serviceActionManger.getActionNames();
    }

    @Override
    public RequestSender createRequest() throws IOException {
        HMPSender sender = new HMPSender(this.communicationHandle);
        return sender;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.communicationHandle.getLocalAddress();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    protected void fireColseListener() {
        if (this.closeListeners != null) {
            TCPConnection.ConnectionCloseListener l;
            while ((l = this.closeListeners.poll()) != null) {
                try {
                    l.onClosed(this);
                }
                catch (Exception ex) {
                    this.communicationHandle.getLogger().log(Level.SEVERE, "callback ConnectionColseListener error!", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
        if (l != null) {
            if (this.closeListeners == null) {
                TCPRemoteConnection tCPRemoteConnection = this;
                synchronized (tCPRemoteConnection) {
                    if (this.closeListeners == null) {
                        this.closeListeners = new ConcurrentLinkedQueue();
                    }
                }
            }
            this.closeListeners.add(l);
        }
        if (this.isClosed()) {
            this.fireColseListener();
        }
    }

    @Override
    public void removeConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
        if (this.closeListeners != null) {
            this.closeListeners.remove(l);
        }
    }

    @Override
    public Enumeration<TCPConnection.ConnectionCloseListener> getConnectionCloseListeners() {
        return Collections.enumeration(this.closeListeners == null ? new ArrayList(0) : this.closeListeners);
    }

    @Override
    public boolean containConnectionCloseListener(TCPConnection.ConnectionCloseListener l) {
        return this.closeListeners == null ? false : this.closeListeners.contains(l);
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public void setLastReceiveTime(long lastReceiveTime) {
        this.lastReceiveTime = lastReceiveTime;
    }

    public long getLastSentTime() {
        return this.lastSentTime;
    }

    public void setLastSentTime(long lastSentTime) {
        this.lastSentTime = lastSentTime;
    }

    @Override
    public boolean isConnected() {
        return this.communicationHandle.isStart();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.doClose();
            }
            finally {
                this.fireColseListener();
            }
        }
    }

    protected void doClose() throws IOException {
        if (this.communicationHandle.isStart()) {
            this.communicationHandle.shutdown();
        }
    }

    @Override
    public void register(String actionName, ServiceAction action) {
        this.serviceActionManger.register(actionName, action);
    }

    @Override
    public void unRegister(String actionName) {
        this.serviceActionManger.unRegister(actionName);
    }

    @Override
    public Map<String, String> getRemoteHostInfo() {
        return this.remoteHostInfo;
    }

    public void setRemoteHostInfo(Map<String, String> info) {
        this.remoteHostInfo = info;
    }

    @Override
    public ByteBuffer decrypt(ByteBuffer encryptBuffer) throws Exception {
        CryptoFactory c = this.cryptoFactory;
        if (c != null && c != this) {
            return c.decrypt(encryptBuffer);
        }
        return encryptBuffer;
    }

    @Override
    public ByteBuffer encrypt(ByteBuffer dataBuf) throws Exception {
        CryptoFactory c = this.cryptoFactory;
        if (c != null && c != this) {
            return c.encrypt(dataBuf);
        }
        return dataBuf;
    }
}

