/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.communication.tcp.TcpNetworkHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class TCPServer
implements IoHandler {
    private NioSocketAcceptor nioaccept;
    private ConcurrentHashMap<Integer, TcpNetworkHandler> handlersMap = new ConcurrentHashMap();

    public TCPServer() {
        this(0);
    }

    public TCPServer(int processorCount) {
        this.nioaccept = processorCount <= 0 ? new NioSocketAcceptor() : new NioSocketAcceptor(processorCount);
        this.nioaccept.setHandler(this);
    }

    public void bind(TcpNetworkHandler handler) throws IOException {
        this.nioaccept.bind((SocketAddress)handler.getBindAddress());
        this.handlersMap.put(handler.getBindPort(), handler);
    }

    public void unBind(InetSocketAddress bindAddress) {
        this.nioaccept.unbind(bindAddress);
        TcpNetworkHandler handler = this.handlersMap.remove(bindAddress.getPort());
        if (handler != null) {
            handler.onClose();
        }
    }

    public void close() {
        try {
            Iterator<Map.Entry<Integer, TcpNetworkHandler>> it = this.handlersMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, TcpNetworkHandler> entry = it.next();
                it.remove();
                try {
                    entry.getValue().onClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.nioaccept.dispose();
        }
    }

    protected TcpNetworkHandler getTcpNetworkHandler(IoSession session) {
        Integer ax = ((InetSocketAddress)session.getLocalAddress()).getPort();
        TcpNetworkHandler handler = this.handlersMap.get(ax);
        return handler;
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.exceptionCaught(session, cause);
        }
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.messageReceived(session, message);
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.messageSent(session, message);
        }
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.sessionClosed(session);
        }
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.sessionCreated(session);
        }
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.sessionIdle(session, status);
        }
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        TcpNetworkHandler handler = this.getTcpNetworkHandler(session);
        if (handler != null) {
            handler.sessionOpened(session);
        }
    }
}

