/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.TransportProtocol;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.SyncRunAction;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpActionProtocolHandler {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final char a = '?';
    private static final String b = "&";
    private static final char c = '=';
    private static final char g = '&';
    private static final String HEAD_SEND_ID = "S";
    private static final String HEAD_RESPONSE = "R";
    private static final String HEAD_RQUESTID = "D";
    private static final String HEAD_TRUE = "1";
    private static final String HEAD_FALSE = "0";
    private HMPResponseSenderFactory senderFactory;
    private ServiceActionManager actionManager;
    private CryptoFactory crypto;
    private final String wairtKeypprex;
    private static final Logger logger = Logger.getLogger(TcpActionProtocolHandler.class.getName());

    public TcpActionProtocolHandler(HMPResponseSenderFactory senderFactory, ServiceActionManager actionManager, CryptoFactory crypto) {
        this.senderFactory = senderFactory;
        this.actionManager = actionManager;
        this.wairtKeypprex = RandomStringGenerator.getDefaultInstance().getNewString(32);
        if (crypto == null) {
            crypto = new CryptoFactory(){

                @Override
                public ByteBuffer decrypt(ByteBuffer encryptBuffer) throws Exception {
                    return encryptBuffer;
                }

                @Override
                public ByteBuffer encrypt(ByteBuffer dataBuf) throws Exception {
                    return dataBuf;
                }
            };
        }
        this.crypto = crypto;
    }

    public boolean handleRead(byte[] data, SocketAddress srcAddress, SocketAddress localAddress, Logger logger, TimeoutObjectPool pool) throws Exception {
        if (logger == null) {
            logger = TcpActionProtocolHandler.logger;
        }
        if (data == null || data.length == 0) {
            logger.warning("\u6570\u636e\u4e3a\u7a7a!");
            return false;
        }
        ByteBuffer appBuf = ByteBuffer.wrap(data);
        try {
            appBuf = this.crypto.decrypt(appBuf);
        }
        catch (Exception ex) {
            logger.warning("\u89e3\u5bc6\u9519\u8bef!");
            return false;
        }
        HMPAppPacket appPacket = new HMPAppPacket();
        appPacket.setTransportProtocol(TransportProtocol.TCP);
        appPacket.setLocalAddress(localAddress);
        appPacket.setRemoteAddress(srcAddress);
        appPacket.setSenderFactory(this.senderFactory);
        if (this.handleDataPacket(appPacket, appBuf, srcAddress, logger)) {
            ServiceAction action;
            String remoteSendId = appPacket.removeFirstHeaderValue(HEAD_SEND_ID);
            appPacket.setRemoteSendId(Integer.parseInt(remoteSendId));
            String R = appPacket.removeFirstHeaderValue(HEAD_RESPONSE);
            if (HEAD_TRUE.equals(R)) {
                String D = appPacket.removeFirstHeaderValue(HEAD_RQUESTID);
                Integer sendId = Integer.valueOf(D);
                ReceiveCallback callback = (ReceiveCallback)pool.removeObject(this.getWaitKey(sendId));
                if (callback != null) {
                    Runnable r = TcpActionProtocolHandler.newTask(logger, callback, sendId, null, appPacket);
                    r.run();
                }
                return false;
            }
            if (this.actionManager != null && (action = this.actionManager.getAction(appPacket.getActionName())) != null) {
                Runnable r = TcpActionProtocolHandler.newTask(logger, null, null, action, appPacket);
                if (action instanceof SyncRunAction) {
                    r.run();
                } else {
                    r.run();
                }
            }
            return false;
        }
        return false;
    }

    private static Runnable newTask(final Logger logger, final ReceiveCallback callback, final Integer sendId, final ServiceAction action, final HMPAppPacket appPacket) {
        return new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (callback != null && sendId != null) {
                            callback.doReceiver(appPacket, sendId);
                        } else if (action != null) {
                            action.service(appPacket);
                        }
                    }
                    catch (Throwable ex) {
                        if (logger == null) break block5;
                        logger.log(Level.SEVERE, "", ex);
                    }
                }
            }
        };
    }

    protected Object getWaitKey(int id) {
        return new XWaitKey(this.wairtKeypprex, this.hashCode(), id);
    }

    private String getString(ByteBuffer packet, int len, String charset) throws UnsupportedEncodingException {
        int offset;
        byte[] array;
        if (packet.hasArray()) {
            array = packet.array();
            offset = packet.arrayOffset() + packet.position();
            packet.position(packet.position() + len);
        } else {
            array = new byte[len];
            packet.get(array);
            offset = 0;
        }
        String str = new String(array, offset, len, charset);
        return str;
    }

    protected boolean handleDataPacket(HMPAppPacket appPacket, ByteBuffer packet, SocketAddress receiveAddress, Logger logger) throws Exception {
        int plen;
        if (logger == null) {
            logger = TcpActionProtocolHandler.logger;
        }
        if (!packet.hasRemaining()) {
            logger.warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,\u7f3a\u5c11\u57dfCHARSET\u957f\u5ea6");
            return false;
        }
        int len = packet.get() & 0xFF;
        if (len > packet.remaining()) {
            logger.warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,CHARSET\u957f\u5ea6\u975e\u6cd5:" + len);
            return false;
        }
        String charset = this.getString(packet, len, ISO_8859_1);
        if (packet.remaining() < 4) {
            logger.warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,\u7f3a\u5c11\u57dfHEAD\u957f\u5ea6");
            return false;
        }
        len = packet.getInt();
        if (len > packet.remaining()) {
            logger.warning(receiveAddress + "\u89e3\u6790\u534f\u8bae\u9519\u8bef,HEAD\u957f\u5ea6\u975e\u6cd5:" + len);
            return false;
        }
        String url = this.getString(packet, len, charset);
        int gindex = url.indexOf(63);
        String actionName = gindex != -1 ? url.substring(0, gindex) : url;
        appPacket.setCharset(charset);
        appPacket.setActionName(actionName);
        if (url.length() > actionName.length() + 1) {
            String param = url.substring(actionName.length() + 1);
            StringTokenizer tokens = new StringTokenizer(param, b);
            while (tokens.hasMoreTokens()) {
                int g;
                String entry = tokens.nextToken();
                if (entry.length() <= 0 || (g = entry.indexOf(61)) == -1) continue;
                String key = URLDecoder.decode(entry.substring(0, g), charset);
                String value = URLDecoder.decode(entry.substring(g + 1, entry.length()), charset);
                appPacket.addHeader(key, value);
            }
        }
        if (packet.remaining() > 4 && (plen = packet.getInt()) <= packet.remaining()) {
            int offset;
            byte[] data;
            if (!packet.hasArray()) {
                data = new byte[plen];
                packet.get(data);
                offset = 0;
            } else {
                data = packet.array();
                offset = packet.arrayOffset() + packet.position();
            }
            appPacket.setData(data, offset, plen);
        }
        return true;
    }

    public ByteBuffer handleWrite(HMPAppPacket appPacket, TimeoutObjectPool pool) throws Exception {
        if (appPacket.getCharset() == null) {
            appPacket.setCharset(DEFAULT_CHARSET);
        }
        String sendId = String.valueOf(appPacket.getSendId());
        appPacket.addFirstHeader(HEAD_SEND_ID, sendId);
        if (appPacket.isResponse()) {
            appPacket.addFirstHeader(HEAD_RESPONSE, HEAD_TRUE);
            appPacket.addFirstHeader(HEAD_RQUESTID, String.valueOf(appPacket.getRemoteRequestId()));
        } else {
            appPacket.addFirstHeader(HEAD_RESPONSE, HEAD_FALSE);
        }
        StringBuilder bu = new StringBuilder(128);
        bu.append(appPacket.getActionName()).append('?');
        Enumeration<String> headNames = appPacket.getHeaderNames();
        while (headNames.hasMoreElements()) {
            String name = headNames.nextElement();
            String[] strs = appPacket.getHeaderValues(name);
            if (strs == null || strs.length <= 0) continue;
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str != null) {
                    bu.append(URLEncoder.encode(name, appPacket.getCharset())).append('=').append(URLEncoder.encode(str, appPacket.getCharset())).append('&');
                }
                ++n2;
            }
        }
        ByteBuffer buf = this.toDataByteBuffer(bu.toString(), appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength(), appPacket.getCharset());
        buf = this.crypto.encrypt(buf);
        final ReceiveCallback rcallback = appPacket.getReceiveCallback();
        if (rcallback != null) {
            pool.addObject(this.getWaitKey(appPacket.getSendId()), rcallback, new TimeoutObjectPool.TimeoutCallback(){

                @Override
                public void onTimeout(Object key, Object object) throws Exception {
                    rcallback.onWaitTimeout();
                }
            }, rcallback.getWaitTimeoutMills(), TimeUnit.MILLISECONDS);
        }
        return buf;
    }

    protected ByteBuffer toDataByteBuffer(String simpleUrl, byte[] data, int offset, int length, String charset) throws IllegalArgumentException {
        byte[] charsetb;
        byte[] b1;
        if (simpleUrl == null) {
            return null;
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            b1 = simpleUrl.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            charsetb = charset.getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            charsetb = charset.getBytes();
        }
        if (charsetb.length > 255) {
            charsetb = DEFAULT_CHARSET.getBytes();
        }
        int len = 1 + charsetb.length + b1.length + 4 + (data == null ? 0 : length + 4);
        ByteBuffer b = ByteBuffer.allocate(len);
        b.put((byte)charsetb.length);
        b.put(charsetb);
        b.putInt(b1.length);
        b.put(b1);
        if (data != null) {
            b.putInt(length);
            b.put(data, offset, length);
        }
        b.flip();
        return b;
    }

    private static final class XWaitKey {
        private String name;
        private int v;
        private int id;

        public XWaitKey(String name, int v, int id) {
            this.name = name;
            this.v = v;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.v;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XWaitKey other = (XWaitKey)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.v == other.v;
        }
    }
}

