/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CRC16;
import com.wovoe.framework.communication.tcp.ParseDataResult;
import java.nio.ByteBuffer;

public class TcpFrameProtocolHandler {
    private static final byte ESCAPE = 0;
    private static final byte HEAD_TAIL = -6;
    private static final byte HEAD_FLAG = 1;
    private static final byte TAIL_FLAG = 2;
    private static final int WAIT_HEAD = 0;
    private static final int WAIT_HEAD_FLAG = 1;
    private static final int WAIT_DATALEN = 2;
    private static final int WAIT_DATA = 3;
    private static final int WAIT_CRC = 4;
    private static final int WAIT_TAIL = 5;
    private static final int WAIT_TAIL_FLAG = 6;
    private static final int MAXLEN = 0xA00000;
    private volatile int state = 0;
    private byte[] dataLenBytes = new byte[4];
    private int dataLenIndex = 0;
    private byte[] data;
    private int dataIndex = 0;
    private byte[] crc = new byte[2];
    private int crcIndex = 0;
    private boolean waitEscape = false;

    private void clear() {
        this.waitEscape = false;
        this.dataLenIndex = 0;
        this.dataIndex = 0;
        this.crcIndex = 0;
        this.data = null;
        this.state = 0;
    }

    public synchronized ParseDataResult parse(ByteBuffer buf) {
        while (buf.hasRemaining()) {
            byte b = buf.get();
            ParseDataResult r = this.parseRevByte(b);
            if (r == null) continue;
            return r;
        }
        return new ParseDataResult(0, null);
    }

    private ParseDataResult parseRevByte(byte b) {
        if (this.state == 0) {
            if (b != -6) {
                return new ParseDataResult(2, "parse error! not HEAD byte: " + b);
            }
            this.state = 1;
        } else if (this.state == 1) {
            if (b != 1) {
                this.clear();
                return new ParseDataResult(2, "parse error! not HEAD_FLAG byte: " + b);
            }
            this.waitEscape = false;
            this.dataLenIndex = 0;
            this.state = 2;
        } else if (this.state == 2) {
            if (this.waitEscape) {
                if (b != 0) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! not a escape " + b);
                }
                this.waitEscape = false;
            } else {
                if (b == -6) {
                    this.waitEscape = true;
                }
                this.dataLenBytes[this.dataLenIndex++] = b;
            }
            if (!this.waitEscape && this.dataLenIndex == this.dataLenBytes.length) {
                int len = BytesTool.bytesToInt(this.dataLenBytes, 0);
                if (len > 0xA00000) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! data length to long! " + len);
                }
                if (len <= 0) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! data length invalid! " + len);
                }
                this.dataIndex = 0;
                this.data = new byte[len];
                this.state = 3;
            }
        } else if (this.state == 3) {
            if (this.waitEscape) {
                if (b != 0) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! not a escape " + b);
                }
                this.waitEscape = false;
            } else {
                if (b == -6) {
                    this.waitEscape = true;
                }
                this.data[this.dataIndex++] = b;
            }
            if (!this.waitEscape && this.dataIndex == this.data.length) {
                this.crcIndex = 0;
                this.state = 4;
            }
        } else if (this.state == 4) {
            if (this.waitEscape) {
                if (b != 0) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! not a escape " + b);
                }
                this.waitEscape = false;
            } else {
                if (b == -6) {
                    this.waitEscape = true;
                }
                this.crc[this.crcIndex++] = b;
            }
            if (!this.waitEscape && this.crcIndex == this.crc.length) {
                int crcValue;
                int checkcrc = CRC16.calculate(this.data, 0, this.data.length);
                if (checkcrc != (crcValue = (this.crc[0] & 0xFF) << 8 | this.crc[1] & 0xFF)) {
                    this.clear();
                    return new ParseDataResult(2, "parse error! crc check error! ");
                }
                this.state = 5;
            }
        } else if (this.state == 5) {
            if (b != -6) {
                this.clear();
                return new ParseDataResult(2, "parse error! not TAIL byte: " + b);
            }
            this.state = 6;
        } else if (this.state == 6) {
            if (b != 2) {
                this.clear();
                return new ParseDataResult(2, "parse error! not TAIL_FLAG byte: " + b);
            }
            ParseDataResult result = new ParseDataResult(1, this.data);
            this.clear();
            return result;
        }
        return null;
    }

    public ByteBuffer handleWrite(ByteBuffer buf) {
        return TcpFrameProtocolHandler.toSendBuf(buf);
    }

    public static ByteBuffer toSendBuf(ByteBuffer buf) {
        byte[] array;
        int length;
        int offset;
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return TcpFrameProtocolHandler.toSendBuf(array, offset, length);
    }

    public static ByteBuffer toSendBuf(byte[] data, int offset, int length) {
        int ecapLen = 0;
        int end = offset + length;
        int i = offset;
        while (i < end) {
            if (data[i] == -6) {
                ++ecapLen;
            }
            ++i;
        }
        int crcValue = CRC16.calculate(data, offset, length);
        byte[] crcV = new byte[]{(byte)(crcValue >> 8), (byte)crcValue};
        int i2 = 0;
        while (i2 < crcV.length) {
            if (crcV[i2] == -6) {
                ++ecapLen;
            }
            ++i2;
        }
        byte[] dataLenBytes = BytesTool.intToBytes(length);
        int i3 = 0;
        while (i3 < dataLenBytes.length) {
            if (dataLenBytes[i3] == -6) {
                ++ecapLen;
            }
            ++i3;
        }
        ByteBuffer buf = ByteBuffer.allocate(dataLenBytes.length + crcV.length + length + ecapLen + 4);
        buf.put((byte)-6);
        buf.put((byte)1);
        int i4 = 0;
        while (i4 < dataLenBytes.length) {
            buf.put(dataLenBytes[i4]);
            if (dataLenBytes[i4] == -6) {
                buf.put((byte)0);
            }
            ++i4;
        }
        i4 = offset;
        while (i4 < end) {
            buf.put(data[i4]);
            if (data[i4] == -6) {
                buf.put((byte)0);
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < crcV.length) {
            buf.put(crcV[i4]);
            if (crcV[i4] == -6) {
                buf.put((byte)0);
            }
            ++i4;
        }
        buf.put((byte)-6);
        buf.put((byte)2);
        buf.flip();
        return buf;
    }
}

