/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import com.wovoe.framework.communication.tcp.ParseDataResult;
import com.wovoe.framework.communication.tcp.TcpActionProtocolHandler;
import com.wovoe.framework.communication.tcp.TcpFrameProtocolHandler;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class TcpProtocolHandler
extends AbstractProtocolHandler {
    private TcpFrameProtocolHandler protocol = new TcpFrameProtocolHandler();
    private TcpActionProtocolHandler actionProtocolHandler;
    private static final Integer ATTTIMES = 1;

    public TcpProtocolHandler(HMPResponseSenderFactory senderFactory, ServiceActionManager actionManager, CryptoFactory crypto) {
        this.actionProtocolHandler = new TcpActionProtocolHandler(senderFactory, actionManager, crypto);
    }

    @Override
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer buf = (ByteBuffer)ctx.getMessage();
        if (buf == null || !buf.hasRemaining()) {
            return false;
        }
        SocketAddress receiveAddress = (SocketAddress)ctx.getAttribute("receive.source.address");
        while (buf.hasRemaining()) {
            ParseDataResult result = this.protocol.parse(buf);
            if (result.getResult() == 0) break;
            if (result.getResult() == 1) {
                byte[] data = (byte[])result.getMessage();
                this.actionProtocolHandler.handleRead(data, receiveAddress, ctx.getCommunicationHandle().getLocalAddress(), ctx.getCommunicationHandle().getLogger(), ctx.getCommunicationHandle().getTimeoutObjectPool());
                continue;
            }
            throw new IOException(receiveAddress + "-->\u89e3\u6790\u9519\u8bef! " + result.getMessage());
        }
        return false;
    }

    @Override
    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        Object mess = ctx.getMessage();
        if (mess == null) {
            return false;
        }
        if (!(mess instanceof HMPAppPacket)) {
            return true;
        }
        HMPAppPacket appPacket = (HMPAppPacket)ctx.getMessage();
        ByteBuffer buffer = this.actionProtocolHandler.handleWrite(appPacket, ctx.getCommunicationHandle().getTimeoutObjectPool());
        buffer = this.protocol.handleWrite(buffer);
        ctx.setAttribute("send.attempt.times", ATTTIMES);
        if (ctx.getAttribute("send.ack.key") != null) {
            ctx.removeAttribute("send.ack.key");
        }
        ByteArrayPacket[] sendPackets = new ByteArrayPacket[]{new ByteBufferPacket(buffer)};
        ctx.setMessage(sendPackets);
        return true;
    }
}

