/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication.tcp;

import com.wovoe.framework.FrameworkUtil;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.TCPConnection;
import com.wovoe.framework.communication.tcp.DefaultTCPCommunicationHandleFactory;
import com.wovoe.framework.communication.tcp.DefaultTcpConnectContext;
import com.wovoe.framework.communication.tcp.TCPConnectionFactoryCreator;
import com.wovoe.framework.impl.MappedTimeoutObjectPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpZClientTest
implements ServiceAction {
    static final Logger logger = Logger.getLogger(TcpZClientTest.class.getName());

    public static void main(String[] args) throws Exception {
        final InetSocketAddress serverAddress = new InetSocketAddress("127.0.0.1", 5521);
        MappedTimeoutObjectPool timeoutObjectPool = new MappedTimeoutObjectPool();
        DefaultTcpConnectContext context = new DefaultTcpConnectContext();
        DefaultTCPCommunicationHandleFactory fac = new DefaultTCPCommunicationHandleFactory(null);
        final TCPConnectionFactoryCreator crator = new TCPConnectionFactoryCreator(context, serverAddress, timeoutObjectPool, fac);
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(5);
        int threadCount = 20;
        int i = 0;
        while (i < threadCount) {
            scheduledExecutorService.schedule(new Tast(crator, scheduledExecutorService), 5L, TimeUnit.SECONDS);
            ++i;
        }
        scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                int sessionSize = crator.getAllSessionSize();
                int poolSize = crator.getPoolConnectionSize(serverAddress);
                System.out.println("IOSession.Size:" + sessionSize + " connection pool size:" + poolSize);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static boolean xequals(byte[] a1, int a1offset, int a1length, byte[] a2, int a2offset, int a2length) {
        if (a1 == a2) {
            return true;
        }
        if (a1length == 0 && a2length == 0) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1length != a2length) {
            return false;
        }
        int end1 = a1offset + a1length;
        int i = a1offset;
        int j = a2offset;
        while (i < end1) {
            if (a1[i] != a2[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    @Override
    public void service(Receiver request) throws Exception {
        ResponseSender response = request.createResponse();
        response.addHeader("cc", "clientResponse");
        Enumeration<String> res = request.getHeaderNames();
        while (res.hasMoreElements()) {
            String name = res.nextElement();
            response.addHeader(name, request.getHeaderValue(name));
        }
        response.setSendData(request.getData(), request.getDataOffset(), request.getDataLength());
        response.doResponse(new SendCallback(){

            @Override
            public void onException(Throwable exception) {
                logger.log(Level.SEVERE, "\u53d1\u9001\u5ba2\u6237\u7aef\u54cd\u5e94\u670d\u52a1\u5668\u7aef\u6570\u636e\u5931\u8d25!", exception);
            }

            @Override
            public void onCompleted() {
            }
        }, null);
    }

    static class Tast
    implements Runnable {
        Random r = new Random();
        AtomicBoolean finish = new AtomicBoolean(true);
        byte[] bytes = new byte[102400];
        TCPConnectionFactoryCreator crator;
        ScheduledExecutorService scheduledExecutorService;

        public Tast(TCPConnectionFactoryCreator crator, ScheduledExecutorService scheduledExecutorService) {
            this.crator = crator;
            this.scheduledExecutorService = scheduledExecutorService;
        }

        void doFinish(TCPConnection conn) {
            try {
                this.finish.set(true);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException e2) {
                    logger.log(Level.SEVERE, "\u5173\u95ed\u8fde\u63a5\u5931\u8d25", e2);
                }
            }
            finally {
                this.scheduledExecutorService.schedule(this, (long)(Math.abs(this.r.nextInt()) % 10000), TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void run() {
            try {
                if (this.finish.compareAndSet(true, false)) {
                    this.r.nextBytes(this.bytes);
                    final long t1 = FrameworkUtil.currentTimeMillis();
                    this.crator.acquireConnectionFromPool(null, new ObjectCreateCallback<TCPConnection>(){

                        @Override
                        public void onException(Throwable ex) {
                            this.doFinish(null);
                            logger.log(Level.SEVERE, "\u83b7\u53d6\u8fde\u63a5\u5931\u8d25", ex);
                        }

                        @Override
                        public void createSuccess(final TCPConnection conn) {
                            try {
                                final long t2 = FrameworkUtil.currentTimeMillis();
                                System.out.println("\u6210\u529f\u83b7\u53d6\u8fde\u63a5\u8017\u65f6:" + (t2 - t1) + "\u6beb\u79d2");
                                if (conn.getAction("/clientTest") == null) {
                                    conn.register("/clientTest", new TcpZClientTest());
                                }
                                RequestSender sender = conn.createRequest();
                                final int length = Math.abs(r.nextInt()) % bytes.length;
                                boolean offset = false;
                                final String sendNano = String.valueOf(System.nanoTime()) + "_" + r.nextInt();
                                sender.setRequestActionName("/serverTest");
                                sender.setHeader("clientNano", sendNano);
                                sender.setSendData(bytes, 0, length);
                                sender.setNeedEncrypt(true);
                                sender.doRequest(new SendCallback(){

                                    @Override
                                    public void onException(Throwable exception) {
                                        this.doFinish(conn);
                                        logger.log(Level.SEVERE, "\u53d1\u9001\u5931\u8d25", exception);
                                    }

                                    @Override
                                    public void onCompleted() {
                                        long t3 = FrameworkUtil.currentTimeMillis();
                                        System.out.println("\u53d1\u9001\u6210\u529f\u8017\u65f6:" + (t3 - t2) + "\u6beb\u79d2");
                                    }
                                }, new ReceiveCallback(){

                                    @Override
                                    public void onWaitTimeout() throws Exception {
                                        this.doFinish(conn);
                                        logger.log(Level.SEVERE, "\u7b49\u5f85\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6");
                                    }

                                    @Override
                                    public long getWaitTimeoutMills() {
                                        return 5000L;
                                    }

                                    @Override
                                    public void doReceiver(Receiver receiver, int sendId) throws Exception {
                                        try {
                                            long t4 = FrameworkUtil.currentTimeMillis();
                                            if (TcpZClientTest.xequals(bytes, 0, length, receiver.getData(), receiver.getDataOffset(), receiver.getDataLength()) && "servrResponse".equals(receiver.getHeaderValue("xx")) && sendNano.equals(receiver.getHeaderValue("clientNano"))) {
                                                System.out.println("\u6d4b\u8bd5\u6210\u529f! \u6570\u636e\u957f\u5ea6:" + receiver.getDataLength() + " \u53d1\u9001\u5230\u7b49\u5f85\u8017\u65f6:" + (t4 - t2) + "\u6beb\u79d2\u3002" + " \u4ece\u8fde\u63a5\u7b97\u8017\u65f6:" + (t4 - t1) + "\u6beb\u79d2\u3002");
                                            } else {
                                                System.err.println("\u6d4b\u8bd5\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u4e00\u81f4!");
                                            }
                                        }
                                        finally {
                                            this.doFinish(conn);
                                        }
                                    }
                                });
                            }
                            catch (Exception e1) {
                                logger.log(Level.SEVERE, "\u53d1\u9001\u5931\u8d25", e1);
                                this.doFinish(conn);
                            }
                        }
                    }, 6000);
                }
            }
            catch (Exception ex) {
                this.doFinish(null);
                logger.log(Level.SEVERE, "", ex);
            }
        }
    }
}

