/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.impl;

import com.wovoe.framework.CancelAdvice;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultOperationFuture<R>
implements OperationFutureHandler<R> {
    private CountDownLatch latch = new CountDownLatch(1);
    private volatile R result;
    private volatile boolean cancelled;
    private volatile Throwable exception;
    private CancelAdvice cancelAdvice;
    private Queue<CompleteListenerProxy<R>> listeners;
    private TimeoutObjectPool timeoutObjectPool;

    public DefaultOperationFuture(TimeoutObjectPool timeoutObjectPool) {
        this.timeoutObjectPool = timeoutObjectPool;
    }

    public TimeoutObjectPool getTimeoutObjectPool() {
        return this.timeoutObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return this.cancelled;
        }
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.isDone()) {
                return this.cancelled;
            }
            this.cancelled = true;
            this.latch.countDown();
        }
        CancelAdvice c = this.cancelAdvice;
        if (c != null) {
            try {
                c.cancel(mayInterruptIfRunning);
            }
            catch (Throwable ex) {
                LogUtil.getLog().error((Object)"cancel operation error!", ex);
            }
        }
        this.notifyListeners();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() < 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setResult(R result) {
        if (this.isDone()) {
            return false;
        }
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            block5: {
                if (!this.isDone()) break block5;
                return false;
            }
            this.result = result;
            this.latch.countDown();
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setException(Throwable exception) {
        if (this.isDone()) {
            return;
        }
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.isDone()) {
                return;
            }
            this.exception = exception;
            this.latch.countDown();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            CompleteListenerProxy<R> l;
            while ((l = this.listeners.poll()) != null) {
                if (((CompleteListenerProxy)l).removeFromPool) {
                    Object lx = this.getTimeoutObjectPool().removeObject(l);
                    if (lx == null) continue;
                    this.notifyListener(l);
                    continue;
                }
                this.notifyListener(l);
            }
        }
    }

    private void notifyListener(OperationFuture.CompleteListener<R> l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            LogUtil.getLog().error((Object)"notify Listener error!", t);
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.cancelled) {
            throw new InterruptedException("cancel!");
        }
        if (this.exception != null) {
            if (this.exception instanceof InterruptedException) {
                throw (InterruptedException)this.exception;
            }
            if (this.exception instanceof ExecutionException) {
                throw (ExecutionException)this.exception;
            }
            throw new ExecutionException(this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        if (this.cancelled) {
            throw new InterruptedException("cancel!");
        }
        if (this.exception != null) {
            if (this.exception instanceof InterruptedException) {
                throw (InterruptedException)this.exception;
            }
            if (this.exception instanceof ExecutionException) {
                throw (ExecutionException)this.exception;
            }
            throw new ExecutionException(this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompleteListener(OperationFuture.CompleteListener<R> l) {
        if (l == null) {
            return;
        }
        boolean invokeHere = false;
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.isDone()) {
                invokeHere = true;
            } else {
                if (this.listeners == null) {
                    this.listeners = new ConcurrentLinkedQueue<CompleteListenerProxy<R>>();
                }
                CompleteListenerProxy<R> proxy = new CompleteListenerProxy<R>(l, false);
                this.listeners.offer(proxy);
            }
        }
        if (invokeHere) {
            this.notifyListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompleteListener(OperationFuture.CompleteListener<R> l, long timeout, TimeUnit unit) throws IllegalStateException {
        if (l == null) {
            return;
        }
        boolean invokeHere = false;
        boolean invokeTimeout = false;
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.isDone()) {
                invokeHere = true;
            } else {
                if (this.listeners == null) {
                    this.listeners = new ConcurrentLinkedQueue<CompleteListenerProxy<R>>();
                }
                if (timeout <= 0L) {
                    invokeTimeout = true;
                } else {
                    final CompleteListenerProxy<R> proxy = new CompleteListenerProxy<R>(l, true);
                    boolean add = this.getTimeoutObjectPool().addObject(proxy, proxy, new TimeoutObjectPool.TimeoutCallback(){

                        @Override
                        public void onTimeout(Object key, Object object) throws Exception {
                            try {
                                try {
                                    proxy.waitCompleteTimeout();
                                }
                                catch (Throwable ex) {
                                    LogUtil.getLog().error((Object)"notify Listener timeout error!", ex);
                                    if (DefaultOperationFuture.this.listeners != null) {
                                        DefaultOperationFuture.this.listeners.remove(proxy);
                                    }
                                }
                            }
                            finally {
                                if (DefaultOperationFuture.this.listeners != null) {
                                    DefaultOperationFuture.this.listeners.remove(proxy);
                                }
                            }
                        }
                    }, timeout, unit);
                    if (add) {
                        this.listeners.offer(proxy);
                    } else {
                        throw new IllegalStateException("can not add linstener to the pool! ");
                    }
                }
            }
        }
        if (invokeHere) {
            this.notifyListener(l);
        }
        if (invokeTimeout) {
            try {
                l.waitCompleteTimeout();
            }
            catch (Throwable ex) {
                LogUtil.getLog().error((Object)"notify Listener timeout error!", ex);
            }
        }
    }

    public CancelAdvice getCancelAdvice() {
        return this.cancelAdvice;
    }

    @Override
    public void setCancelAdvice(CancelAdvice cancelAdvice) {
        this.cancelAdvice = cancelAdvice;
    }

    @Override
    public void removeCompleteListener(OperationFuture.CompleteListener<R> l) {
        if (l == null) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        CompleteListenerProxy z = null;
        for (CompleteListenerProxy completeListenerProxy : this.listeners) {
            if (!completeListenerProxy.l.equals(l)) continue;
            z = completeListenerProxy;
            break;
        }
        if (z != null) {
            this.listeners.remove(z);
            if (z.removeFromPool) {
                this.getTimeoutObjectPool().removeObject(z);
            }
        }
    }

    @Override
    public R getResult() {
        return this.result;
    }

    private static class CompleteListenerProxy<R>
    implements OperationFuture.CompleteListener<R> {
        private final OperationFuture.CompleteListener<R> l;
        private final AtomicBoolean invoked;
        private final boolean removeFromPool;

        CompleteListenerProxy(OperationFuture.CompleteListener<R> f, boolean removeFromPool) {
            this.l = f;
            this.invoked = new AtomicBoolean(false);
            this.removeFromPool = removeFromPool;
        }

        @Override
        public void operationComplete(OperationFuture<R> futrue) {
            if (this.invoked.compareAndSet(false, true) && this.l != null) {
                this.l.operationComplete(futrue);
            }
        }

        @Override
        public void waitCompleteTimeout() {
            if (this.invoked.compareAndSet(false, true) && this.l != null) {
                this.l.waitCompleteTimeout();
            }
        }
    }
}

