/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.impl;

import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.impl.MappedTimeoutObjectPool;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HashTimeoutObjectPool
implements TimeoutObjectPool {
    private MappedTimeoutObjectPool[] pool;
    private AtomicBoolean stop = new AtomicBoolean(false);

    public HashTimeoutObjectPool() {
        this(-1);
    }

    public HashTimeoutObjectPool(int roundRobinSize) {
        this(roundRobinSize, null);
    }

    public HashTimeoutObjectPool(Executor timeoutCallbackExecutor) {
        this(-1, timeoutCallbackExecutor);
    }

    public HashTimeoutObjectPool(int roundRobinSize, Executor timeoutCallbackExecutor) {
        if (roundRobinSize <= 0) {
            roundRobinSize = 1;
        }
        this.pool = new MappedTimeoutObjectPool[roundRobinSize];
        int i = 0;
        while (i < roundRobinSize) {
            this.pool[i] = new MappedTimeoutObjectPool(false, timeoutCallbackExecutor);
            ++i;
        }
    }

    @Override
    public boolean addObject(Object key, Object object, TimeoutObjectPool.TimeoutCallback callback, long timeout, TimeUnit timeoutUnit) {
        if (key == null) {
            return false;
        }
        return this.getMappedTimeoutObjectPool(key).addObject(key, object, callback, timeout, timeoutUnit);
    }

    private MappedTimeoutObjectPool getMappedTimeoutObjectPool(Object key) {
        return this.pool[Math.abs(HashTimeoutObjectPool.hash(key.hashCode())) % this.pool.length];
    }

    @Override
    public boolean restTimeout(Object key, long timeout, TimeUnit timeoutUnit) {
        if (key == null) {
            return false;
        }
        return this.getMappedTimeoutObjectPool(key).restTimeout(key, timeout, timeoutUnit);
    }

    @Override
    public Object removeObject(Object key) {
        if (key == null) {
            return null;
        }
        return this.getMappedTimeoutObjectPool(key).removeObject(key);
    }

    @Override
    public Object getObject(Object key) {
        if (key == null) {
            return null;
        }
        return this.getMappedTimeoutObjectPool(key).getObject(key);
    }

    @Override
    public int getObjectsSize() {
        int h = 0;
        MappedTimeoutObjectPool[] mappedTimeoutObjectPoolArray = this.pool;
        int n = this.pool.length;
        int n2 = 0;
        while (n2 < n) {
            MappedTimeoutObjectPool p = mappedTimeoutObjectPoolArray[n2];
            h += p.getObjectsSize();
            ++n2;
        }
        return h;
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public boolean isClosed() {
        return this.stop.get();
    }

    public void close() {
        if (this.stop.compareAndSet(false, true)) {
            MappedTimeoutObjectPool[] mappedTimeoutObjectPoolArray = this.pool;
            int n = this.pool.length;
            int n2 = 0;
            while (n2 < n) {
                MappedTimeoutObjectPool p = mappedTimeoutObjectPoolArray[n2];
                p.close();
                ++n2;
            }
        }
    }
}

