/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.impl;

import com.wovoe.framework.LogUtil;
import com.wovoe.framework.TimeoutObjectPool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MappedTimeoutObjectPool
implements TimeoutObjectPool {
    private static final long NANO_ORIGIN = System.nanoTime();
    private HashMap<Object, Task> pool = new HashMap();
    private TreeMap<Long, Task> queue = new TreeMap();
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private AtomicBoolean stop = new AtomicBoolean(false);
    private Thread checkThread = new Thread(this.newRunnable(), "Check-Object-Timeout-Thread-" + sequence.incrementAndGet());
    private static AtomicLong sequence = new AtomicLong(0L);
    private Executor timeoutCallbackExecutor;
    private boolean isLocalCreate;

    static final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    protected void doRun(TimeoutObjectPool.TimeoutCallback callback, Task task) {
        if (callback != null) {
            Executor e = this.getTimeoutCallbackExecutor();
            if (e == null) {
                if (this.stop.get()) {
                    return;
                }
                new Thread(task).start();
                return;
            }
            if (e instanceof ScheduledExecutorService) {
                ((ScheduledExecutorService)e).schedule(task, 0L, TimeUnit.MILLISECONDS);
            } else {
                e.execute(task);
            }
        } else {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getTimeoutCallbackExecutor() {
        if (this.timeoutCallbackExecutor == null && this.timeoutCallbackExecutor == null) {
            MappedTimeoutObjectPool mappedTimeoutObjectPool = this;
            synchronized (mappedTimeoutObjectPool) {
                block6: {
                    if (!this.stop.get()) break block6;
                    return null;
                }
                if (this.timeoutCallbackExecutor == null) {
                    ExecutorService e = Executors.newSingleThreadExecutor(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = new Thread(r, "Thread-single-daemon-useTimeoutCallback-" + sequence.incrementAndGet());
                            if (t.isDaemon()) {
                                t.setDaemon(true);
                            }
                            return t;
                        }
                    });
                    this.timeoutCallbackExecutor = e;
                    this.isLocalCreate = true;
                }
            }
        }
        return this.timeoutCallbackExecutor;
    }

    @Override
    public boolean addObject(Object key, Object object, TimeoutObjectPool.TimeoutCallback callback, long timeout, TimeUnit timeoutUnit) {
        block17: {
            Task hold;
            ReentrantLock lock;
            block15: {
                block16: {
                    block13: {
                        block14: {
                            if (this.isClosed()) {
                                return false;
                            }
                            if (key == null || object == null || timeoutUnit == null) {
                                return false;
                            }
                            if (timeout <= 0L) {
                                if (callback != null) {
                                    try {
                                        callback.onTimeout(key, object);
                                    }
                                    catch (Exception e) {
                                        new RuntimeException(e);
                                    }
                                }
                                return true;
                            }
                            lock = this.lock;
                            hold = null;
                            lock.lock();
                            try {
                                if (!this.isClosed()) break block13;
                                lock.unlock();
                                if (hold == null) break block14;
                            }
                            catch (Throwable throwable) {
                                lock.unlock();
                                if (hold != null) {
                                    hold.recycle();
                                }
                                throw throwable;
                            }
                            hold.recycle();
                        }
                        return false;
                    }
                    if (this.pool.get(key) == null) break block15;
                    lock.unlock();
                    if (hold == null) break block16;
                    hold.recycle();
                }
                return false;
            }
            Map.Entry<Long, Task> first = this.queue.firstEntry();
            Task ntask = new Task();
            ntask.next = null;
            ntask.pre = null;
            ntask.key = key;
            ntask.value = object;
            ntask.callback = callback;
            ntask.nonTriggerTime = MappedTimeoutObjectPool.now() + timeoutUnit.toNanos(timeout);
            hold = this.pool.put(key, ntask);
            this.removeFromQueue(hold);
            Task told = this.queue.put(ntask.nonTriggerTime, ntask);
            if (told != null) {
                ntask.next = told;
                told.pre = ntask;
            }
            if (first == null || ntask.nonTriggerTime < first.getKey()) {
                this.available.signalAll();
            }
            lock.unlock();
            if (hold == null) break block17;
            hold.recycle();
        }
        return true;
    }

    public MappedTimeoutObjectPool() {
        this(false, null);
    }

    public MappedTimeoutObjectPool(boolean daemon, Executor timeoutCallbackExecutor) {
        if (daemon) {
            this.checkThread.setDaemon(true);
        }
        this.checkThread.start();
        this.timeoutCallbackExecutor = timeoutCallbackExecutor;
        this.isLocalCreate = false;
    }

    public MappedTimeoutObjectPool(Executor timeoutCallbackExecutor) {
        this(false, timeoutCallbackExecutor);
    }

    private void removeFromQueue(Task task) {
        if (task != null) {
            if (task.pre == null) {
                Task t1 = this.queue.remove(task.nonTriggerTime);
                assert (t1 == task);
                if (t1.next != null) {
                    t1.next.pre = null;
                    Task t2 = this.queue.put(t1.next.nonTriggerTime, t1.next);
                    t1.next = null;
                    assert (t2 == null);
                }
            } else {
                Task t2 = task.next;
                if (t2 != null) {
                    t2.pre = task.pre;
                    task.next = null;
                }
                task.pre.next = t2;
                task.pre = null;
            }
        }
    }

    @Override
    public Object removeObject(Object key) {
        if (this.isClosed()) {
            return null;
        }
        if (key == null) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        Task hold = null;
        try {
            hold = this.pool.remove(key);
            this.removeFromQueue(hold);
            Object v = null;
            if (hold != null) {
                Object object = v = hold.value;
                return object;
            }
            Object object = v;
            return object;
        }
        finally {
            lock.unlock();
            if (hold != null) {
                hold.recycle();
            }
        }
    }

    private Runnable newRunnable() {
        return new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                de = new LinkedList<Task>();
                while (!MappedTimeoutObjectPool.access$1(MappedTimeoutObjectPool.this).get()) {
                    try {
                        de.clear();
                        task = null;
                        nanos = TimeUnit.HOURS.toNanos(12L);
                        MappedTimeoutObjectPool.access$2(MappedTimeoutObjectPool.this).lockInterruptibly();
                        try {
                            while (true) {
                                block18: {
                                    block16: {
                                        block17: {
                                            if ((first = MappedTimeoutObjectPool.access$3(MappedTimeoutObjectPool.this).firstEntry()) != null) break block16;
                                            if (nanos > 0L) break block17;
                                            ** GOTO lbl54
                                        }
                                        nanos = MappedTimeoutObjectPool.access$4(MappedTimeoutObjectPool.this).awaitNanos(nanos);
                                        continue;
                                    }
                                    delay = (Long)first.getKey() - MappedTimeoutObjectPool.now();
                                    if (delay <= 0L) break;
                                    if (nanos > 0L) break block18;
                                    ** GOTO lbl54
                                }
                                if (delay > nanos) {
                                    delay = nanos;
                                }
                                timeLeft = MappedTimeoutObjectPool.access$4(MappedTimeoutObjectPool.this).awaitNanos(delay);
                                nanos -= delay - timeLeft;
                            }
                            its = MappedTimeoutObjectPool.access$3(MappedTimeoutObjectPool.this).entrySet().iterator();
                            while (its.hasNext()) {
                                e1 = its.next();
                                delay = (Long)e1.getKey() - MappedTimeoutObjectPool.now();
                                if (delay > 0L) break;
                                task = (Task)e1.getValue();
                                while (task != null) {
                                    Task.access$2(task, null);
                                    MappedTimeoutObjectPool.access$5(MappedTimeoutObjectPool.this).remove(Task.access$11(task));
                                    de.offer(task);
                                    task = Task.access$9(task);
                                }
                                its.remove();
                            }
                            if (!MappedTimeoutObjectPool.$assertionsDisabled && de.isEmpty()) {
                                throw new AssertionError();
                            }
                            ** GOTO lbl54
                        }
                        finally {
                            MappedTimeoutObjectPool.access$2(MappedTimeoutObjectPool.this).unlock();
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Task.access$12(task);
                                continue;
                            }
                            catch (Throwable ex) {
                                LogUtil.getLog().error((Object)"\u56de\u8c03\u9519\u8bef", ex);
                            }
lbl54:
                            // 5 sources

                            ** while ((task = (Task)de.poll()) != null)
                        }
lbl55:
                        // 1 sources

                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) continue;
                        LogUtil.getLog().error((Object)"\u7406\u8bba\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u5f02\u5e38!", t);
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean x;
        if (this.stop.get()) {
            return;
        }
        MappedTimeoutObjectPool mappedTimeoutObjectPool = this;
        synchronized (mappedTimeoutObjectPool) {
            x = this.stop.compareAndSet(false, true);
        }
        if (x) {
            this.lock.lock();
            try {
                this.checkThread.interrupt();
                this.checkThread = null;
                this.pool.clear();
                this.queue.clear();
                if (this.timeoutCallbackExecutor != null && this.isLocalCreate) {
                    ExecutorService s = (ExecutorService)this.timeoutCallbackExecutor;
                    s.shutdown();
                    s.shutdownNow();
                    this.timeoutCallbackExecutor = null;
                }
                if (this.checkThread != null) {
                    this.checkThread.interrupt();
                    this.checkThread = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public int getObjectsSize() {
        if (this.isClosed()) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.pool.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object getObject(Object key) {
        if (key == null) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Task hold = this.pool.get(key);
            if (hold != null) {
                Object object = hold.value;
                return object;
            }
            return null;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isClosed() {
        return this.stop.get();
    }

    @Override
    public boolean restTimeout(Object key, long timeout, TimeUnit timeoutUnit) {
        boolean runCallback;
        Object v;
        TimeoutObjectPool.TimeoutCallback callback;
        block17: {
            if (this.isClosed() || timeoutUnit == null || key == null) {
                return false;
            }
            callback = null;
            v = null;
            runCallback = timeout <= 0L;
            ReentrantLock lock = this.lock;
            lock.lock();
            Task hold = null;
            try {
                hold = this.pool.remove(key);
                this.removeFromQueue(hold);
                if (hold == null) {
                    return false;
                }
                v = hold.value;
                callback = hold.callback;
                if (runCallback) break block17;
                Map.Entry<Long, Task> first = this.queue.firstEntry();
                Task ntask = new Task();
                ntask.next = null;
                ntask.pre = null;
                ntask.key = key;
                ntask.value = v;
                ntask.callback = callback;
                ntask.nonTriggerTime = MappedTimeoutObjectPool.now() + timeoutUnit.toNanos(timeout);
                Task hold1 = this.pool.put(key, ntask);
                try {
                    this.removeFromQueue(hold1);
                    Task told = this.queue.put(ntask.nonTriggerTime, ntask);
                    if (told != null) {
                        ntask.next = told;
                        told.pre = ntask;
                    }
                    if (first == null || ntask.nonTriggerTime < first.getKey()) {
                        this.available.signalAll();
                    }
                }
                finally {
                    if (hold1 != null) {
                        hold1.recycle();
                    }
                }
                return true;
            }
            finally {
                lock.unlock();
                if (hold != null) {
                    hold.recycle();
                }
            }
        }
        if (runCallback) {
            if (callback != null) {
                try {
                    callback.onTimeout(key, v);
                }
                catch (Exception e) {
                    new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ AtomicBoolean access$1(MappedTimeoutObjectPool mappedTimeoutObjectPool) {
        return mappedTimeoutObjectPool.stop;
    }

    static /* synthetic */ ReentrantLock access$2(MappedTimeoutObjectPool mappedTimeoutObjectPool) {
        return mappedTimeoutObjectPool.lock;
    }

    static /* synthetic */ TreeMap access$3(MappedTimeoutObjectPool mappedTimeoutObjectPool) {
        return mappedTimeoutObjectPool.queue;
    }

    static /* synthetic */ Condition access$4(MappedTimeoutObjectPool mappedTimeoutObjectPool) {
        return mappedTimeoutObjectPool.available;
    }

    static /* synthetic */ HashMap access$5(MappedTimeoutObjectPool mappedTimeoutObjectPool) {
        return mappedTimeoutObjectPool.pool;
    }

    protected class Task
    implements Runnable {
        private long nonTriggerTime;
        private Task next;
        private Task pre;
        private Object key;
        private Object value;
        private TimeoutObjectPool.TimeoutCallback callback;

        protected Task() {
        }

        @Override
        public void run() {
            try {
                try {
                    if (this.callback != null) {
                        this.callback.onTimeout(this.key, this.value);
                    }
                }
                catch (Exception ex) {
                    LogUtil.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                    this.recycle();
                }
            }
            finally {
                this.recycle();
            }
        }

        private void docall() {
            MappedTimeoutObjectPool.this.doRun(this.callback, this);
        }

        private void recycle() {
            this.nonTriggerTime = 0L;
            this.next = null;
            this.pre = null;
            this.key = null;
            this.value = null;
            this.callback = null;
        }

        static /* synthetic */ Object access$11(Task task) {
            return task.key;
        }

        static /* synthetic */ void access$12(Task task) {
            task.docall();
        }
    }
}

