/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.nativetransport;

import com.wovoe.nativetransport.NativeTransport;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class App {
    private TrayIcon trayIcon;
    private SystemTray tray;

    public App() {
        this.init();
    }

    private void init() {
        Image image;
        if (!SystemTray.isSupported()) {
            System.err.println("System tray is not supported.");
            return;
        }
        this.setLookAndFeel(null);
        this.tray = SystemTray.getSystemTray();
        String imgName = "576.png";
        try {
            image = ImageIO.read(this.getClass().getResource(imgName));
        }
        catch (IOException e2) {
            image = Toolkit.getDefaultToolkit().getImage(imgName);
        }
        PopupMenu popup = new PopupMenu();
        MenuItem exitItem = new MenuItem("  Exit  ");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NativeTransport.close();
            }
        });
        popup.add(exitItem);
        this.trayIcon = new TrayIcon(image, "\u8f66\u724c\u8bc6\u522b\u89c6\u9891\u670d\u52a1\u7a0b\u5e8f", popup);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.this.trayIcon.displayMessage("\u8f66\u724c\u8bc6\u522b\u89c6\u9891\u670d\u52a1\u7a0b\u5e8f", "\u70b9\u51fb\u53f3\u952e\u53ef\u9000\u51fa\u6b64\u7a0b\u5e8f!", TrayIcon.MessageType.INFO);
            }
        });
        try {
            this.tray.add(this.trayIcon);
            TransportUtil.addTransportCloseListener(new TransportCloseListener(){

                @Override
                public void onClose() throws Exception {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                App.this.tray.remove(App.this.trayIcon);
                            }
                        });
                    } else {
                        App.this.tray.remove(App.this.trayIcon);
                    }
                }
            });
        }
        catch (AWTException e1) {
            System.err.println("TrayIcon could not be added");
        }
    }

    public void setLookAndFeel(String LookAndFeel2) {
        if (LookAndFeel2 == null || (LookAndFeel2 = LookAndFeel2.trim()).length() == 0) {
            LookAndFeel2 = "Nimbus";
        }
        String Nimbus = null;
        String Windows = null;
        String WindowsClassic = null;
        String gtk = null;
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        int idx = 0;
        while (idx < installedLookAndFeels.length) {
            String v = installedLookAndFeels[idx].getName();
            if (LookAndFeel2.equals(v)) {
                try {
                    UIManager.setLookAndFeel(installedLookAndFeels[idx].getClassName());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("Nimbus".equals(v)) {
                Nimbus = installedLookAndFeels[idx].getClassName();
            } else if ("Windows".equals(v)) {
                Windows = installedLookAndFeels[idx].getClassName();
            } else if ("Windows Classic".equals(v)) {
                WindowsClassic = installedLookAndFeels[idx].getClassName();
            } else if ("gtk".equals(v)) {
                gtk = installedLookAndFeels[idx].getClassName();
            }
            ++idx;
        }
        if (Nimbus != null) {
            try {
                UIManager.setLookAndFeel(Nimbus);
            }
            catch (Exception exception) {}
        } else if (Windows != null) {
            try {
                UIManager.setLookAndFeel(Windows);
            }
            catch (Exception exception) {}
        } else if (WindowsClassic != null) {
            try {
                UIManager.setLookAndFeel(WindowsClassic);
            }
            catch (Exception exception) {}
        } else if (gtk != null) {
            try {
                UIManager.setLookAndFeel(gtk);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

