/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.nativetransport;

import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class NativeClassLoadAction
implements ServiceAction {
    public static final String PATH = "/NativeClassLoadAction";
    private static final ConcurrentHashMap<String, Object> loadClassMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if ("loadClassIfNeed".equals(op)) {
            String className = request.getHeaderValue("className");
            if (className == null) {
                this.responseError(request, "\u7f3a\u5c11className\u53c2\u6570!", null);
                return;
            }
            if (!loadClassMap.containsKey(className)) {
                String lockKey = String.valueOf(className) + "+lock";
                Object lock = loadClassMap.get(lockKey);
                if (lock == null) {
                    Object l = new Object();
                    Object old = loadClassMap.putIfAbsent(lockKey, l);
                    lock = old == null ? l : old;
                }
                Object object = lock;
                synchronized (object) {
                    if (!loadClassMap.containsKey(className)) {
                        try {
                            Class<?> cl = Class.forName(className);
                            if (cl != null) {
                                loadClassMap.put(className, cl);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            this.responseError(request, "\u65e0\u6cd5\u627e\u5230\u7c7b:" + className, e);
                            return;
                        }
                        catch (Throwable ex) {
                            this.responseError(request, "\u521d\u59cb\u5316\u9a71\u52a8\u5f02\u5e38:" + className, ex);
                            return;
                        }
                    }
                }
            }
        } else {
            this.responseError(request, "\u65e0\u6548\u64cd\u4f5c" + op, null);
            return;
        }
        ResponseSender response = request.createResponse();
        response.setHeader("op", op);
        response.setHeader("result", "true");
        response.doResponse(null, null);
    }

    private void responseError(Receiver request, String message, Throwable e) throws IOException {
        String e1;
        ResponseSender response = request.createResponse();
        response.setHeader("result", "error");
        if (message != null && message.length() > 0) {
            response.setHeader("msg", message);
        }
        if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
            response.setHeader("msg1", e1);
        }
        response.doResponse(null, null);
    }
}

