/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.nativetransport;

import com.wovoe.framework.communication.protocol.Client;
import com.wovoe.framework.communication.protocol.hmp.HMPClientManager;
import com.wovoe.framework.communication.protocol.hmp.HMPServiceActionManager;
import com.wovoe.framework.communication.tcp.CommonTCPCommunicationHandleFactory;
import com.wovoe.framework.communication.tcp.DefaultTcpNetworkHandler;
import com.wovoe.framework.communication.tcp.TCPServer;
import com.wovoe.framework.impl.DefaultKeyManager;
import com.wovoe.framework.impl.HashTimeoutObjectPool;
import com.wovoe.framework.impl.MappedTimeoutObjectPool;
import com.wovoe.nativetransport.App;
import com.wovoe.nativetransport.ExitSystemAction;
import com.wovoe.nativetransport.NativeClassLoadAction;
import com.wovoe.nativetransport.PathFinder;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;

public class NativeTransport {
    private static ExecutorService executorService;
    private static ScheduledExecutorService scheduledExecutorService;
    private static HashTimeoutObjectPool timeoutObjectPool;
    private static AtomicLong sequence;
    private static boolean canClose;
    private static TCPServer tcpServer;
    private static ScheduledFuture<?> checkPxa;

    static {
        sequence = new AtomicLong(0L);
    }

    public static void main(String[] args) {
        try {
            int acceptTcpPort = 48036;
            boolean startApp = false;
            if (args != null && args.length > 0) {
                String PARAM_startApp = "startApp";
                String PARAM_port = "port_";
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s != null && s.length() > 0) {
                        if ("startApp".equals(s)) {
                            startApp = true;
                        } else if (s.startsWith("port_")) {
                            acceptTcpPort = Integer.parseInt(s.substring("port_".length()));
                        }
                    }
                    ++n2;
                }
            }
            NativeTransport.loadJars();
            System.out.println("\u52a0\u8f7djar\u6210\u529f");
            NativeTransport.init();
            HMPServiceActionManager serviceActionManager = new HMPServiceActionManager();
            serviceActionManager.register("/NativeClassLoadAction", new NativeClassLoadAction());
            serviceActionManager.register("/ExitSystemAction", new ExitSystemAction());
            DefaultKeyManager keymanger = new DefaultKeyManager();
            TransportUtil.setKeyManager(keymanger);
            TransportUtil.setServiceActionManager(serviceActionManager);
            final HMPClientManager clientManager = new HMPClientManager();
            TransportUtil.setTCPClientManager(clientManager);
            System.out.println("\u51c6\u5907\u542f\u52a8\u670d\u52a1");
            MappedTimeoutObjectPool timeoutObjectPool = new MappedTimeoutObjectPool();
            CommonTCPCommunicationHandleFactory fac = new CommonTCPCommunicationHandleFactory(null);
            DefaultTcpNetworkHandler tcpNetworkHandler = new DefaultTcpNetworkHandler(acceptTcpPort, clientManager, timeoutObjectPool, fac, serviceActionManager);
            tcpServer = new TCPServer();
            tcpServer.bind(tcpNetworkHandler);
            checkPxa = scheduledExecutorService.scheduleAtFixedRate(new Runnable(){
                int xcount = 0;

                @Override
                public void run() {
                    Enumeration<Client> cl = clientManager.getClients();
                    boolean havClient = false;
                    if (cl != null) {
                        while (cl.hasMoreElements()) {
                            if (cl.nextElement() == null) continue;
                            havClient = true;
                            break;
                        }
                    }
                    if (havClient) {
                        this.xcount = 0;
                    } else {
                        ++this.xcount;
                        if (this.xcount >= 5) {
                            NativeTransport.close();
                        }
                    }
                }
            }, 2L, 2L, TimeUnit.SECONDS);
            if (startApp) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new App();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("\u670d\u52a1\u5df2\u542f\u52a8");
        }
        catch (Throwable ex) {
            try {
                System.err.println("\u542f\u52a8\u7a0b\u5e8f\u5f02\u5e38");
                ex.printStackTrace();
            }
            finally {
                System.exit(-1);
            }
        }
    }

    private static void loadJars() throws Exception {
        if (NativeTransport.isJar()) {
            File jarFile = new File(PathFinder.findHomeDir(), "jar");
            if (!jarFile.exists() || !jarFile.isDirectory()) {
                return;
            }
            final ArrayList<URL> jarURL = new ArrayList<URL>();
            jarFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File paramFile) {
                    String fileName;
                    if (paramFile.isFile() && (fileName = paramFile.getName()).endsWith(".jar") && !fileName.startsWith("NativeTransport") && !fileName.startsWith("NativeStart")) {
                        try {
                            jarURL.add(paramFile.toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    return false;
                }
            });
            if (!jarURL.isEmpty()) {
                NativeTransport.loadJarOrClass(jarURL);
            }
        }
    }

    public static void loadJarOrClass(Collection<URL> urlset) throws Exception {
        Method addURLMethod = null;
        addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURLMethod.setAccessible(true);
        for (URL url : urlset) {
            addURLMethod.invoke((Object)ClassLoader.getSystemClassLoader(), url);
        }
    }

    private static void init() throws Exception {
        executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "native-work-thread" + sequence.incrementAndGet());
                return t;
            }
        }){

            @Override
            public void shutdown() {
                if (!canClose) {
                    throw new IllegalStateException("Can not be closed by an external program!");
                }
                super.shutdown();
            }

            @Override
            public List<Runnable> shutdownNow() {
                if (canClose) {
                    return super.shutdownNow();
                }
                throw new IllegalStateException("Can not be closed by an external program!");
            }
        };
        TransportUtil.setWorkThreadPool(executorService);
        scheduledExecutorService = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "native-scheduled-thread" + sequence.incrementAndGet());
                return t;
            }
        }){

            @Override
            public void shutdown() {
                if (!canClose) {
                    throw new IllegalStateException("Can not be closed by an external program!");
                }
                super.shutdown();
            }

            @Override
            public List<Runnable> shutdownNow() {
                if (canClose) {
                    return super.shutdownNow();
                }
                throw new IllegalStateException("Can not be closed by an external program!");
            }
        };
        TransportUtil.setScheduledExecutorService(scheduledExecutorService);
        timeoutObjectPool = new HashTimeoutObjectPool(3, executorService){

            @Override
            public void close() {
                if (!canClose) {
                    throw new IllegalStateException("Can not be closed by an external program!");
                }
                super.close();
            }
        };
        TransportUtil.setTimeoutObjectPool(timeoutObjectPool);
    }

    public static boolean isJar() {
        ProtectionDomain pd = TransportUtil.class.getProtectionDomain();
        if (pd == null) {
            return false;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return false;
        }
        URL url = cs.getLocation();
        if (url == null) {
            return false;
        }
        String result = url.toString();
        return result.endsWith(".jar");
    }

    public static void close() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    TransportUtil.getLog().error((Object)"\u5173\u95ed\u7a0b\u5e8f5s\u8d85\u65f6,\u5f3a\u5236\u9000\u51fa!");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        }).start();
        canClose = true;
        Enumeration<TransportCloseListener> l = TransportUtil.getTransportCloseListeners();
        while (l.hasMoreElements()) {
            try {
                l.nextElement().onClose();
            }
            catch (Throwable e) {
                TransportUtil.getLog().error((Object)"", e);
            }
        }
        if (checkPxa != null) {
            checkPxa.cancel(true);
        }
        if (tcpServer != null) {
            tcpServer.close();
        }
        if (timeoutObjectPool != null) {
            timeoutObjectPool.close();
        }
        if (executorService != null) {
            executorService.shutdown();
            executorService.shutdownNow();
        }
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdown();
            scheduledExecutorService.shutdownNow();
        }
        System.out.println("exit1bcdefg124678g466ghd1");
        System.exit(0);
    }
}

