/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.nativetransport;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class PathFinder {
    private static File startupDir;

    public static File findHomeDir() {
        if (startupDir == null) {
            ProtectionDomain pd = PathFinder.class.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            String result = url.toString();
            if (!result.endsWith(".jar")) {
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.endsWith("/bin")) {
                    result = result.substring(0, result.lastIndexOf(47));
                }
            } else {
                result = result.substring(0, result.lastIndexOf(47));
            }
            if ((result = result.substring(0, result.lastIndexOf(47))) == null) {
                throw new RuntimeException("Can not find the app boot path.");
            }
            if (Character.isUpperCase(result.charAt(0))) {
                char[] chars = result.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                result = new String(chars);
            }
            try {
                startupDir = new File(new URI(result));
            }
            catch (URISyntaxException e) {
                new RuntimeException(e);
            }
        }
        return startupDir;
    }
}

