/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.nativetransport;

import com.wovoe.framework.FrameworkUtil;
import com.wovoe.framework.KeyManager;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.ClientManager;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.nativetransport.PathFinder;
import com.wovoe.nativetransport.TransportCloseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportUtil {
    public static final String PUSH_NAME = "/NativeTrasportPushAction";
    private static ExecutorService workThreadPool;
    private static ScheduledExecutorService scheduledExecutorService;
    private static TimeoutObjectPool timeoutObjectPool;
    private static KeyManager keyManager;
    private static ServiceActionManager serviceActionManager;
    private static ClientManager tcpClientManager;
    private static Log log;
    private static ConcurrentLinkedQueue<TransportCloseListener> transportCloseListeners;

    static {
        log = LogFactory.getLog(TransportUtil.class);
        transportCloseListeners = new ConcurrentLinkedQueue();
    }

    public static void addTransportCloseListener(TransportCloseListener l) {
        if (l != null) {
            transportCloseListeners.add(l);
        }
    }

    public static void removeTransportCloseListener(TransportCloseListener l) {
        if (l != null) {
            transportCloseListeners.remove(l);
        }
    }

    public static Enumeration<TransportCloseListener> getTransportCloseListeners() {
        return Collections.enumeration(transportCloseListeners);
    }

    public static ExecutorService getWorkThreadPool() {
        return workThreadPool;
    }

    static void setWorkThreadPool(ExecutorService workThreadPool0) {
        workThreadPool = workThreadPool0;
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    static void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService0) {
        scheduledExecutorService = scheduledExecutorService0;
    }

    public static TimeoutObjectPool getTimeoutObjectPool() {
        return timeoutObjectPool;
    }

    static void setTimeoutObjectPool(TimeoutObjectPool timeoutObjectPool0) {
        timeoutObjectPool = timeoutObjectPool0;
    }

    public static KeyManager getKeyManager() {
        return keyManager;
    }

    static void setKeyManager(KeyManager keyManager0) {
        keyManager = keyManager0;
    }

    public static ServiceActionManager getServiceActionManager() {
        return serviceActionManager;
    }

    static void setServiceActionManager(ServiceActionManager serviceActionManager0) {
        serviceActionManager = serviceActionManager0;
    }

    public static ClientManager getTCPClientManager() {
        return tcpClientManager;
    }

    static void setTCPClientManager(ClientManager tcpClientManager0) {
        tcpClientManager = tcpClientManager0;
    }

    public static File findHomeDir() {
        return PathFinder.findHomeDir();
    }

    public static Log getLog() {
        return log;
    }

    public static long currentTimeMillis() {
        return FrameworkUtil.currentTimeMillis();
    }

    public static long currentTimeNanos() {
        return FrameworkUtil.currentTimeNanos();
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                out.flush();
            }
        }
        catch (Throwable throwable) {
            TransportUtil.closeInputStream(in);
            TransportUtil.closeOutputStream(out);
            throw throwable;
        }
        TransportUtil.closeInputStream(in);
        TransportUtil.closeOutputStream(out);
    }

    public static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            TransportUtil.getLog().error((Object)"", (Throwable)e);
        }
    }
}

