/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.filterchain;

import org.apache.commons.logging.Log;
import org.apache.mina.MinaLog;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;

public class IoFilterEvent
extends IoEvent {
    static Log LOGGER = MinaLog.getLogger();
    static boolean DEBUG = LOGGER.isDebugEnabled();
    private final IoFilter.NextFilter nextFilter;

    public IoFilterEvent(IoFilter.NextFilter nextFilter, IoEventType type, IoSession session, Object parameter) {
        super(type, session, parameter);
        if (nextFilter == null) {
            throw new IllegalArgumentException("nextFilter must not be null");
        }
        this.nextFilter = nextFilter;
    }

    public IoFilter.NextFilter getNextFilter() {
        return this.nextFilter;
    }

    @Override
    public void fire() {
        IoSession session = this.getSession();
        IoFilter.NextFilter nextFilter = this.getNextFilter();
        IoEventType type = this.getType();
        if (DEBUG) {
            LOGGER.debug((Object)("Firing a " + (Object)((Object)type) + " event for session " + session.getId()));
        }
        switch (type) {
            case MESSAGE_RECEIVED: {
                Object parameter = this.getParameter();
                nextFilter.messageReceived(session, parameter);
                break;
            }
            case MESSAGE_SENT: {
                WriteRequest writeRequest = (WriteRequest)this.getParameter();
                nextFilter.messageSent(session, writeRequest);
                break;
            }
            case WRITE: {
                WriteRequest writeRequest = (WriteRequest)this.getParameter();
                nextFilter.filterWrite(session, writeRequest);
                break;
            }
            case CLOSE: {
                nextFilter.filterClose(session);
                break;
            }
            case EXCEPTION_CAUGHT: {
                Throwable throwable = (Throwable)this.getParameter();
                nextFilter.exceptionCaught(session, throwable);
                break;
            }
            case SESSION_IDLE: {
                nextFilter.sessionIdle(session, (IdleStatus)this.getParameter());
                break;
            }
            case SESSION_OPENED: {
                nextFilter.sessionOpened(session);
                break;
            }
            case SESSION_CREATED: {
                nextFilter.sessionCreated(session);
                break;
            }
            case SESSION_CLOSED: {
                nextFilter.sessionClosed(session);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)type));
            }
        }
        if (DEBUG) {
            LOGGER.debug((Object)("Event " + (Object)((Object)type) + " has been fired for session  " + session.getId()));
        }
    }
}

