/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.event;

import org.apache.commons.logging.Log;
import org.apache.mina.MinaLog;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.proxy.event.IoSessionEventType;

public class IoSessionEvent {
    private static final Log logger = MinaLog.getLogger();
    private final IoFilter.NextFilter nextFilter;
    private final IoSession session;
    private final IoSessionEventType type;
    private IdleStatus status;

    public IoSessionEvent(IoFilter.NextFilter nextFilter, IoSession session, IoSessionEventType type) {
        this.nextFilter = nextFilter;
        this.session = session;
        this.type = type;
    }

    public IoSessionEvent(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        this(nextFilter, session, IoSessionEventType.IDLE);
        this.status = status;
    }

    public void deliverEvent() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delivering event " + this));
        }
        IoSessionEvent.deliverEvent(this.nextFilter, this.session, this.type, this.status);
    }

    private static void deliverEvent(IoFilter.NextFilter nextFilter, IoSession session, IoSessionEventType type, IdleStatus status) {
        switch (type) {
            case CREATED: {
                nextFilter.sessionCreated(session);
                break;
            }
            case OPENED: {
                nextFilter.sessionOpened(session);
                break;
            }
            case IDLE: {
                nextFilter.sessionIdle(session, status);
                break;
            }
            case CLOSED: {
                nextFilter.sessionClosed(session);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(IoSessionEvent.class.getSimpleName());
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" - [ ").append(this.session);
        sb.append(", ").append((Object)this.type);
        sb.append(']');
        return sb.toString();
    }

    public IdleStatus getStatus() {
        return this.status;
    }

    public IoFilter.NextFilter getNextFilter() {
        return this.nextFilter;
    }

    public IoSession getSession() {
        return this.session;
    }

    public IoSessionEventType getType() {
        return this.type;
    }
}

