/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.mina.MinaLog;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.proxy.AbstractProxyLogicHandler;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.IoBufferDecoder;
import org.apache.mina.proxy.utils.StringUtilities;

public abstract class AbstractHttpLogicHandler
extends AbstractProxyLogicHandler {
    private static final Log LOGGER = MinaLog.getLogger();
    private static final String DECODER = String.valueOf(AbstractHttpLogicHandler.class.getName()) + ".Decoder";
    private static final byte[] HTTP_DELIMITER = new byte[]{13, 10, 13, 10};
    private static final byte[] CRLF_DELIMITER = new byte[]{13, 10};
    private IoBuffer responseData = null;
    private HttpProxyResponse parsedResponse = null;
    private int contentLength = -1;
    private boolean hasChunkedData;
    private boolean waitingChunkedData;
    private boolean waitingFooters;
    private int entityBodyStartPosition;
    private int entityBodyLimitPosition;

    public AbstractHttpLogicHandler(ProxyIoSession proxyIoSession) {
        super(proxyIoSession);
    }

    @Override
    public synchronized void messageReceived(IoFilter.NextFilter nextFilter, IoBuffer buf) throws ProxyAuthException {
        IoBufferDecoder decoder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" messageReceived()");
        }
        if ((decoder = (IoBufferDecoder)this.getSession().getAttribute(DECODER)) == null) {
            decoder = new IoBufferDecoder(HTTP_DELIMITER);
            this.getSession().setAttribute(DECODER, decoder);
        }
        try {
            IoBuffer tmp;
            if (this.parsedResponse == null) {
                this.responseData = decoder.decodeFully(buf);
                if (this.responseData == null) {
                    return;
                }
                String responseHeader = this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder());
                this.entityBodyStartPosition = this.responseData.position();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("  response header received:\n " + responseHeader.replace("\r", "\\r").replace("\n", "\\n\n")));
                }
                this.parsedResponse = this.decodeResponse(responseHeader);
                if (this.parsedResponse.getStatusCode() == 200 || this.parsedResponse.getStatusCode() >= 300 && this.parsedResponse.getStatusCode() <= 307) {
                    buf.position(0);
                    this.setHandshakeComplete();
                    return;
                }
                String contentLengthHeader = StringUtilities.getSingleValuedHeader(this.parsedResponse.getHeaders(), "Content-Length");
                if (contentLengthHeader == null) {
                    this.contentLength = 0;
                } else {
                    this.contentLength = Integer.parseInt(contentLengthHeader.trim());
                    decoder.setContentLength(this.contentLength, true);
                }
            }
            if (!this.hasChunkedData) {
                if (this.contentLength > 0) {
                    tmp = decoder.decodeFully(buf);
                    if (tmp == null) {
                        return;
                    }
                    this.responseData.setAutoExpand(true);
                    this.responseData.put(tmp);
                    this.contentLength = 0;
                }
                if ("chunked".equalsIgnoreCase(StringUtilities.getSingleValuedHeader(this.parsedResponse.getHeaders(), "Transfer-Encoding"))) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Retrieving additional http response chunks");
                    }
                    this.hasChunkedData = true;
                    this.waitingChunkedData = true;
                }
            }
            if (this.hasChunkedData) {
                while (this.waitingChunkedData) {
                    if (this.contentLength == 0) {
                        decoder.setDelimiter(CRLF_DELIMITER, false);
                        tmp = decoder.decodeFully(buf);
                        if (tmp == null) {
                            return;
                        }
                        String chunkSize = tmp.getString(this.getProxyIoSession().getCharset().newDecoder());
                        int pos = chunkSize.indexOf(59);
                        chunkSize = pos >= 0 ? chunkSize.substring(0, pos) : chunkSize.substring(0, chunkSize.length() - 2);
                        this.contentLength = Integer.decode("0x" + chunkSize);
                        if (this.contentLength > 0) {
                            this.contentLength += 2;
                            decoder.setContentLength(this.contentLength, true);
                        }
                    }
                    if (this.contentLength == 0) {
                        this.waitingChunkedData = false;
                        this.waitingFooters = true;
                        this.entityBodyLimitPosition = this.responseData.position();
                        break;
                    }
                    tmp = decoder.decodeFully(buf);
                    if (tmp == null) {
                        return;
                    }
                    this.contentLength = 0;
                    this.responseData.put(tmp);
                    buf.position(buf.position());
                }
                while (this.waitingFooters) {
                    decoder.setDelimiter(CRLF_DELIMITER, false);
                    tmp = decoder.decodeFully(buf);
                    if (tmp == null) {
                        return;
                    }
                    if (tmp.remaining() == 2) {
                        this.waitingFooters = false;
                        break;
                    }
                    String footer = tmp.getString(this.getProxyIoSession().getCharset().newDecoder());
                    String[] f = footer.split(":\\s?", 2);
                    StringUtilities.addValueToHeader(this.parsedResponse.getHeaders(), f[0], f[1], false);
                    this.responseData.put(tmp);
                    this.responseData.put(CRLF_DELIMITER);
                }
            }
            this.responseData.flip();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("  end of response received:\n" + this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder())));
            }
            this.responseData.position(this.entityBodyStartPosition);
            this.responseData.limit(this.entityBodyLimitPosition);
            this.parsedResponse.setBody(this.responseData.getString(this.getProxyIoSession().getCharset().newDecoder()));
            this.responseData.free();
            this.responseData = null;
            this.handleResponse(this.parsedResponse);
            this.parsedResponse = null;
            this.hasChunkedData = false;
            this.contentLength = -1;
            decoder.setDelimiter(HTTP_DELIMITER, true);
            if (!this.isHandshakeComplete()) {
                this.doHandshake(nextFilter);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ProxyAuthException) {
                throw (ProxyAuthException)ex;
            }
            throw new ProxyAuthException("Handshake failed", ex);
        }
    }

    public abstract void handleResponse(HttpProxyResponse var1) throws ProxyAuthException;

    public void writeRequest(IoFilter.NextFilter nextFilter, HttpProxyRequest request) {
        ProxyIoSession proxyIoSession = this.getProxyIoSession();
        if (proxyIoSession.isReconnectionNeeded()) {
            this.reconnect(nextFilter, request);
        } else {
            this.writeRequest0(nextFilter, request);
        }
    }

    private void writeRequest0(IoFilter.NextFilter nextFilter, HttpProxyRequest request) {
        try {
            String data = request.toHttpString();
            IoBuffer buf = IoBuffer.wrap(data.getBytes(this.getProxyIoSession().getCharsetName()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("   write:\n" + data.replace("\r", "\\r").replace("\n", "\\n\n")));
            }
            this.writeData(nextFilter, buf);
        }
        catch (UnsupportedEncodingException ex) {
            this.closeSession("Unable to send HTTP request: ", ex);
        }
    }

    private void reconnect(final IoFilter.NextFilter nextFilter, final HttpProxyRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Reconnecting to proxy ...");
        }
        final ProxyIoSession proxyIoSession = this.getProxyIoSession();
        proxyIoSession.getConnector().connect((IoSessionInitializer<? extends ConnectFuture>)new IoSessionInitializer<ConnectFuture>(){

            @Override
            public void initializeSession(IoSession session, ConnectFuture future) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Initializing new session: " + session));
                }
                session.setAttribute(ProxyIoSession.PROXY_SESSION, proxyIoSession);
                proxyIoSession.setSession(session);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("  setting up proxyIoSession: " + proxyIoSession));
                }
                future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                    @Override
                    public void operationComplete(ConnectFuture future) {
                        proxyIoSession.setReconnectionNeeded(false);
                        AbstractHttpLogicHandler.this.writeRequest0(nextFilter, request);
                    }
                });
            }
        });
    }

    protected HttpProxyResponse decodeResponse(String response) throws Exception {
        String[] responseLines;
        String[] statusLine;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"  parseResponse()");
        }
        if ((statusLine = (responseLines = response.split("\r\n"))[0].trim().split(" ", 2)).length < 2) {
            throw new Exception("Invalid response status line (" + statusLine + "). Response: " + response);
        }
        if (statusLine[1].matches("^\\d\\d\\d")) {
            throw new Exception("Invalid response code (" + statusLine[1] + "). Response: " + response);
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        int i = 1;
        while (i < responseLines.length) {
            String[] args = responseLines[i].split(":\\s?", 2);
            StringUtilities.addValueToHeader(headers, args[0], args[1], false);
            ++i;
        }
        return new HttpProxyResponse(statusLine[0], statusLine[1], headers);
    }
}

