/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.camera.drive.ice;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import ice_ipcsdk.ICEIPCSDKLibraryFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ICEVideoCameraAction
implements ServiceAction {
    public static final String ACTION_NAME = "/ICEVideoCameraAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();
    private static ConcurrentHashMap<String, CameraWrap> camerasMap = new ConcurrentHashMap();
    private static final Object carmeraManagerLock = new Object();
    private static final Object closeAllCameraLock = new Object();

    static {
        try {
            Method[] mehtods = ICEVideoCameraAction.class.getMethods();
            String service = "service";
            Method[] methodArray = mehtods;
            int n = mehtods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String name = m.getName();
                Class<?>[] cls = m.getParameterTypes();
                if (cls != null && cls.length == 1 && Receiver.class.equals(cls[0]) && !service.equals(name)) {
                    methodsMap.put(name, m);
                }
                ++n2;
            }
            TransportUtil.addTransportCloseListener((TransportCloseListener)new TransportCloseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose() throws Exception {
                    try {
                        Object object = carmeraManagerLock;
                        synchronized (object) {
                            Iterator it = camerasMap.entrySet().iterator();
                            while (it.hasNext()) {
                                try {
                                    try {
                                        CameraWrap rm;
                                        CameraWrap cameraWrap = rm = (CameraWrap)it.next().getValue();
                                        synchronized (cameraWrap) {
                                            if (!rm.released) {
                                                rm.released = true;
                                                ICEVideoCameraAction.closeConnect(rm);
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        it.remove();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    it.remove();
                                    throw throwable;
                                }
                                it.remove();
                            }
                        }
                    }
                    catch (Exception ex) {
                        TransportUtil.getLog().error((Object)("close error!" + ex.getMessage()));
                    }
                }
            });
        }
        catch (Exception ex) {
            TransportUtil.getLog().error((Object)"", (Throwable)ex);
        }
    }

    public void stopPlay(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ICEVideoCameraAction.responseError(request, "Missing parameter: cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        final CameraWrap w0 = wrap;
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ICEVideoCameraAction.stopPlay0(w0);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    try {
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    ICEVideoCameraAction.responseError(request, "Failed to close the camera: " + w0.ip, ex);
                }
            }
        });
    }

    private static void responseError(Receiver request, String message, Throwable e) {
        try {
            String e1;
            String cameraId = request.getHeaderValue("cameraId");
            ResponseSender response = request.createResponse();
            response.setHeader("result", "error");
            if (cameraId != null && cameraId.length() > 0) {
                response.setHeader("cameraId", cameraId);
            }
            if (message != null && message.length() > 0) {
                response.setHeader("msg", message);
            }
            if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
                response.setHeader("msg1", e1);
            }
            response.doResponse(null, null);
        }
        catch (IOException e1) {
            TransportUtil.getLog().error((Object)"", (Throwable)e1);
        }
    }

    public void playVisible(final Receiver request) throws Exception {
        long componentID0;
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ICEVideoCameraAction.responseError(request, "Missing parameter: cameraId", null);
            return;
        }
        final String ip = request.getHeaderValue("ip");
        if (!(ip != null && cameraId.length() != 0 || cameraId != null && cameraId.length() != 0)) {
            ICEVideoCameraAction.responseError(request, "Missing parameter: ip", null);
            return;
        }
        String componentID = request.getHeaderValue("componentID");
        if (componentID == null || componentID.length() == 0) {
            ICEVideoCameraAction.responseError(request, "Missing parameter: componentID", null);
            return;
        }
        try {
            componentID0 = Long.parseLong(componentID);
        }
        catch (Exception ex) {
            ICEVideoCameraAction.responseError(request, "componentID not a integer: " + componentID, null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CameraWrap wrap;
                Object object = carmeraManagerLock;
                synchronized (object) {
                    wrap = (CameraWrap)camerasMap.get(cameraId);
                    if (wrap != null && !ip.equals(wrap.ip)) {
                        camerasMap.remove(wrap.cameraId);
                        CameraWrap cameraWrap = wrap;
                        synchronized (cameraWrap) {
                            wrap.released = true;
                        }
                        ICEVideoCameraAction.closeConnect(wrap);
                        wrap = null;
                    }
                    if (wrap == null) {
                        CameraWrap newWrap = new CameraWrap();
                        newWrap.ip = ip;
                        newWrap.cameraId = cameraId;
                        camerasMap.put(cameraId, newWrap);
                        wrap = newWrap;
                    }
                }
                boolean rsult = ICEVideoCameraAction.this.play(wrap, componentID0);
                if (!rsult) {
                    ICEVideoCameraAction.responseError(request, "Playback failed!" + ip, null);
                    return;
                }
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(rsult));
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void disConnect(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            ICEVideoCameraAction.responseError(request, "DisConnect failed:cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ICEVideoCameraAction.release(cameraId);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(String cameraId) {
        CameraWrap wrap;
        if (cameraId == null) {
            return;
        }
        Object object = carmeraManagerLock;
        synchronized (object) {
            wrap = camerasMap.remove(cameraId);
            if (wrap == null) {
                return;
            }
            CameraWrap cameraWrap = wrap;
            synchronized (cameraWrap) {
                if (wrap.released) {
                    return;
                }
                wrap.released = true;
            }
        }
        ICEVideoCameraAction.closeConnect(wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSameComponentID(String cameraId, Long componentID0) {
        if (cameraId == null || cameraId.length() == 0 || componentID0 == null || componentID0 == 0L) {
            return;
        }
        Object object = closeAllCameraLock;
        synchronized (object) {
            for (CameraWrap w : camerasMap.values()) {
                if (cameraId.equals(w.cameraId)) continue;
                CameraWrap cameraWrap = w;
                synchronized (cameraWrap) {
                    if (!w.released && w.displayHandler != null && w.ComponentId != null && w.ComponentId.longValue() == componentID0.longValue()) {
                        ICEVideoCameraAction.stopPlay0(w);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean play(CameraWrap wrap, Long componentID0) {
        if (wrap == null) return false;
        if (componentID0 == null) {
            return false;
        }
        this.closeSameComponentID(wrap.cameraId, componentID0);
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.released) {
                return false;
            }
            if (wrap.displayHandler != null) {
                if (wrap.ComponentId != null && wrap.ComponentId.longValue() == componentID0.longValue()) {
                    return true;
                }
                ICEVideoCameraAction.stopPlay0(wrap);
            }
            String ip1 = String.valueOf(wrap.ip) + "\u0000";
            ByteBuffer pcIP = ByteBuffer.wrap(ip1.getBytes());
            Pointer handle = ICEIPCSDKLibraryFactory.getSDKLibrary().ICE_IPCSDK_OpenPreview(pcIP, (byte)1, (byte)1, new NativeLong(componentID0.longValue()), null, null);
            if (handle == null) {
                return false;
            }
            wrap.ComponentId = componentID0;
            wrap.displayHandler = handle;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopPlay0(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.displayHandler != null) {
                ICEIPCSDKLibraryFactory.getSDKLibrary().ICE_IPCSDK_Close(wrap.displayHandler);
            }
            wrap.ComponentId = null;
            wrap.displayHandler = null;
        }
    }

    private static void closeConnect(CameraWrap wrap) {
        ICEVideoCameraAction.stopPlay0(wrap);
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            ICEVideoCameraAction.responseError(request, "Missing parameter: op!", null);
            return;
        }
        try {
            Method method = methodsMap.get(op);
            if (method == null) {
                ICEVideoCameraAction.responseError(request, "ivalid parameter op value: " + op, null);
                return;
            }
            method.invoke((Object)this, request);
        }
        catch (Throwable e) {
            TransportUtil.getLog().error((Object)"Abnormal execution!", e);
        }
    }

    private static class CameraWrap {
        String cameraId;
        String ip;
        Pointer displayHandler;
        volatile Long ComponentId;
        volatile boolean released;

        private CameraWrap() {
        }
    }
}

