/*
 * Decompiled with CFR 0.152.
 */
package ice_ipcsdk;

import com.sun.jna.Native;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import ice_ipcsdk.ICEIPCSDKLibrary;
import ice_ipcsdk.StdICallCEIPCSDKLibrary;
import java.io.File;
import java.util.Locale;

public class ICEIPCSDKLibraryFactory
implements TransportCloseListener {
    private static ICEIPCSDKLibrary instance;
    private static final String LIBRAY_NAME = "ice_ipcsdk";
    private static boolean initedSdk;
    private static TransportCloseListener l;

    private ICEIPCSDKLibraryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerTransportCloseListener() {
        if (l != null) return;
        Class<ICEIPCSDKLibraryFactory> clazz = ICEIPCSDKLibraryFactory.class;
        synchronized (ICEIPCSDKLibraryFactory.class) {
            if (l != null) return;
            l = new ICEIPCSDKLibraryFactory();
            TransportUtil.addTransportCloseListener((TransportCloseListener)l);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ICEIPCSDKLibrary loadLibrary(String librayPath) {
        if (librayPath == null || librayPath.length() == 0) {
            librayPath = LIBRAY_NAME;
        }
        if (instance != null) return instance;
        Class<ICEIPCSDKLibrary> clazz = ICEIPCSDKLibrary.class;
        synchronized (ICEIPCSDKLibrary.class) {
            if (instance != null) return instance;
            instance = ICEIPCSDKLibraryFactory.isWindows() ? (StdICallCEIPCSDKLibrary)Native.loadLibrary((String)librayPath, StdICallCEIPCSDKLibrary.class) : (ICEIPCSDKLibrary)Native.loadLibrary((String)librayPath, ICEIPCSDKLibrary.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isWindows() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        return OS_NAME != null && OS_NAME.indexOf("win") != -1;
    }

    public static boolean isWindows32() {
        boolean os32;
        return ICEIPCSDKLibraryFactory.isWindows() && (os32 = System.getProperty("sun.arch.data.model", "32").equals("32"));
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "ice_ipcsdk.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "ice_ipcsdk.so";
        }
        return "ice_ipcsdk.dll";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICEIPCSDKLibrary getSDKLibrary() {
        if (instance == null) {
            File xf = TransportUtil.findHomeDir();
            File nativeDir = "native".equals(xf.getName()) ? xf : new File(xf, "native");
            File ice_ipcsdkDir = new File(nativeDir, LIBRAY_NAME);
            String libPath = null;
            if (ice_ipcsdkDir.exists() && ice_ipcsdkDir.isDirectory()) {
                boolean os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
                File libDir = new File(ice_ipcsdkDir, ICEIPCSDKLibraryFactory.getLibDirName(os32));
                if (!libDir.exists() || !libDir.isDirectory()) {
                    TransportUtil.getLog().warn((Object)("Directory does not exist, lib path cannot be found: " + libDir));
                } else {
                    File file = new File(libDir, ICEIPCSDKLibraryFactory.getLibFileName());
                    if (file.exists() && file.isFile()) {
                        libPath = file.getAbsolutePath();
                    } else {
                        TransportUtil.getLog().warn((Object)("Unable to find dynamic library file :" + file.getAbsolutePath()));
                    }
                }
            }
            ICEIPCSDKLibraryFactory.loadLibrary(libPath);
        }
        if (initedSdk) return instance;
        Class<ICEIPCSDKLibrary> clazz = ICEIPCSDKLibrary.class;
        synchronized (ICEIPCSDKLibrary.class) {
            if (initedSdk) return instance;
            instance.ICE_IPCSDK_Init();
            initedSdk = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isInited() {
        return instance != null && initedSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() throws Exception {
        Class<ICEIPCSDKLibrary> clazz = ICEIPCSDKLibrary.class;
        synchronized (ICEIPCSDKLibrary.class) {
            if (instance != null && initedSdk) {
                initedSdk = false;
                instance.ICE_IPCSDK_Fini();
                instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

