/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.hardware.identifier;

import java.util.ArrayList;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;

public class HardwareIdentifier {
    public Identifier board;
    public Identifier cpu;
    public List<Identifier> disk;
    public List<Identifier> graphicsCard;

    private static void appendXml(Identifier i, StringBuilder xml) {
        xml.append("<name>");
        if (i.name != null && i.name.length() > 0) {
            xml.append("<![CDATA[").append(i.name).append("]]>");
        }
        xml.append("</name>");
        xml.append("<model>");
        if (i.model != null && i.model.length() > 0) {
            xml.append("<![CDATA[").append(i.model).append("]]>");
        }
        xml.append("</model>");
        xml.append("<serial>");
        if (i.serial != null && i.serial.length() > 0) {
            xml.append("<![CDATA[").append(i.serial).append("]]>");
        }
        xml.append("</serial>");
        xml.append("<manufacturer>");
        if (i.manufacturer != null && i.manufacturer.length() > 0) {
            xml.append("<![CDATA[").append(i.manufacturer).append("]]>");
        }
        xml.append("</manufacturer>");
    }

    public static String getHardwareIdentifierXml() {
        Baseboard baseboard;
        CentralProcessor.ProcessorIdentifier idf;
        SystemInfo systeminfo = new SystemInfo();
        HardwareAbstractionLayer layer = systeminfo.getHardware();
        CentralProcessor processor = layer.getProcessor();
        ComputerSystem sts = layer.getComputerSystem();
        List diskList = layer.getDiskStores();
        HardwareIdentifier x = new HardwareIdentifier();
        x.board = new Identifier();
        x.cpu = new Identifier();
        x.disk = new ArrayList<Identifier>();
        x.graphicsCard = new ArrayList<Identifier>();
        if (processor != null && (idf = processor.getProcessorIdentifier()) != null) {
            x.cpu.manufacturer = idf.getVendor();
            x.cpu.model = idf.getModel();
            x.cpu.name = idf.getName();
            x.cpu.serial = idf.getProcessorID();
        }
        if (sts != null && (baseboard = sts.getBaseboard()) != null) {
            x.board.manufacturer = baseboard.getManufacturer();
            x.board.model = baseboard.getModel();
            x.board.serial = baseboard.getSerialNumber();
        }
        if (diskList != null) {
            for (HWDiskStore store : diskList) {
                Identifier i = new Identifier();
                x.disk.add(i);
                i.name = store.getName();
                i.model = store.getModel();
                i.serial = store.getSerial();
            }
        }
        StringBuilder xml = new StringBuilder(256);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xml.append("<hardwareIdentifier>");
        xml.append("<board>");
        HardwareIdentifier.appendXml(x.board, xml);
        xml.append("</board>");
        xml.append("<cpu>");
        HardwareIdentifier.appendXml(x.cpu, xml);
        xml.append("</cpu>");
        for (Identifier s : x.disk) {
            xml.append("<disk>");
            HardwareIdentifier.appendXml(s, xml);
            xml.append("</disk>");
        }
        for (Identifier s : x.graphicsCard) {
            xml.append("<graphicsCard>");
            HardwareIdentifier.appendXml(s, xml);
            xml.append("</graphicsCard>");
        }
        xml.append("</hardwareIdentifier>");
        return xml.toString();
    }

    public static class Identifier {
        public String name;
        public String model;
        public String serial;
        public String manufacturer;
    }
}

