/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.hardware.identifier;

import com.wlyk.hardware.identifier.BytesTool;
import com.wlyk.hardware.identifier.HardwareIdentifier;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;

public class Main {
    private static File startupDir;
    private static boolean isJarStart;

    public static void main(String[] args) throws Exception {
        File jarStartDir = Main.findJarDir();
        if (isJarStart && jarStartDir.exists() && jarStartDir.isDirectory()) {
            final ArrayList<URL> jarURL = new ArrayList<URL>();
            jarStartDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File paramFile) {
                    String fileName;
                    if (paramFile.isFile() && (fileName = paramFile.getName()).endsWith(".jar") && !fileName.equals("HardwareInfo.jar")) {
                        try {
                            jarURL.add(paramFile.toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    return false;
                }
            });
            if (!jarURL.isEmpty()) {
                Main.loadJarOrClass(jarURL);
            }
        }
        if (args == null || args.length < 1) {
            return;
        }
        if ("hardwareIdentifier".equals(args[0])) {
            byte[] b = HardwareIdentifier.getHardwareIdentifierXml().getBytes("UTF-8");
            String x = BytesTool.compressBytes(b);
            System.out.println("hardwareIdentifier=" + x);
        }
    }

    public static void loadJarOrClass(Collection<URL> urlset) throws Exception {
        Method addURLMethod = null;
        addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURLMethod.setAccessible(true);
        for (URL url : urlset) {
            addURLMethod.invoke((Object)ClassLoader.getSystemClassLoader(), url);
        }
    }

    public static File findJarDir() {
        if (startupDir == null) {
            ProtectionDomain pd = Main.class.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            String result = url.toString();
            if (!result.endsWith(".jar")) {
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.endsWith("/bin")) {
                    result = result.substring(0, result.lastIndexOf(47));
                }
            } else {
                isJarStart = true;
            }
            if ((result = result.substring(0, result.lastIndexOf(47))) == null) {
                throw new RuntimeException("Can not find the app boot path.");
            }
            if (Character.isUpperCase(result.charAt(0))) {
                char[] chars = result.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                result = new String(chars);
            }
            try {
                startupDir = new File(new URI(result));
            }
            catch (URISyntaxException e) {
                new RuntimeException(e);
            }
        }
        return startupDir;
    }
}

