/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carmera.drive.qy;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.wovoe.carmera.drive.qy.sdk.NetSDKLibrary;
import com.wovoe.carmera.drive.qy.sdk.NetSDKLibraryFactory;
import com.wovoe.carmera.drive.qy.sdk.StdCallNetSDKLibrary;
import com.wovoe.carmera.drive.qy.sdk.T_BlackWhiteList;
import com.wovoe.carmera.drive.qy.sdk.T_ControlGate;
import com.wovoe.carmera.drive.qy.sdk.T_DCImageSnap;
import com.wovoe.carmera.drive.qy.sdk.T_DCTimeSetup;
import com.wovoe.carmera.drive.qy.sdk.T_GetBlackWhiteList;
import com.wovoe.carmera.drive.qy.sdk.T_ImageUserInfo;
import com.wovoe.carmera.drive.qy.sdk.T_PicInfo;
import com.wovoe.carmera.drive.qy.sdk.T_RS485Data;
import com.wovoe.carmera.drive.qy.sdk.T_RS485Setup;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.Client;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class QYCameraAction
implements ServiceAction {
    public static final String ACTION_NAME = "/QYCameraAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();
    private static File localPicDir;
    private static ConcurrentHashMap<String, CameraWrap> camerasMap;
    private static final Object carmeraManagerLock;
    private static ScheduledFuture<?> shcf;
    private static Callback reportMsgCallback;
    private static Callback plateCallback;

    static {
        camerasMap = new ConcurrentHashMap();
        carmeraManagerLock = new Object();
        shcf = null;
        try {
            if (NetSDKLibraryFactory.isWindows32()) {
                reportMsgCallback = new ReportMsgCallbackStdCallback();
                plateCallback = new PlateCallbackStdCallback();
            } else {
                reportMsgCallback = new ReportMsgCallback();
                plateCallback = new PlateCallback();
            }
            Method[] mehtods = QYCameraAction.class.getMethods();
            String service = "service";
            Method[] methodArray = mehtods;
            int n = mehtods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String name = m.getName();
                Class<?>[] cls = m.getParameterTypes();
                if (cls != null && cls.length == 1 && Receiver.class.equals(cls[0]) && !service.equals(name)) {
                    methodsMap.put(name, m);
                }
                ++n2;
            }
            TransportUtil.addTransportCloseListener((TransportCloseListener)new TransportCloseListener(){

                public void onClose() throws Exception {
                    try {
                        if (shcf != null) {
                            shcf.cancel(true);
                            shcf = null;
                        }
                        for (CameraWrap wrap : camerasMap.values()) {
                            try {
                                QYCameraAction.release(wrap);
                            }
                            catch (Exception ex) {
                                TransportUtil.getLog().error((Object)("\u5173\u95ed\u5931\u8d25!" + ex.getMessage()));
                            }
                        }
                    }
                    catch (Exception ex) {
                        TransportUtil.getLog().error((Object)("\u5173\u95ed\u5931\u8d25!" + ex.getMessage()));
                    }
                }
            });
            shcf = TransportUtil.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){
                AtomicBoolean running = new AtomicBoolean(false);

                @Override
                public void run() {
                    if (camerasMap.isEmpty()) {
                        return;
                    }
                    if (this.running.compareAndSet(false, true)) {
                        try {
                            TransportUtil.getWorkThreadPool().submit(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        try {
                                            StringBuilder sbr = new StringBuilder(256);
                                            StringBuilder dipatchs = new StringBuilder(128);
                                            Iterator iterator = camerasMap.values().iterator();
                                            while (iterator.hasNext()) {
                                                boolean ok;
                                                CameraWrap wrap;
                                                CameraWrap cameraWrap = wrap = (CameraWrap)iterator.next();
                                                synchronized (cameraWrap) {
                                                    int result;
                                                    if (wrap.released) {
                                                        continue;
                                                    }
                                                    ok = wrap.connect ? (result = NetSDKLibraryFactory.getSDKLibrary().Net_QueryConnState(wrap.tHandle)) == 0 : false;
                                                    wrap.workNormal = ok;
                                                }
                                                if (sbr.length() > 0) {
                                                    sbr.append(',');
                                                }
                                                if (dipatchs.length() > 0) {
                                                    sbr.append(',');
                                                }
                                                dipatchs.append(wrap.cameraId);
                                                sbr.append(wrap.cameraId).append(':').append(ok ? "1" : "0");
                                            }
                                            sbr.length();
                                        }
                                        catch (Throwable ex) {
                                            TransportUtil.getLog().error((Object)ex.getMessage());
                                            running.set(false);
                                        }
                                    }
                                    finally {
                                        running.set(false);
                                    }
                                }
                            });
                        }
                        catch (Throwable ex) {
                            this.running.set(false);
                            TransportUtil.getLog().error((Object)ex.getMessage());
                        }
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            TransportUtil.getLog().error((Object)"\u52a0\u8f7d\u9a71\u52a8\u5f02\u5e38", (Throwable)ex);
        }
    }

    public static File getPlateSaveDir(String cameraId) {
        SimpleDateFormat df;
        File dateDir;
        File eqFile;
        if (localPicDir == null) {
            File xf = TransportUtil.findHomeDir();
            File nativeDir = "native".equals(xf.getName()) ? xf : new File(xf, "native");
            File localPic = new File(nativeDir.getParentFile(), "local/pic");
            if (!localPic.exists()) {
                localPic.mkdirs();
            }
            localPicDir = localPic;
        }
        if (!(eqFile = new File(dateDir = new File(localPicDir, (df = new SimpleDateFormat("yyyyMMdd")).format(new Date())), cameraId)).exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    private static void responseError(Receiver request, String message, Throwable e) {
        QYCameraAction.responseError(request, message, null, e);
    }

    private static void responseError(Receiver request, String message, String tipMsg, Throwable e) {
        try {
            String e1;
            String cameraId = request.getHeaderValue("cameraId");
            ResponseSender response = request.createResponse();
            response.setHeader("result", "error");
            if (cameraId != null && cameraId.length() > 0) {
                response.setHeader("cameraId", cameraId);
            }
            if (message != null && message.length() > 0) {
                response.setHeader("msg", message);
            }
            if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
                response.setHeader("msg1", e1);
            }
            if (tipMsg != null && tipMsg.length() > 0) {
                response.setHeader("tipMsg", tipMsg);
            }
            response.doResponse(null, null);
        }
        catch (IOException e1) {
            TransportUtil.getLog().error((Object)"", (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setReportMsgCallback(CameraWrap wrap) {
        if (!wrap.reportMsgCallbackSetOk) {
            CameraWrap cameraWrap = wrap;
            synchronized (cameraWrap) {
                block8: {
                    if (!wrap.released) break block8;
                    return false;
                }
                if (!wrap.reportMsgCallbackSetOk) {
                    int result = NetSDKLibraryFactory.getSDKLibrary().Net_RegReportMessEx(wrap.tHandle, reportMsgCallback, null);
                    if (result == 0) {
                        wrap.reportMsgCallbackSetOk = true;
                    } else {
                        TransportUtil.getLog().error((Object)("\u8bbe\u7f6e\u76f8\u673a" + wrap.ip + "\u6d88\u606f\u4e0a\u62a5\u56de\u8c03\u5931\u8d25! \u9519\u8bef\u4ee3\u7801\uff1a" + result));
                    }
                }
            }
        }
        return wrap.reportMsgCallbackSetOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(CameraWrap wrap) {
        if (wrap == null) {
            return;
        }
        Object object = carmeraManagerLock;
        synchronized (object) {
            CameraWrap cameraWrap = wrap;
            synchronized (cameraWrap) {
                if (wrap.released) {
                    return;
                }
            }
            CameraWrap wrap1 = camerasMap.remove(wrap.cameraId);
            CameraWrap cameraWrap2 = wrap;
            synchronized (cameraWrap2) {
                wrap.released = true;
            }
            QYCameraAction.unRegsterFromSdk(wrap);
            if (wrap1 != null && wrap1 != wrap) {
                cameraWrap2 = wrap1;
                synchronized (cameraWrap2) {
                    if (wrap1.released) {
                        return;
                    }
                    wrap1.released = true;
                }
                QYCameraAction.unRegsterFromSdk(wrap1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean disconectCamera(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block4: {
                if (!wrap.connect) break block4;
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_DisConnCamera(wrap.tHandle);
                wrap.connect = false;
                if (result == 0) break block4;
                TransportUtil.getLog().error((Object)("\u65ad\u5f00\u76f8\u673a" + wrap.ip + "\u8fde\u63a5\u5931\u8d25! \u9519\u8bef\u4ee3\u7801\uff1a" + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stopPlay(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block4: {
                if (!wrap.playing) break block4;
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_StopVideo(wrap.tHandle);
                wrap.componentId = null;
                wrap.playing = false;
                if (result == 0) break block4;
                TransportUtil.getLog().error((Object)("\u505c\u6b62\u64ad\u653e\u76f8\u673a" + wrap.ip + "\u5931\u8d25! \u9519\u8bef\u4ee3\u7801\uff1a" + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean play(CameraWrap wrap, Long componentID0) {
        if (wrap == null) return false;
        if (componentID0 == null) {
            return false;
        }
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            int result;
            if (wrap.released) {
                return false;
            }
            if (wrap.playing) {
                if (wrap.componentId != null && wrap.componentId.longValue() == componentID0.longValue()) {
                    return true;
                }
                QYCameraAction.stopPlay(wrap);
            }
            if ((result = NetSDKLibraryFactory.getSDKLibrary().Net_StartVideo(wrap.tHandle, 0, componentID0.intValue())) != 0) {
                TransportUtil.getLog().error((Object)("\u64ad\u653e\u76f8\u673a" + wrap.ip + "\u89c6\u9891\u5931\u8d25\uff01 " + result));
                return false;
            }
            wrap.componentId = componentID0;
            wrap.playing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unRegsterFromSdk(CameraWrap wrap) {
        QYCameraAction.stopPlay(wrap);
        QYCameraAction.disconectCamera(wrap);
        Object object = carmeraManagerLock;
        synchronized (object) {
            block4: {
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_DelCamera(wrap.tHandle);
                if (result == 0) break block4;
                TransportUtil.getLog().error((Object)("\u79fb\u9664\u76f8\u673a" + wrap.ip + "\u5e76\u91ca\u653e\u76f8\u673a\u8d44\u6e90\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean triggerRegPlate0(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block6: {
                block5: {
                    if (!wrap.released) break block5;
                    return false;
                }
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_ImageSnap(wrap.tHandle, new T_DCImageSnap.ByReference());
                if (result == 0) break block6;
                TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u8f6f\u89e6\u53d1\u8bc6\u522b\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean controlGate0(CameraWrap wrap, int controlState, int ioPort) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block6: {
                block5: {
                    if (!wrap.released) break block5;
                    return false;
                }
                T_ControlGate.ByReference ptControlGate = new T_ControlGate.ByReference();
                ptControlGate.ucState = (byte)controlState;
                ptControlGate.ucReserved[0] = (byte)ioPort;
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_GateSetup(wrap.tHandle, ptControlGate);
                if (result == 0) break block6;
                String name1 = controlState == 1 ? "\u5f00\u95f8" : (controlState == 2 ? "\u5173\u95f8" : (controlState == 3 ? "\u505c\u95f8" : ""));
                TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u63a7\u5236\u9053\u95f8" + name1 + "\uff0c\u5728IO\u63a7\u5236\u7aef\u53e3\uff1a" + ioPort + "\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean checkIsPlateEncrypt(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            Memory ucEncId;
            block5: {
                ucEncId = new Memory(1L);
                Memory szSignatrue = new Memory(100L);
                IntByReference ptLen = new IntByReference();
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_QuerySignatrue(wrap.tHandle, (Pointer)ucEncId, (Pointer)szSignatrue, ptLen);
                if (result == 0) break block5;
                TransportUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a\u662f\u5426\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801" + result));
                return null;
            }
            byte[] dn = new byte[1];
            ucEncId.read(0L, dn, 0, dn.length);
            if (dn[0] == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synSystemTime(CameraWrap wrap) {
        Calendar cl = Calendar.getInstance();
        int year = cl.get(1);
        int month = cl.get(2) + 1;
        int day = cl.get(5);
        int hour = cl.get(11);
        int minus = cl.get(12);
        int sec = cl.get(13);
        T_DCTimeSetup.ByReference ptTimeSetup = new T_DCTimeSetup.ByReference();
        ptTimeSetup.usYear = (short)year;
        ptTimeSetup.ucMonth = (byte)month;
        ptTimeSetup.ucDay = (byte)day;
        ptTimeSetup.ucHour = (byte)hour;
        ptTimeSetup.ucMinute = (byte)minus;
        ptTimeSetup.ucSecond = (byte)sec;
        ptTimeSetup.ucDayFmt = 0;
        ptTimeSetup.ucTimeFmt = 0;
        ptTimeSetup.ucTimeZone = (byte)20;
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block4: {
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_TimeSetup(wrap.tHandle, ptTimeSetup);
                if (result == 0) break block4;
                TransportUtil.getLog().error((Object)("\u540c\u6b65\u76f8\u673a" + wrap.ip + "\u65f6\u95f4\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connect(Receiver request, StringBuilder tipErrorMessage) {
        boolean firstConnect;
        CameraWrap wrap;
        block52: {
            CameraWrap cameraWrap;
            String pwds;
            String ip;
            block51: {
                int port;
                block50: {
                    wrap = null;
                    String cameraId = request.getHeaderValue("cameraId");
                    ip = request.getHeaderValue("ip");
                    String _port = request.getHeaderValue("port");
                    pwds = request.getHeaderValue("pwds");
                    port = 0;
                    try {
                        if (_port != null && _port.length() > 0) {
                            port = Integer.parseInt(_port);
                        }
                        if (port > 65535) {
                            TransportUtil.getLog().warn((Object)("\u65e0\u6548\u7684\u76f8\u673a" + ip + "\u7aef\u53e3\u53f7: " + _port + ", \u8fd9\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7aef\u53e3!"));
                            port = 0;
                        }
                    }
                    catch (Exception e) {
                        TransportUtil.getLog().warn((Object)("\u65e0\u6548\u7684\u76f8\u673a" + ip + "\u7aef\u53e3\u53f7: " + _port + ", \u8fd9\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7aef\u53e3!"));
                        port = 0;
                    }
                    boolean needReciveRegPlate = true;
                    String reciveRegPlate = request.getHeaderValue("reciveRegPlate");
                    if (reciveRegPlate != null && "false".equals(reciveRegPlate)) {
                        needReciveRegPlate = false;
                    }
                    if (cameraId == null || ip == null) {
                        return false;
                    }
                    Object object = carmeraManagerLock;
                    synchronized (object) {
                        int tHandle;
                        CameraWrap newWrap;
                        block44: {
                            wrap = camerasMap.get(cameraId);
                            if (wrap != null) {
                                if (wrap.receiveRegPlate != needReciveRegPlate) {
                                    wrap.receiveRegPlate = needReciveRegPlate;
                                }
                                if (!ip.equals(wrap.ip)) {
                                    QYCameraAction.release(wrap);
                                    wrap = null;
                                }
                            }
                            if (wrap != null) break block50;
                            newWrap = new CameraWrap();
                            newWrap.ip = ip;
                            newWrap.cameraId = cameraId;
                            newWrap.receiveRegPlate = needReciveRegPlate;
                            String ip1 = String.valueOf(ip) + "\u0000";
                            ByteBuffer ptIp = ByteBuffer.wrap(ip1.getBytes());
                            tHandle = NetSDKLibraryFactory.getSDKLibrary().Net_AddCamera(ptIp);
                            if (tHandle >= 0) break block44;
                            TransportUtil.getLog().warn((Object)("\u52a0\u8f7d\u76f8\u673a\uff1a" + ip + " \u5931\u8d25\uff01"));
                            return false;
                        }
                        newWrap.tHandle = tHandle;
                        CameraWrap wrap1 = camerasMap.put(cameraId, newWrap);
                        if (wrap1 != null && wrap1.tHandle != newWrap.tHandle) {
                            QYCameraAction.unRegsterFromSdk(wrap1);
                        }
                        wrap = newWrap;
                    }
                }
                firstConnect = false;
                if (wrap.connect) break block51;
                cameraWrap = wrap;
                synchronized (cameraWrap) {
                    block46: {
                        block45: {
                            if (!wrap.released) break block45;
                            TransportUtil.getLog().warn((Object)("\u76f8\u673a" + ip + "\u5df2\u88ab\u6ce8\u518c\u7ba1\u7406\u5668\u79fb\u9664\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01"));
                            return false;
                        }
                        if (wrap.connect) break block51;
                        int result = NetSDKLibraryFactory.getSDKLibrary().Net_ConnCamera(wrap.tHandle, (short)port, (short)6);
                        if (result == 0) break block46;
                        String pi = port > 0 ? ":" + String.valueOf(port) : "";
                        TransportUtil.getLog().warn((Object)("\u8fde\u63a5\u76f8\u673a\uff1a" + ip + pi + " \u5931\u8d25\uff01"));
                        return false;
                    }
                    wrap.connect = true;
                    wrap.workNormal = true;
                    firstConnect = true;
                }
            }
            if (!wrap.setpwdOk) {
                cameraWrap = wrap;
                synchronized (cameraWrap) {
                    block47: {
                        if (!wrap.released) break block47;
                        TransportUtil.getLog().warn((Object)("\u76f8\u673a" + ip + "\u5df2\u88ab\u6ce8\u518c\u7ba1\u7406\u5668\u79fb\u9664\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01"));
                        return false;
                    }
                    if (!wrap.setpwdOk) {
                        Boolean encrypt = QYCameraAction.checkIsPlateEncrypt(wrap);
                        if (encrypt == null) {
                            tipErrorMessage.append("\u68c0\u6d4b\u76f8\u673a\uff1a" + wrap.ip + " \u662f\u5426\u52a0\u5bc6\u5931\u8d25\uff01\u7a0d\u540e\u91cd\u8bd5...");
                        } else if (encrypt.booleanValue()) {
                            if (pwds == null || pwds.length() == 0) {
                                tipErrorMessage.append("\u672a\u77e5\u79d8\u94a5");
                            } else {
                                String[] pwdss = pwds.split(",");
                                String nesPwd = null;
                                String[] stringArray = pwdss;
                                int n = pwdss.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String pwd = stringArray[n2];
                                    if (pwd != null && pwd.length() != 0) {
                                        String pwd1 = String.valueOf(pwd) + "\u0000";
                                        int result = NetSDKLibraryFactory.getSDKLibrary().Net_EnableEnc(wrap.tHandle, (byte)1, ByteBuffer.wrap(pwd1.getBytes()));
                                        if (result == 0) {
                                            nesPwd = pwd;
                                            break;
                                        }
                                    }
                                    ++n2;
                                }
                                if (nesPwd == null || nesPwd.length() == 0) {
                                    tipErrorMessage.append("\u9519\u8bef\uff1a\u76f8\u673a " + wrap.ip + " \u5df2\u88ab\u52a0\u5bc6\uff0c\u79d8\u94a5\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u8bc6\u522b\u8f66\u724c\uff01");
                                } else {
                                    String pwd1 = String.valueOf(nesPwd) + "\u0000";
                                    int result = NetSDKLibraryFactory.getSDKLibrary().Net_SetDecPwd(wrap.tHandle, ByteBuffer.wrap(pwd1.getBytes()));
                                    if (result != 0) {
                                        tipErrorMessage.append("\u8bbe\u7f6e\u76f8\u673a " + wrap.ip + "\u79d8\u94a5\u9519\u8bef\uff0c\u7a0d\u540e\u91cd\u8bd5...");
                                    } else {
                                        wrap.setpwdOk = true;
                                    }
                                }
                            }
                        } else {
                            wrap.setpwdOk = true;
                        }
                    }
                }
            }
            QYCameraAction.setReportMsgCallback(wrap);
            if (wrap.plateCallbackSetOk) break block52;
            cameraWrap = wrap;
            synchronized (cameraWrap) {
                block49: {
                    block48: {
                        if (!wrap.released) break block48;
                        TransportUtil.getLog().warn((Object)("\u76f8\u673a" + ip + "\u5df2\u88ab\u6ce8\u518c\u7ba1\u7406\u5668\u79fb\u9664\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01"));
                        return false;
                    }
                    if (wrap.plateCallbackSetOk) break block52;
                    int result = NetSDKLibraryFactory.getSDKLibrary().Net_RegImageRecvEx(wrap.tHandle, plateCallback, null);
                    if (result == 0) break block49;
                    TransportUtil.getLog().warn((Object)("\u76f8\u673a" + ip + "\u6ce8\u518c\u8f66\u724c\u56de\u8c03\u5931\u8d25\uff01"));
                    wrap.workNormal = false;
                    return false;
                }
                wrap.plateCallbackSetOk = true;
            }
        }
        if (firstConnect) {
            QYCameraAction.synSystemTime(wrap);
        }
        return true;
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11op!", null);
            return;
        }
        try {
            Method method = methodsMap.get(op);
            if (method == null) {
                QYCameraAction.responseError(request, "\u65e0\u6548op: " + op, null);
                return;
            }
            method.invoke((Object)this, request);
        }
        catch (Throwable e) {
            TransportUtil.getLog().error((Object)"\u6267\u884c\u52a8\u4f5c\u5f02\u5e38!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setUatConfigIfCharged(CameraWrap wrap, int uatIndex, int baudRate, int dataBits, int parity, int stopBits, int flowControl, int screen_mode, int uacType) {
        if (uatIndex != 0 && uatIndex != 1) {
            return -2;
        }
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            int rx;
            T_RS485Setup.ByReference param;
            block8: {
                block7: {
                    if (!wrap.released) break block7;
                    return -1;
                }
                param = new T_RS485Setup.ByReference();
                param.ucIndex = (byte)uatIndex;
                rx = NetSDKLibraryFactory.getSDKLibrary().Net_QueryRS485Setup(wrap.tHandle, param);
                if (rx == 0) break block8;
                return -3;
            }
            T_RS485Setup.ByReference newUart = new T_RS485Setup.ByReference();
            newUart.ucIndex = (byte)uatIndex;
            newUart.ucFunction = (byte)screen_mode;
            newUart.ucBaudRate = (byte)baudRate;
            newUart.ucDataBits = (byte)dataBits;
            newUart.ucStopBits = (byte)stopBits;
            newUart.ucCheckOut = (byte)parity;
            newUart.ucType = (byte)uacType;
            if (!newUart.equals1(param)) {
                rx = NetSDKLibraryFactory.getSDKLibrary().Net_RS485Setup(wrap.tHandle, newUart);
                return rx;
            }
            return 0;
        }
    }

    private static String getString(byte[] xb) {
        if (xb == null) {
            return null;
        }
        if (xb.length == 0) {
            return "";
        }
        int i = 0;
        byte end = 0;
        int z = 0;
        while (z < xb.length) {
            if (xb[z] == end) {
                i = z;
                break;
            }
            ++z;
        }
        if (i == 0) {
            return "";
        }
        try {
            return new String(xb, 0, i, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            return new String(xb, 0, i);
        }
    }

    private static String getVehicleColorString(int ucVehicleColor) {
        String cl;
        switch (ucVehicleColor) {
            case 0: {
                cl = "\u84dd\u8272";
                break;
            }
            case 1: {
                cl = "\u9ec4\u8272";
                break;
            }
            case 2: {
                cl = "\u767d\u8272";
                break;
            }
            case 3: {
                cl = "\u9ed1\u8272";
                break;
            }
            case 5: {
                cl = "\u7eff\u8272";
                break;
            }
            case 6: {
                cl = "\u7eff\u8272";
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    private static String getCarLogoString(int ucVehicleBrand) {
        String cl;
        switch (ucVehicleBrand) {
            case 1: {
                cl = "\u4e30\u7530";
                break;
            }
            case 2: {
                cl = "\u5927\u4f17";
                break;
            }
            case 3: {
                cl = "\u672c\u7530";
                break;
            }
            case 4: {
                cl = "\u6807\u81f4";
                break;
            }
            case 5: {
                cl = "\u73b0\u4ee3";
                break;
            }
            case 6: {
                cl = "\u522b\u514b";
                break;
            }
            case 7: {
                cl = "\u5965\u8fea";
                break;
            }
            case 8: {
                cl = "\u8d77\u4e9a";
                break;
            }
            case 9: {
                cl = "\u5409\u666e";
                break;
            }
            case 10: {
                cl = "\u798f\u7279";
                break;
            }
            case 11: {
                cl = "\u5954\u9a70";
                break;
            }
            case 12: {
                cl = "\u5b9d\u9a6c";
                break;
            }
            case 13: {
                cl = "\u9a6c\u81ea\u8fbe";
                break;
            }
            case 14: {
                cl = "\u94c3\u6728";
                break;
            }
            case 15: {
                cl = "\u96ea\u94c1\u9f99";
                break;
            }
            case 16: {
                cl = "\u5c3c\u6851";
                break;
            }
            case 17: {
                cl = "\u4e09\u83f1";
                break;
            }
            case 18: {
                cl = "\u96f7\u514b\u8428\u65af";
                break;
            }
            case 19: {
                cl = "\u96ea\u4f5b\u5170";
                break;
            }
            case 20: {
                cl = "\u6c83\u5c14\u6c83";
                break;
            }
            case 21: {
                cl = "\u83f2\u4e9a\u7279";
                break;
            }
            case 22: {
                cl = "\u6bd4\u4e9a\u8fea";
                break;
            }
            case 23: {
                cl = "\u5947\u745e";
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    private static String getPlateTypeString(int plateTypeCode) {
        String cl;
        switch (plateTypeCode) {
            case 1: {
                cl = "\u84dd\u724c\u8f66";
                break;
            }
            case 2: {
                cl = "\u9ed1\u724c\u8f66";
                break;
            }
            case 3: {
                cl = "\u5355\u5c42\u9ec4\u724c";
                break;
            }
            case 4: {
                cl = "\u53cc\u5c42\u9ec4\u724c";
                break;
            }
            case 5: {
                cl = "\u8b66\u8f66";
                break;
            }
            case 6: {
                cl = "\u6b66\u8b66\u8f66\u8f86";
                break;
            }
            case 7: {
                cl = "\u53cc\u5c42\u6b66\u8b66";
                break;
            }
            case 8: {
                cl = "\u519b\u8f66";
                break;
            }
            case 9: {
                cl = "\u53cc\u5c42\u519b\u8f66";
                break;
            }
            case 10: {
                cl = "\u4e2a\u6027\u5316\u8f66";
                break;
            }
            case 11: {
                cl = "\u65b0\u80fd\u6e90\u5c0f\u8f66";
                break;
            }
            case 12: {
                cl = "\u65b0\u80fd\u6e90\u5927\u8f66";
                break;
            }
            case 13: {
                cl = "\u4f7f\u9986\u8f66";
                break;
            }
            case 14: {
                cl = "\u9886\u4e8b\u9986\u8f66";
                break;
            }
            case 15: {
                cl = "\u6c11\u822a\u8f66\u724c";
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    private static int handleFGetImageCbExCallBack(int tHandle, int uiImageId, T_ImageUserInfo ptImageInfo, T_PicInfo ptPicInfo, Pointer pUser) {
        String carTypeName;
        String dirName;
        int dir;
        String plate;
        CameraWrap wrap = null;
        for (CameraWrap w : camerasMap.values()) {
            if (w.tHandle != tHandle) continue;
            wrap = w;
            break;
        }
        if (wrap == null) {
            TransportUtil.getLog().warn((Object)("\u672a\u627e\u5230\uff1atHandle\uff1a" + tHandle + " \u5bf9\u5e94\u7684\u5bf9\u8c61\uff0c\u4e22\u5f03\u8f66\u724c"));
            return 0;
        }
        final String cameraId = wrap.cameraId;
        if (ptImageInfo.ucSnapType == 1) {
            String key = "QYCameraAction.CaptureCallback." + cameraId;
            Object obj = TransportUtil.getTimeoutObjectPool().removeObject((Object)key);
            if (obj != null && obj instanceof CaptureCallback) {
                final CaptureCallback capcallback = (CaptureCallback)obj;
                byte[] bigPicData0 = null;
                if (ptPicInfo != null && ptPicInfo.ptPanoramaPicBuff != null && ptPicInfo.uiPanoramaPicLen > 0) {
                    bigPicData0 = new byte[ptPicInfo.uiPanoramaPicLen];
                    ptPicInfo.ptPanoramaPicBuff.read(0L, bigPicData0, 0, ptPicInfo.uiPanoramaPicLen);
                }
                final byte[] bigPicData = bigPicData0;
                TransportUtil.getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        if (bigPicData == null || bigPicData.length == 0) {
                            capcallback.onCallback(false);
                            return;
                        }
                        try {
                            File saveF = new File(capcallback.savePath);
                            if (!saveF.getParentFile().exists()) {
                                saveF.getParentFile().mkdirs();
                            }
                            try (FileOutputStream out = new FileOutputStream(saveF);){
                                out.write(bigPicData, 0, bigPicData.length);
                            }
                        }
                        catch (Exception ex) {
                            TransportUtil.getLog().warn((Object)("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25\uff01\u5728\u8def\u5f84\uff1a" + capcallback.savePath + ", \u539f\u56e0\uff1a" + ex.getMessage()));
                            capcallback.onCallback(false);
                            return;
                        }
                        capcallback.onCallback(true);
                    }
                });
                return 0;
            }
        }
        if ((plate = QYCameraAction.getString(ptImageInfo.szLprResult)) == null || plate.length() == 0) {
            return 0;
        }
        if (!wrap.receiveRegPlate) {
            return 0;
        }
        if ("\u52a0\u5bc6".equals(plate)) {
            wrap.setpwdOk = false;
            TransportUtil.getLog().error((Object)("\u76f8\u673a :" + wrap.ip + ",\u8f66\u724c\u5df2\u88ab\u52a0\u5bc6\uff0c\u6b63\u5728\u91cd\u65b0\u5c1d\u8bd5\u8bbe\u7f6e\u79d8\u94a5\u6765\u89e3\u51b3\u6b64\u95ee\u9898\uff01"));
            return 0;
        }
        byte[] bigPicData0 = null;
        if (ptPicInfo != null && ptPicInfo.ptPanoramaPicBuff != null && ptPicInfo.uiPanoramaPicLen > 0) {
            bigPicData0 = new byte[ptPicInfo.uiPanoramaPicLen];
            ptPicInfo.ptPanoramaPicBuff.read(0L, bigPicData0, 0, ptPicInfo.uiPanoramaPicLen);
        }
        byte[] smallPicData0 = null;
        if (ptPicInfo != null && ptPicInfo.ptVehiclePicBuff != null && ptPicInfo.uiVehiclePicLen > 0) {
            smallPicData0 = new byte[ptPicInfo.uiVehiclePicLen];
            ptPicInfo.ptVehiclePicBuff.read(0L, smallPicData0, 0, ptPicInfo.uiVehiclePicLen);
        }
        final byte[] bigPicData = bigPicData0;
        final byte[] smallPicData = smallPicData0;
        String color = ptImageInfo.ucPlateColor == 0 ? "\u84dd" : (ptImageInfo.ucPlateColor == 1 ? "\u9ec4" : (ptImageInfo.ucPlateColor == 2 ? "\u767d" : (ptImageInfo.ucPlateColor == 3 ? "\u9ed1" : (ptImageInfo.ucPlateColor == 5 || ptImageInfo.ucPlateColor == 6 ? "\u7eff" : ""))));
        final String plateColor = color;
        final String vehicleColor = QYCameraAction.getVehicleColorString(ptImageInfo.ucVehicleColor & 0xFF);
        final String carLogo = QYCameraAction.getCarLogoString(ptImageInfo.ucVehicleBrand & 0xFF);
        int dir0 = ptImageInfo.ucDirection & 0xFF;
        if (dir0 == 1) {
            dir = 0;
            dirName = "\u8f66\u5934\u65b9\u5411";
        } else if (dir0 == 2) {
            dir = 1;
            dirName = "\u8f66\u5c3e\u65b9\u5411";
        } else {
            dir = 3;
            dirName = null;
        }
        final float plateConfidence = ptImageInfo.ucScore & 0xFF;
        final int plateType = ptImageInfo.ucLprType & 0xFF;
        final String plateTypeName = QYCameraAction.getPlateTypeString(plateType);
        final int carType = ptImageInfo.ucVehicleSize & 0xFF;
        switch (carType) {
            case 1: {
                carTypeName = "\u5927\u578b\u8f66";
                break;
            }
            case 2: {
                carTypeName = "\u4e2d\u578b\u8f66";
                break;
            }
            case 3: {
                carTypeName = "\u5c0f\u578b\u8f66";
                break;
            }
            case 4: {
                carTypeName = "\u6469\u6258\u8f66";
                break;
            }
            case 5: {
                carTypeName = "\u884c\u4eba";
                break;
            }
            default: {
                carTypeName = null;
            }
        }
        final short carSpeed = ptImageInfo.usSpeed;
        boolean plateJudge = false;
        final String plateJudgeName = null;
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                byte[] b1;
                try {
                    b1 = plate.getBytes("GBK");
                }
                catch (Exception ex) {
                    b1 = plate.getBytes();
                }
                String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                long xatime = System.currentTimeMillis();
                Random r = new Random();
                int ranx = Math.abs(r.nextInt());
                String bigFilePath = null;
                if (bigPicData != null && bigPicData.length > 0) {
                    String fileName = new StringBuilder(128).append("plate_").append(plateHex).append('_').append(xatime).append('_').append(ranx).append(".jpg").toString();
                    try {
                        File saveF = new File(QYCameraAction.getPlateSaveDir(cameraId), fileName);
                        try (FileOutputStream out = new FileOutputStream(saveF);){
                            out.write(bigPicData, 0, bigPicData.length);
                        }
                        bigFilePath = saveF.getAbsolutePath();
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u5927\u56fe\u5931\u8d25!", (Throwable)e);
                    }
                }
                String smallFilePath = null;
                if (smallPicData != null && smallPicData.length > 0) {
                    String fileName = new StringBuilder(128).append("plateSmall_").append(plateHex).append('_').append(xatime).append('_').append(ranx).append(".jpg").toString();
                    try {
                        File saveF = new File(QYCameraAction.getPlateSaveDir(cameraId), fileName);
                        try (FileOutputStream out = new FileOutputStream(saveF);){
                            out.write(smallPicData, 0, smallPicData.length);
                        }
                        smallFilePath = saveF.getAbsolutePath();
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u5c0f\u56fe\u5931\u8d25!", (Throwable)e);
                    }
                }
                Enumeration clients = TransportUtil.getTCPClientManager().getClients();
                LinkedList<Client> xlist = new LinkedList<Client>();
                while (clients.hasMoreElements()) {
                    xlist.add((Client)clients.nextElement());
                }
                if (!xlist.isEmpty()) {
                    for (Client cl : xlist) {
                        if (!cl.isConnected()) continue;
                        RequestSender sender = cl.createClientRequest();
                        sender.setRequestActionName("/NativeTrasportPushAction");
                        sender.setHeader("op", "plateCaptureData");
                        if (plate != null) {
                            sender.setHeader("plateNumber", plate);
                        }
                        if (smallFilePath != null) {
                            sender.setHeader("smallSavePath", smallFilePath);
                        }
                        if (plateColor != null) {
                            sender.setHeader("plateColor", plateColor);
                        }
                        if (vehicleColor != null && vehicleColor.length() > 0) {
                            sender.setHeader("vehicleColor", vehicleColor);
                        }
                        if (bigFilePath != null) {
                            sender.setHeader("savePath", bigFilePath);
                        }
                        if (carLogo != null && carLogo.length() > 0) {
                            sender.setHeader("carLogo", carLogo);
                        }
                        sender.setHeader("dir", String.valueOf(dir));
                        if (dirName != null && dirName.length() > 0) {
                            sender.setHeader("dirName", dirName);
                        }
                        sender.setHeader("carType", String.valueOf(carType));
                        if (carTypeName != null && carTypeName.length() > 0) {
                            sender.setHeader("carTypeName", carTypeName);
                        }
                        sender.setHeader("plateConfidence", String.valueOf(plateConfidence));
                        sender.setHeader("plateType", String.valueOf(plateType));
                        if (plateTypeName != null && plateTypeName.length() > 0) {
                            sender.setHeader("plateTypeName", plateTypeName);
                        }
                        sender.setHeader("carSpeed", String.valueOf(carSpeed));
                        sender.setHeader("plateJudge", String.valueOf(0));
                        if (plateJudgeName != null && plateJudgeName.length() > 0) {
                            sender.setHeader("plateJudgeName", plateJudgeName);
                        }
                        sender.setHeader("cameraId", cameraId);
                        sender.setHeader("dipatch", cameraId);
                        sender.setHeader("timeMills", String.valueOf(System.currentTimeMillis()));
                        sender.setNeedEncrypt(false);
                        try {
                            sender.doRequest(null, null);
                        }
                        catch (IOException e) {
                            TransportUtil.getLog().warn((Object)"\u53d1\u9001\u8f66\u724c\u6570\u636e\u5931\u8d25!", (Throwable)e);
                        }
                    }
                }
            }
        });
        return 0;
    }

    private static int handleFGetReportCBExCallback(int tHandle, byte ucType, Pointer ptMessage, Pointer pUserData) {
        if (ucType == 6) {
            T_RS485Data rs485Data = new T_RS485Data(ptMessage);
            rs485Data.read();
            if (rs485Data.dataLen > 0) {
                CameraWrap wrap = null;
                for (CameraWrap w : camerasMap.values()) {
                    if (w.tHandle != tHandle) continue;
                    wrap = w;
                    break;
                }
                if (wrap == null) {
                    return 0;
                }
                final byte[] sendData = new byte[rs485Data.dataLen];
                System.arraycopy(rs485Data.data, 0, sendData, 0, rs485Data.dataLen);
                final int uatIndex = rs485Data.rs485Id & 0xFF;
                final String cameraId = wrap.cameraId;
                TransportUtil.getWorkThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        Enumeration clients = TransportUtil.getTCPClientManager().getClients();
                        LinkedList<Client> xlist = new LinkedList<Client>();
                        while (clients.hasMoreElements()) {
                            xlist.add((Client)clients.nextElement());
                        }
                        if (!xlist.isEmpty() && !xlist.isEmpty()) {
                            for (Client cl : xlist) {
                                if (!cl.isConnected()) continue;
                                RequestSender sender = cl.createClientRequest();
                                sender.setRequestActionName("/NativeTrasportPushAction");
                                sender.setHeader("op", "rs485resData");
                                sender.setHeader("cameraId", cameraId);
                                sender.setHeader("dipatch", cameraId);
                                sender.setHeader("uatIndex", String.valueOf(uatIndex));
                                sender.setHeader("timeMills", String.valueOf(System.currentTimeMillis()));
                                sender.setSendData(sendData);
                                sender.setNeedEncrypt(false);
                                try {
                                    sender.doRequest(null, null);
                                }
                                catch (IOException e) {
                                    TransportUtil.getLog().warn((Object)"\u53d1\u9001\u4e32\u53e3\u6570\u636e\u5931\u8d25!", (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        }
        return 0;
    }

    public void connectIfNotConnect(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        String ip = request.getHeaderValue("ip");
        if (!(ip != null && cameraId.length() != 0 || cameraId != null && cameraId.length() != 0)) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:ip", null);
            return;
        }
        final String componentID = request.getHeaderValue("componentID");
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap != null) {
            boolean needReciveRegPlate = true;
            String reciveRegPlate = request.getHeaderValue("reciveRegPlate");
            if (reciveRegPlate != null && "false".equals(reciveRegPlate)) {
                needReciveRegPlate = false;
            }
            if (needReciveRegPlate != wrap.receiveRegPlate) {
                wrap.receiveRegPlate = needReciveRegPlate;
            }
            if (ip.equals(wrap.ip) && wrap.connect && wrap.plateCallbackSetOk && wrap.setpwdOk && wrap.reportMsgCallbackSetOk) {
                Long x1 = wrap.componentId;
                if (componentID == null && x1 == null || componentID != null && x1 != null && componentID.equals(x1.toString())) {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(wrap.workNormal));
                    try {
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                    return;
                }
            }
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean c;
                try {
                    StringBuilder tipMsg = new StringBuilder();
                    c = QYCameraAction.connect(request, tipMsg);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(c));
                    if (tipMsg.length() > 0) {
                        response.setHeader("tipMsg", tipMsg.toString());
                    }
                    try {
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    QYCameraAction.responseError(request, "\u64cd\u4f5c\u5931\u8d25!" + request.getHeaderValue("ip"), ex);
                    return;
                }
                if (c && componentID != null && componentID.length() > 0) {
                    try {
                        long componentID0 = Long.parseLong(componentID);
                        CameraWrap wrap = (CameraWrap)camerasMap.get(cameraId);
                        if (wrap != null) {
                            QYCameraAction.this.play(wrap, componentID0);
                        }
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
            }
        });
    }

    public void playVisible(final Receiver request) throws Exception {
        long componentID0;
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final String ip = request.getHeaderValue("ip");
        if (!(ip != null && cameraId.length() != 0 || cameraId != null && cameraId.length() != 0)) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:ip", null);
            return;
        }
        String componentID = request.getHeaderValue("componentID");
        if (componentID == null || componentID.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:componentID", null);
            return;
        }
        try {
            componentID0 = Long.parseLong(componentID);
        }
        catch (Exception ex) {
            QYCameraAction.responseError(request, "componentID\u4e0d\u662f\u6574\u6570:" + componentID, null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                StringBuilder tipMsg = new StringBuilder();
                if (!QYCameraAction.connect(request, tipMsg)) {
                    QYCameraAction.responseError(request, "\u64ad\u653e\u5931\u8d25!" + ip, tipMsg.toString(), null);
                    return;
                }
                CameraWrap wrap = (CameraWrap)camerasMap.get(cameraId);
                boolean rsult = QYCameraAction.this.play(wrap, componentID0);
                if (!rsult) {
                    QYCameraAction.responseError(request, "\u64ad\u653e\u5931\u8d25!" + ip, null);
                    return;
                }
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(rsult));
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void stopPlay(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        final CameraWrap w0 = wrap;
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QYCameraAction.stopPlay(w0);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    try {
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    QYCameraAction.responseError(request, "\u5173\u95ed\u6444\u50cf\u673a\u5931\u8d25:" + w0.ip, ex);
                }
            }
        });
    }

    public void disConnect(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                QYCameraAction.release(wrap);
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void controlGate(final Receiver request) throws Exception {
        int ioPort;
        int controlState;
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        String _controlState = request.getHeaderValue("controlState");
        try {
            if (_controlState == null || _controlState.length() == 0) {
                QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570controlState!", null);
                return;
            }
            controlState = Integer.parseInt(_controlState);
            if (controlState < 1 || controlState > 3) {
                QYCameraAction.responseError(request, "controlState\u5fc5\u987b\u5728[1,3]\u4e4b\u95f4", null);
                return;
            }
        }
        catch (Exception ex) {
            QYCameraAction.responseError(request, "controlState\u5fc5\u987b\u662f\u6570\u5b57", null);
            return;
        }
        String _ioPort = request.getHeaderValue("ioPort");
        try {
            if (_ioPort == null || _ioPort.length() == 0) {
                QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570ioPort!", null);
                return;
            }
            ioPort = Integer.parseInt(_ioPort);
            if (ioPort < 0 || controlState > 4) {
                QYCameraAction.responseError(request, "ioPort\u5fc5\u987b\u5728[0,4]\u4e4b\u95f4", null);
                return;
            }
        }
        catch (Exception ex) {
            QYCameraAction.responseError(request, "ioPort\u5fc5\u987b\u662f\u6570\u5b57", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean ok = QYCameraAction.controlGate0(wrap, controlState, ioPort);
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(ok));
                    if (!ok) {
                        String name1 = controlState == 1 ? "\u5f00\u95f8" : (controlState == 2 ? "\u5173\u95f8" : (controlState == 3 ? "\u505c\u95f8" : ""));
                        String msg = "\u76f8\u673a" + wrap.ip + "\u63a7\u5236\u9053\u95f8" + name1 + "\uff0c\u5728IO\u63a7\u5236\u7aef\u53e3\uff1a" + ioPort + "\u5931\u8d25";
                        response.setHeader("msg", msg);
                    }
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void importWhiteList(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        if (request.getData() == null || request.getDataLength() == 0) {
            QYCameraAction.responseError(request, "\u9700\u8981\u5bfc\u5165\u7684\u767d\u540d\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a!", null);
            return;
        }
        String filepaths = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
        String[] filepathx = filepaths.split(",");
        final ArrayList<File> fileList = new ArrayList<File>(filepathx.length);
        String[] stringArray = filepathx;
        int n = filepathx.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.length() != 0) {
                File file = new File(path);
                if (file.exists() && file.isFile()) {
                    fileList.add(file);
                } else {
                    QYCameraAction.responseError(request, "\u6587\u4ef6: " + path + "\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u6587\u4ef6 ", null);
                    return;
                }
            }
            ++n2;
        }
        if (fileList.isEmpty()) {
            QYCameraAction.responseError(request, "\u9700\u8981\u5bfc\u5165\u7684\u767d\u540d\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Map<String, Integer> result = QYCameraAction.importWhiteList0(wrap, fileList);
                    StringBuilder sbr = new StringBuilder(256);
                    for (Map.Entry<String, Integer> v : result.entrySet()) {
                        if (sbr.length() > 0) {
                            sbr.append(';');
                        }
                        sbr.append(v.getKey()).append(',').append(v.getValue());
                    }
                    byte[] data = sbr.toString().getBytes("UTF-8");
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    response.setSendData(data);
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> importWhiteList0(CameraWrap wrap, List<File> importFiles) {
        LinkedHashMap<String, Integer> resultMap = new LinkedHashMap<String, Integer>();
        if (importFiles == null || importFiles.isEmpty()) {
            return resultMap;
        }
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.released) {
                for (File f : importFiles) {
                    resultMap.put(f.getAbsolutePath(), -1);
                }
                return resultMap;
            }
            int result = 0;
            int i = 0;
            for (File file : importFiles) {
                String path = file.getAbsolutePath();
                if (result == 0) {
                    byte[] ba;
                    try {
                        ba = path.getBytes("GB2312");
                    }
                    catch (UnsupportedEncodingException e) {
                        ba = path.getBytes();
                    }
                    T_BlackWhiteList.ByReference ptBalckWhiteList = new T_BlackWhiteList.ByReference();
                    ptBalckWhiteList.LprMode = 1;
                    ptBalckWhiteList.LprCode = 1;
                    ptBalckWhiteList.Lprnew = (byte)(i != 0 ? 1 : 0);
                    System.arraycopy(ba, 0, ptBalckWhiteList.aucLplPath, 0, ba.length);
                    result = NetSDKLibraryFactory.getSDKLibrary().Net_BlackWhiteListSend(wrap.tHandle, ptBalckWhiteList);
                    if (result != 0) {
                        TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u5bfc\u5165\u767d\u540d\u5355\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result + ", \u6587\u4ef6\u8def\u5f84: " + path));
                    }
                }
                resultMap.put(path, result);
                ++i;
            }
        }
        return resultMap;
    }

    public void clearBlackWhiteList(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean ok = QYCameraAction.clearBlackWhiteList0(wrap);
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(ok));
                    if (!ok) {
                        String msg = "\u76f8\u673a" + wrap.ip + " \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25\uff01";
                        response.setHeader("msg", msg);
                    }
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clearBlackWhiteList0(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block6: {
                block5: {
                    if (!wrap.released) break block5;
                    return false;
                }
                int result = NetSDKLibraryFactory.getSDKLibrary().Net_DeleteAllBlackWhiteList(wrap.tHandle);
                if (result == 0) break block6;
                TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    public void exportWhiteListCsv(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        final String csvFilePath = request.getHeaderValue("csvFilePath");
        if (csvFilePath == null || csvFilePath.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u5bfc\u51fa\u767d\u540d\u5355csv\u6587\u4ef6\u8def\u5f84", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean ok = QYCameraAction.exportWhiteListCsv0(wrap, csvFilePath);
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(ok));
                    if (!ok) {
                        String msg = "\u76f8\u673a" + wrap.ip + " \u5bfc\u51fa\u767d\u540d\u5355\u5931\u8d25\uff01";
                        response.setHeader("msg", msg);
                    }
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportWhiteListCsv0(CameraWrap wrap, String csvfilePath) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            block11: {
                int result;
                block10: {
                    byte[] ba1;
                    block9: {
                        if (!wrap.released) break block9;
                        return false;
                    }
                    try {
                        ba1 = csvfilePath.getBytes("GB2312");
                    }
                    catch (UnsupportedEncodingException e) {
                        ba1 = csvfilePath.getBytes();
                    }
                    T_GetBlackWhiteList.ByReference ptGetBalckWhiteList = new T_GetBlackWhiteList.ByReference();
                    ptGetBalckWhiteList.LprMode = 1;
                    ptGetBalckWhiteList.LprCode = 1;
                    System.arraycopy(ba1, 0, ptGetBalckWhiteList.aucLplPath, 0, ba1.length);
                    result = NetSDKLibraryFactory.getSDKLibrary().Net_GetBlackWhiteList(wrap.tHandle, ptGetBalckWhiteList);
                    if (result != 0 && result != 1254) break block10;
                    File file = new File(csvfilePath);
                    if (!file.exists()) {
                        TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u8fd4\u56de\u4ee3\u7801\uff1a " + result + ", \u4f46\u662f\u6587\u4ef6\u4e0d\u5b58\u5728"));
                        return false;
                    }
                    break block11;
                }
                TransportUtil.getLog().error((Object)("\u76f8\u673a" + wrap.ip + "\u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u9519\u8bef,\u9519\u8bef\u4ee3\u7801\uff1a " + result));
                return false;
            }
        }
        return true;
    }

    public void triggerRegPlate(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                boolean ok = QYCameraAction.triggerRegPlate0(wrap);
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(ok));
                    if (!ok) {
                        String msg = "\u76f8\u673a" + wrap.ip + " \u8f6f\u89e6\u53d1\u8bc6\u522b\u5931\u8d25\uff01";
                        response.setHeader("msg", msg);
                    }
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void capture(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final String savePath = request.getHeaderValue("savePath");
        if (savePath == null || savePath.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:savePath", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || wrap.released || !wrap.connect) {
            QYCameraAction.responseError(request, "\u76f8\u673a\u672a\u8fde\u63a5!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int result;
                String key;
                CameraWrap cameraWrap = wrap;
                synchronized (cameraWrap) {
                    if (wrap.released) {
                        QYCameraAction.responseError(request, "\u76f8\u673a" + wrap.ip + "\u672a\u8fde\u63a5!", null);
                        return;
                    }
                    CaptureCallback capt = new CaptureCallback(request, savePath, wrap.cameraId);
                    key = "QYCameraAction.CaptureCallback." + cameraId;
                    TransportUtil.getTimeoutObjectPool().addObject((Object)key, (Object)capt, (TimeoutObjectPool.TimeoutCallback)capt, 6000L, TimeUnit.MILLISECONDS);
                    T_DCImageSnap.ByReference tn = new T_DCImageSnap.ByReference();
                    result = NetSDKLibraryFactory.getSDKLibrary().Net_ImageSnap(wrap.tHandle, tn);
                }
                if (result != 0) {
                    TransportUtil.getTimeoutObjectPool().removeObject((Object)key);
                    QYCameraAction.responseError(request, "\u76f8\u673a" + wrap.ip + "\u6293\u62cd\u56fe\u7247\u5931\u8d25,\u9519\u8bef\u4ee3\u7801\uff1a " + result, null);
                    return;
                }
            }
        });
    }

    public void setSerialIfNeed(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u8bbe\u5907\u672a\u6253\u5f00!", null);
            return;
        }
        String uatIndex = request.getHeaderValue("uatIndex");
        if (uatIndex == null || uatIndex.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:uatIndex", null);
            return;
        }
        String baudRate = request.getHeaderValue("baudRate");
        if (baudRate == null || baudRate.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:baudRate", null);
            return;
        }
        String dataBits = request.getHeaderValue("dataBits");
        if (dataBits == null || dataBits.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:dataBits", null);
            return;
        }
        String parity = request.getHeaderValue("parity");
        if (parity == null || parity.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:parity", null);
            return;
        }
        String stopBits = request.getHeaderValue("stopBits");
        if (stopBits == null || stopBits.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:stopBits", null);
            return;
        }
        String flowControl = request.getHeaderValue("flowControl");
        if (flowControl == null || flowControl.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:uatIndex", null);
            return;
        }
        String screen_mode = request.getHeaderValue("screen_mode");
        if (screen_mode == null || screen_mode.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:screen_mode", null);
            return;
        }
        String _uacType = request.getHeaderValue("uacType");
        if (_uacType == null || _uacType.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:uacType", null);
            return;
        }
        final int uatIndex0 = Integer.parseInt(uatIndex);
        final int baudRate0 = Integer.parseInt(baudRate);
        final int dataBits0 = Integer.parseInt(dataBits);
        final int parity0 = Integer.parseInt(parity);
        final int stopBits0 = Integer.parseInt(stopBits);
        final int flowControl0 = Integer.parseInt(flowControl);
        final int screen_mode0 = Integer.parseInt(screen_mode);
        final int uacType0 = Integer.parseInt(_uacType);
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                if (wrap.released) {
                    QYCameraAction.responseError(request, "\u8bbe\u5907\u672a\u6253\u5f00!" + wrap.ip, null);
                    return;
                }
                int rx = QYCameraAction.setUatConfigIfCharged(wrap, uatIndex0, baudRate0, dataBits0, parity0, stopBits0, flowControl0, screen_mode0, uacType0);
                if (rx != 0) {
                    if (rx == -1) {
                        QYCameraAction.responseError(request, "\u8bbe\u5907\u672a\u6253\u5f00!", null);
                    } else if (rx == -2) {
                        QYCameraAction.responseError(request, "uatIndex\u5fc5\u987b\u4e3a0\u548c1!", null);
                    } else if (rx == -3) {
                        QYCameraAction.responseError(request, "\u83b7\u53d6\u4e32\u53e3\u914d\u7f6e\u5931\u8d25!", null);
                    } else {
                        QYCameraAction.responseError(request, "\u8bbe\u7f6e\u4e32\u53e3\u5931\u8d25!\u9519\u8bef\u4ee3\u7801\uff1a" + rx, null);
                    }
                    return;
                }
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void sendRS485Data(final Receiver request) throws Exception {
        int uatIndex;
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:cameraId", null);
            return;
        }
        String _uatIndex = request.getHeaderValue("uatIndex");
        if (_uatIndex == null || _uatIndex.length() == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u53c2\u6570:uatIndex", null);
            return;
        }
        try {
            uatIndex = Integer.parseInt(_uatIndex);
            if (uatIndex != 0 && uatIndex != 1) {
                QYCameraAction.responseError(request, "\u53c2\u6570:uatIndex\u5fc5\u987b\u662f0\u6216\u80051", null);
                return;
            }
        }
        catch (Exception ex) {
            QYCameraAction.responseError(request, "\u53c2\u6570:uatIndex\u5fc5\u987b\u662f\u6570\u5b57", null);
            return;
        }
        byte[] sendData0 = request.getData();
        if (sendData0 == null) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u8981\u53d1\u9001\u7684\u6570\u636e", null);
            return;
        }
        final int dataLen = request.getDataLength();
        int dataoffset = request.getDataOffset();
        if (dataLen == 0) {
            QYCameraAction.responseError(request, "\u7f3a\u5c11\u8981\u53d1\u9001\u7684\u6570\u636e\uff0c\u6570\u636e\u957f\u5ea6\u4e3a0", null);
            return;
        }
        final ByteBuffer buffer = ByteBuffer.allocate(dataLen);
        buffer.put(sendData0, dataoffset, dataLen);
        buffer.flip();
        final CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null || !wrap.connect) {
            QYCameraAction.responseError(request, "\u8bbe\u5907\u672a\u6253\u5f00!", null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CameraWrap cameraWrap = wrap;
                synchronized (cameraWrap) {
                    if (wrap.released || !wrap.connect) {
                        QYCameraAction.responseError(request, "\u8bbe\u5907\u672a\u6253\u5f00!" + wrap.ip, null);
                        return;
                    }
                    int rx = NetSDKLibraryFactory.getSDKLibrary().Net_TransRS485DataEx(wrap.tHandle, uatIndex, buffer, (short)dataLen);
                    if (rx != 0) {
                        try {
                            ResponseSender response = request.createResponse();
                            response.setHeader("result", "error");
                            response.setHeader("invokeerror", "1");
                            response.setHeader("cameraId", cameraId);
                            response.setHeader("uatIndex", String.valueOf(uatIndex));
                            response.setHeader("msg", "\u53d1\u9001rs458\u6570\u636e\u5931\u8d25!");
                            response.doResponse(null, null);
                        }
                        catch (IOException e1) {
                            TransportUtil.getLog().error((Object)"", (Throwable)e1);
                        }
                        return;
                    }
                    try {
                        ResponseSender response = request.createResponse();
                        response.setHeader("cameraId", cameraId);
                        response.setHeader("result", "true");
                        response.setHeader("uatIndex", String.valueOf(uatIndex));
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                }
            }
        });
    }

    private static class CameraWrap {
        String cameraId;
        String ip;
        int tHandle;
        volatile boolean playing;
        volatile Long componentId;
        volatile boolean connect;
        volatile boolean plateCallbackSetOk;
        volatile boolean reportMsgCallbackSetOk;
        volatile boolean released;
        volatile boolean receiveRegPlate = true;
        volatile boolean workNormal;
        volatile boolean setpwdOk;

        private CameraWrap() {
        }
    }

    private static class CaptureCallback
    implements TimeoutObjectPool.TimeoutCallback {
        private Receiver request;
        private String savePath;
        private String cameraId;

        CaptureCallback(Receiver request, String savePath, String cameraId) {
            this.request = request;
            this.savePath = savePath;
            this.cameraId = cameraId;
        }

        public void onCallback(boolean success) {
            try {
                ResponseSender response = this.request.createResponse();
                response.setHeader("cameraId", this.cameraId);
                response.setHeader("result", String.valueOf(success));
                if (!success) {
                    String msg = "\u6293\u62cd\u56fe\u7247\u5931\u8d25\uff01";
                    response.setHeader("msg", msg);
                }
                response.doResponse(null, null);
            }
            catch (IOException e) {
                TransportUtil.getLog().error((Object)"", (Throwable)e);
            }
        }

        public void onTimeout(Object arg0, Object arg1) throws Exception {
            QYCameraAction.responseError(this.request, "\u6293\u62cd\u56fe\u50cf\u8d85\u65f6!", null);
        }
    }

    public static class PlateCallback
    implements NetSDKLibrary.FGetImageCbExCallback {
        @Override
        public int apply(int tHandle, int uiImageId, T_ImageUserInfo ptImageInfo, T_PicInfo ptPicInfo, Pointer pUser) {
            return QYCameraAction.handleFGetImageCbExCallBack(tHandle, uiImageId, ptImageInfo, ptPicInfo, pUser);
        }
    }

    public static class PlateCallbackStdCallback
    implements StdCallNetSDKLibrary.FGetImageCbExStdCallback {
        @Override
        public int apply(int tHandle, int uiImageId, T_ImageUserInfo ptImageInfo, T_PicInfo ptPicInfo, Pointer pUser) {
            return QYCameraAction.handleFGetImageCbExCallBack(tHandle, uiImageId, ptImageInfo, ptPicInfo, pUser);
        }
    }

    public static class ReportMsgCallback
    implements NetSDKLibrary.FGetReportCBExCallback {
        @Override
        public int apply(int tHandle, byte ucType, Pointer ptMessage, Pointer pUserData) {
            return QYCameraAction.handleFGetReportCBExCallback(tHandle, ucType, ptMessage, pUserData);
        }
    }

    public static class ReportMsgCallbackStdCallback
    implements StdCallNetSDKLibrary.FGetReportCBExStdCallback {
        @Override
        public int apply(int tHandle, byte ucType, Pointer ptMessage, Pointer pUserData) {
            return QYCameraAction.handleFGetReportCBExCallback(tHandle, ucType, ptMessage, pUserData);
        }
    }
}

