/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool;

import com.wlyk.carpark.dbtool.MessageCallback;
import com.wlyk.carpark.dbtool.jdbc.JdbcStructTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DBTool {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Connection getConnection(Properties dbConfig) {
        try {
            if (dbConfig == null) {
                return null;
            }
            String host = dbConfig.getProperty("host");
            if (host == null) return null;
            if (host.length() == 0) {
                return null;
            }
            String port = dbConfig.getProperty("port");
            if (port == null) return null;
            if (port.length() == 0) {
                return null;
            }
            String dbname = dbConfig.getProperty("dbname");
            if (dbname == null) return null;
            if (dbname.length() == 0) {
                return null;
            }
            String user = dbConfig.getProperty("user");
            if (user == null) return null;
            if (user.length() == 0) {
                return null;
            }
            String pwd = dbConfig.getProperty("pwd");
            if (pwd == null) {
                return null;
            }
            String url = "jdbc:postgresql://" + host + ":" + port + "/" + dbname;
            return DriverManager.getConnection(url, user, pwd);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getFinishPersent(long total, long finish) {
        if (total <= 0L) {
            total = 1L;
        }
        double x = (double)finish / (double)total;
        int z = (int)(x *= 100.0);
        if (z >= 100) {
            z = 99;
        }
        return String.valueOf(z) + "%";
    }

    public static void doImport(final Properties dbConfig, File file, int threadCount, final MessageCallback messageCallback) throws Throwable {
        if (threadCount < 1) {
            threadCount = 1;
        }
        if (threadCount > 20) {
            threadCount = 20;
        }
        final long totalBytes = file.length();
        final AtomicLong exeBytes = new AtomicLong(0L);
        final LinkedBlockingQueue<String> sqlQueue = new LinkedBlockingQueue<String>();
        final CountDownLatch latch = new CountDownLatch(threadCount);
        final AtomicBoolean allTaskF = new AtomicBoolean(false);
        final Throwable[] exceptions = new Throwable[1];
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        Connection conn1 = DBTool.getConnection(dbConfig);
        try {
            String line;
            int i = 0;
            while (i < threadCount) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Connection conn2 = null;
                        try {
                            try {
                                while (exceptions[0] == null) {
                                    String sql = (String)sqlQueue.poll(1L, TimeUnit.SECONDS);
                                    if (sql == null) {
                                        if (!allTaskF.get() || sqlQueue.peek() != null) continue;
                                        break;
                                    }
                                    if (conn2 == null && (conn2 = DBTool.getConnection(dbConfig)) == null) {
                                        throw new Exception("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93");
                                    }
                                    try {
                                        Statement statement = conn2.createStatement();
                                        statement.execute(sql);
                                        statement.close();
                                    }
                                    catch (Exception ex) {
                                        System.out.println("\u6267\u884c\u811a\u672c: " + sql + "\u5f02\u5e38\uff01");
                                        if (sql.indexOf("ck_carpark_regplate_record") != -1) {
                                            System.out.println("\u5ffd\u7565\u6b64\u8bb0\u5f55\u6570\u636e");
                                        }
                                        throw ex;
                                    }
                                    exeBytes.addAndGet(sql.getBytes("UTF-8").length);
                                    messageCallback.printMessage("\u6b63\u5728\u5bfc\u5165\u6570\u636e... \u5df2\u5b8c\u6210\uff1a" + DBTool.getFinishPersent(totalBytes, exeBytes.get()));
                                }
                            }
                            catch (Throwable ex) {
                                exceptions[0] = ex;
                                ex.printStackTrace();
                                latch.countDown();
                                if (conn2 != null) {
                                    try {
                                        conn2.close();
                                    }
                                    catch (SQLException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        finally {
                            latch.countDown();
                            if (conn2 != null) {
                                try {
                                    conn2.close();
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }).start();
                ++i;
            }
            StringBuilder sqlBufer = null;
            while ((line = reader.readLine()) != null) {
                if (exceptions[0] != null) {
                    throw exceptions[0];
                }
                if ((line = line.trim()).length() == 0) continue;
                if (sqlBufer == null) {
                    sqlBufer = new StringBuilder(256);
                }
                sqlBufer.append(line);
                if (!line.endsWith(";")) continue;
                String sql = sqlBufer.toString();
                if (sql.startsWith("DELETE ")) {
                    Statement statement = conn1.createStatement();
                    statement.execute(sql);
                    statement.close();
                    exeBytes.addAndGet(sql.getBytes("UTF-8").length);
                    messageCallback.printMessage("\u6b63\u5728\u5bfc\u5165\u6570\u636e... \u5df2\u5b8c\u6210\uff1a" + DBTool.getFinishPersent(totalBytes, exeBytes.get()));
                } else if (sql.startsWith("INSERT ")) {
                    sqlQueue.offer(sql);
                } else {
                    System.out.println("\u4e22\u5f03SQL:" + sql);
                    exeBytes.addAndGet(sql.getBytes("UTF-8").length);
                }
                sqlBufer = null;
            }
        }
        finally {
            try {
                if (conn1 != null) {
                    conn1.close();
                }
            }
            finally {
                reader.close();
            }
        }
        allTaskF.set(true);
        while (!latch.await(500L, TimeUnit.MILLISECONDS)) {
            if (exceptions[0] == null) continue;
            throw exceptions[0];
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        Calendar cl = Calendar.getInstance();
        cl.set(2019, 0, 1, 0, 0, 0);
        int seq_prefix = Math.abs((int)((System.currentTimeMillis() - cl.getTimeInMillis()) / 1000L));
        try (Connection connection = DBTool.getConnection(dbConfig);){
            String sql = "UPDATE ck_carpark_local_config SET seq_prefix=" + seq_prefix + " WHERE id=1";
            Statement statement = connection.createStatement();
            statement.executeUpdate(sql);
            statement.close();
        }
        messageCallback.printMessage("\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165! \u5df2\u5b8c\u6210\uff1a100%");
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> doExport(Properties dbConfig, File file, int threadCount, MessageCallback messageCallback, JdbcStructTool jdbcStructTool, boolean ignoreError) throws Throwable {
        if (threadCount < 1) {
            threadCount = 1;
        }
        if (threadCount > 20) {
            threadCount = 20;
        }
        if (jdbcStructTool == null) {
            messageCallback.printMessage("\u6b63\u5728\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f...");
            jdbcStructTool = new JdbcStructTool();
            connection = DBTool.getConnection(dbConfig);
            try {
                jdbcStructTool.loadAllTableStructs(connection, dbConfig.getProperty("dbname"));
            }
            finally {
                connection.close();
            }
        }
        errList = new CopyOnWriteArrayList<String>();
        wirter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            block35: {
                block34: {
                    ck_ddl_sync_log = "ck_ddl_sync_log";
                    ck_cloud_ddl_sync_log = "ck_cloud_ddl_sync_log";
                    ck_watchfield_ddl_sync_log = "ck_watchfield_ddl_sync_log";
                    ck_ddl_sync_table_log = "ck_ddl_sync_table_log";
                    ck_carpark_ddl_sync_table_log = "ck_carpark_ddl_sync_table_log";
                    ck_dbsql_version = "ck_dbsql_version";
                    ck_jdbc_test = "ck_jdbc_test";
                    tableNameQueue = new ConcurrentLinkedQueue<String>();
                    idStr = "id";
                    has_ck_watchfield_ddl_sync_log = false;
                    has_ck_cloud_ddl_sync_log = false;
                    has_ck_ddl_sync_log = false;
                    has_ck_ddl_sync_table_log = false;
                    has_ck_carpark_ddl_sync_table_log = false;
                    taskSize = 0;
                    totalTaskCount = 0;
                    for (Map.Entry<String, String[]> entry : jdbcStructTool.getTableColumnNamesMap().entrySet()) {
                        if (ck_watchfield_ddl_sync_log.equals(entry.getKey())) {
                            has_ck_watchfield_ddl_sync_log = true;
                            ++totalTaskCount;
                            continue;
                        }
                        if (ck_cloud_ddl_sync_log.equals(entry.getKey())) {
                            has_ck_cloud_ddl_sync_log = true;
                            ++totalTaskCount;
                            continue;
                        }
                        if (ck_ddl_sync_log.equals(entry.getKey())) {
                            has_ck_ddl_sync_log = true;
                            ++totalTaskCount;
                            continue;
                        }
                        if (ck_ddl_sync_table_log.equals(entry.getKey())) {
                            has_ck_ddl_sync_table_log = true;
                            ++totalTaskCount;
                            continue;
                        }
                        if (ck_carpark_ddl_sync_table_log.equals(entry.getKey())) {
                            has_ck_carpark_ddl_sync_table_log = true;
                            ++totalTaskCount;
                            continue;
                        }
                        if (ck_dbsql_version.equals(entry.getKey()) || ck_jdbc_test.equals(entry.getKey()) || !DBTool.contains(entry.getValue(), "id")) continue;
                        tableNameQueue.offer(entry.getKey());
                        wirter.println("DELETE FROM " + entry.getKey() + ";");
                        ++taskSize;
                        ++totalTaskCount;
                    }
                    latch = new CountDownLatch(taskSize);
                    finishCount = new AtomicInteger(0);
                    wirteQueue = new LinkedBlockingQueue<E>();
                    exceptions = new Throwable[1];
                    if (taskSize <= 0) break block34;
                    threadCount0 = taskSize < threadCount ? taskSize : threadCount;
                    i = 0;
                    while (i < threadCount0) {
                        task = new ExportTask();
                        task.ignoreError = ignoreError;
                        task.latch = latch;
                        task.finishCount = finishCount;
                        task.totalTaskCount = totalTaskCount;
                        task.wirteQueue = wirteQueue;
                        task.messageCallback = messageCallback;
                        task.exceptions = exceptions;
                        task.tableNameQueue = tableNameQueue;
                        task.dbConfig = dbConfig;
                        task.jdbcStructTool = jdbcStructTool;
                        task.ignoreErrorList = errList;
                        task.start();
                        ++i;
                    }
                    finish = false;
                    if (true) ** GOTO lbl95
                    block8: while (true) {
                        if (queObj instanceof String) {
                            wirter.println((String)queObj);
                        }
                        if (exceptions[0] != null) {
                            throw exceptions[0];
                        }
                        if (latch.getCount() > 0L) ** GOTO lbl-1000
                        finish = true;
                        while (!finish) lbl-1000:
                        // 2 sources

                        {
                            if ((queObj = wirteQueue.poll(5L, TimeUnit.SECONDS)) != null) continue block8;
                        }
                        break;
                    }
                }
                if (has_ck_ddl_sync_log) {
                    wirter.println("DELETE FROM ck_ddl_sync_log;");
                    tableNameQueue.offer("ck_ddl_sync_log");
                }
                if (has_ck_cloud_ddl_sync_log) {
                    wirter.println("DELETE FROM ck_cloud_ddl_sync_log;");
                    tableNameQueue.offer("ck_cloud_ddl_sync_log");
                }
                if (has_ck_watchfield_ddl_sync_log) {
                    wirter.println("DELETE FROM ck_watchfield_ddl_sync_log;");
                    tableNameQueue.offer("ck_watchfield_ddl_sync_log");
                }
                if (has_ck_ddl_sync_table_log) {
                    wirter.println("DELETE FROM ck_ddl_sync_table_log;");
                    tableNameQueue.offer("ck_ddl_sync_table_log");
                }
                if (has_ck_carpark_ddl_sync_table_log) {
                    wirter.println("DELETE FROM ck_carpark_ddl_sync_table_log;");
                    tableNameQueue.offer("ck_carpark_ddl_sync_table_log");
                }
                if (tableNameQueue.peek() == null) break block35;
                taskSize = tableNameQueue.size();
                latch = new CountDownLatch(taskSize);
                threadCount0 = taskSize < threadCount ? taskSize : threadCount;
                i = 0;
                while (i < threadCount0) {
                    task = new ExportTask();
                    task.latch = latch;
                    task.finishCount = finishCount;
                    task.totalTaskCount = totalTaskCount;
                    task.wirteQueue = wirteQueue;
                    task.messageCallback = messageCallback;
                    task.exceptions = exceptions;
                    task.tableNameQueue = tableNameQueue;
                    task.dbConfig = dbConfig;
                    task.jdbcStructTool = jdbcStructTool;
                    task.start();
                    ++i;
                }
                finish = false;
                if (true) ** GOTO lbl147
                block11: while (true) {
                    if (queObj instanceof String) {
                        wirter.println((String)queObj);
                    }
                    if (exceptions[0] != null) {
                        throw exceptions[0];
                    }
                    if (latch.getCount() > 0L) ** GOTO lbl-1000
                    finish = true;
                    while (!finish) lbl-1000:
                    // 2 sources

                    {
                        if ((queObj = wirteQueue.poll(5L, TimeUnit.SECONDS)) != null) continue block11;
                    }
                    break;
                }
            }
            if (!errList.isEmpty()) {
                messageCallback.printMessage("\u5df2\u5b8c\u6210, \u5931\u8d25\u6570\uff1a" + errList.size());
            } else {
                messageCallback.printMessage("\u5df2\u5b8c\u6210100%, \u6570\u636e\u5df2\u5168\u90e8\u5bfc\u51fa");
            }
        }
        finally {
            wirter.close();
        }
        return errList;
    }

    private static String getInsertHead(String tableName, String[] columns) {
        StringBuilder sbr = new StringBuilder(256);
        sbr.append("INSERT INTO ").append(tableName).append(" (");
        char a = ',';
        int i = 0;
        while (i < columns.length) {
            if (i > 0) {
                sbr.append(a);
            }
            sbr.append(columns[i]);
            ++i;
        }
        sbr.append(") VALUES ");
        return sbr.toString();
    }

    private static boolean contains(String[] cl, String value) {
        if (value == null || cl == null || cl.length == 0) {
            return false;
        }
        String[] stringArray = cl;
        int n = cl.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (value.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static /* synthetic */ String access$0(String string, String[] stringArray) {
        return DBTool.getInsertHead(string, stringArray);
    }

    static /* synthetic */ boolean access$1(String[] stringArray, String string) {
        return DBTool.contains(stringArray, string);
    }

    private static class ExportTask
    extends Thread {
        CountDownLatch latch;
        AtomicInteger finishCount;
        int totalTaskCount;
        LinkedBlockingQueue<Object> wirteQueue;
        MessageCallback messageCallback;
        Throwable[] exceptions;
        ConcurrentLinkedQueue<String> tableNameQueue;
        Properties dbConfig;
        JdbcStructTool jdbcStructTool;
        boolean ignoreError;
        List<String> ignoreErrorList;

        private ExportTask() {
        }

        private String getFinishCount() {
            if (this.totalTaskCount <= 0) {
                this.totalTaskCount = 1;
            }
            double x = (double)this.finishCount.get() / (double)this.totalTaskCount;
            int z = (int)(x *= 100.0);
            if (z >= 100) {
                z = 99;
            }
            return "\u5df2\u5b8c\u6210" + z + "%";
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 12[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

