/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool;

import com.wlyk.carpark.dbtool.CryptoUtil;
import com.wlyk.carpark.dbtool.DBTool;
import com.wlyk.carpark.dbtool.FileUtil;
import com.wlyk.carpark.dbtool.MessageCallback;
import com.wlyk.carpark.dbtool.SwingUtil;
import com.wlyk.carpark.dbtool.XYConstraints;
import com.wlyk.carpark.dbtool.XYLayout;
import com.wlyk.carpark.dbtool.jdbc.JdbcStructTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.Key;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class DbToolFrame
extends JFrame
implements MessageCallback {
    private static final long serialVersionUID = -8547233384147706573L;
    private JPanel body;
    private JLabel msgLabel;
    private JTextField filePathText;
    private JButton chooseButton;
    private JButton upateButton;
    private JLabel textLabel;
    static FileLock fileLock = null;
    static RandomAccessFile lockFile = null;
    volatile boolean runnin = false;
    private Dimension screenSize;
    private boolean importData;
    private static boolean loadDrive = false;
    private static String UTF8 = "UTF-8";
    private static Properties dbconfig;
    private static Key dbKey;
    private static JdbcStructTool fileJdbcStructTool;

    public DbToolFrame(Dimension size, Dimension screenSize, boolean importData) {
        this.screenSize = screenSize;
        this.importData = importData;
        this.init(size);
    }

    private void init(Dimension size) {
        this.setResizable(false);
        this.body = new JPanel(new XYLayout());
        this.body.setBackground(Color.WHITE);
        this.chooseButton = new JButton();
        ImageIcon selectFileIcon = new ImageIcon(this.getClass().getResource("selectFile.png"));
        int font12Size = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        String fontName = SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,\u5fae\u8edf\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53");
        Font font12 = new Font(fontName, 0, font12Size);
        int font13Size = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        Font font13 = new Font(fontName, 0, font13Size);
        this.filePathText = new JTextField();
        this.filePathText.setFont(font12);
        int picWidthHeight = (int)Math.round(this.screenSize.getHeight() * 16.0 / 768.0);
        if (picWidthHeight < 24) {
            picWidthHeight = 24;
        }
        selectFileIcon = new ImageIcon(SwingUtil.resizeImage(selectFileIcon.getImage(), picWidthHeight, picWidthHeight));
        this.chooseButton.setIcon(selectFileIcon);
        this.chooseButton.setContentAreaFilled(false);
        this.chooseButton.setBorderPainted(false);
        if (this.importData) {
            this.chooseButton.setToolTipText("\u70b9\u51fb\u9009\u62e9\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
        } else {
            this.chooseButton.setToolTipText("\u70b9\u51fb\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u76ee\u5f55");
        }
        this.chooseButton.setCursor(new Cursor(12));
        this.chooseButton.addActionListener(new ActionListener(){
            JFileChooser fileChooser;

            @Override
            public void actionPerformed(ActionEvent e) {
                int reurnV;
                File zf;
                String txt;
                if (this.fileChooser == null) {
                    this.fileChooser = new JFileChooser(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected JDialog createDialog(Component parent) throws HeadlessException {
                            JDialog d = super.createDialog(parent);
                            d.setIconImage(new ImageIcon(DbToolFrame.class.getResource("folder.png")).getImage());
                            if (DbToolFrame.this.importData) {
                                d.setTitle("\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
                            } else {
                                d.setTitle("\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u76ee\u5f55");
                            }
                            return d;
                        }
                    };
                    if (DbToolFrame.this.importData) {
                        this.fileChooser.setFileSelectionMode(0);
                    } else {
                        this.fileChooser.setFileSelectionMode(1);
                    }
                    if (DbToolFrame.this.importData) {
                        this.fileChooser.setFileFilter(new FileFilter(){
                            String b = ".db";

                            @Override
                            public String getDescription() {
                                return this.b;
                            }

                            @Override
                            public boolean accept(File f) {
                                if (f.isDirectory()) {
                                    return true;
                                }
                                return f.getName().endsWith(this.b);
                            }
                        });
                    }
                }
                if ((txt = DbToolFrame.this.filePathText.getText()) != null && txt.length() > 0 && (zf = new File(txt)).exists()) {
                    this.fileChooser.setCurrentDirectory(zf.isFile() ? zf.getParentFile() : zf);
                }
                if ((reurnV = this.fileChooser.showOpenDialog(DbToolFrame.this)) == 0) {
                    if (DbToolFrame.this.importData) {
                        DbToolFrame.this.filePathText.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        DbToolFrame.this.filePathText.setText(new File(this.fileChooser.getSelectedFile(), "carpark_" + System.currentTimeMillis() + ".db").getAbsolutePath());
                    }
                }
            }
        });
        this.upateButton = new JButton(this.importData ? "\u5bfc\u5165\u6570\u636e" : "\u5bfc\u51fa\u6570\u636e");
        this.upateButton.setCursor(new Cursor(12));
        this.upateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbToolFrame.this.doOk();
            }
        });
        this.upateButton.setFont(font12);
        this.textLabel = new JLabel(this.importData ? "\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6" : "\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u76ee\u5f55");
        this.textLabel.setFont(font13);
        this.msgLabel = new JLabel(!DbToolFrame.canUpgrade() ? "\u5efa\u8bae\u5148\u505c\u6b62\u8f66\u573a\u7a0b\u5e8f\u518d\u6267\u884c\u6b64\u64cd\u4f5c" : (this.importData ? "\u6ce8\u610f: \u5bfc\u5165\u6570\u636e\u5c06\u8fd8\u539f\u6570\u636e\u6587\u4ef6\u4e2d\u7684\u6570\u636e, \u65b0\u6570\u636e\u5c06\u4e22\u5931" : ""));
        this.msgLabel.setFont(font12);
        int marginLeft = (int)Math.round(this.screenSize.getHeight() * 30.0 / 768.0);
        int marginTop = (int)Math.round(this.screenSize.getHeight() * 30.0 / 768.0);
        int textLabelHeight = (int)Math.round(this.screenSize.getHeight() * 30.0 / 768.0);
        int grap = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        int x = marginLeft;
        int y = marginTop;
        int w = size.width - 2 * x;
        int h = textLabelHeight;
        this.body.add((Component)this.textLabel, new XYConstraints(x, y, w, h));
        x = marginLeft;
        w = size.width - 2 * x - grap - picWidthHeight;
        this.body.add((Component)this.filePathText, new XYConstraints(x, y += h, w, h));
        int tY = (h - picWidthHeight) / 2;
        this.body.add((Component)this.chooseButton, new XYConstraints(x += w + grap, y + tY, picWidthHeight, picWidthHeight));
        int mzr = (int)Math.round(this.screenSize.getHeight() * 15.0 / 768.0);
        int butonWidth = (int)Math.round(this.screenSize.getHeight() * 80.0 / 768.0);
        int butonHeight = (int)Math.round(this.screenSize.getHeight() * 32.0 / 768.0);
        x = (size.width - butonWidth) / 2;
        this.body.add((Component)this.upateButton, new XYConstraints(x, y += h + mzr, butonWidth, butonHeight));
        x = marginLeft;
        w = size.width - 2 * x;
        int margz = (int)Math.round(this.screenSize.getHeight() * 3.0 / 768.0);
        this.body.add((Component)this.msgLabel, new XYConstraints(x, y += butonHeight + margz, w, butonHeight));
        this.getContentPane().add((Component)this.body, "Center");
        this.setSize(size);
        this.setDefaultCloseOperation(3);
        x = (this.screenSize.width - size.width) / 2;
        y = (this.screenSize.height - size.height) / 2;
        this.setLocation(x, y);
        this.setTitle(this.importData ? "\u6570\u636e\u5e93\u5bfc\u5165\u5de5\u5177" : "\u6570\u636e\u5e93\u5bfc\u51fa\u5de5\u5177");
        this.setIconImage(new ImageIcon(this.getClass().getResource("database.png")).getImage());
        this.toFront();
    }

    private void doExportData(File file) {
        this.printMessage("\u6b63\u5728\u68c0\u6d4b\u6570\u636e\u8fde\u63a5...");
        Connection conn = DBTool.getConnection(dbconfig);
        if (conn == null) {
            this.setText("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93", Color.RED, true);
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            List<String> errList = DBTool.doExport(dbconfig, file, 6, this, fileJdbcStructTool, true);
            if (errList == null || errList.isEmpty()) {
                this.setText("\u6570\u636e\u5df2\u6210\u529f\u5bfc\u51fa\u5230\u6587\u4ef6", Color.GREEN, true);
            } else {
                this.setText("\u5df2\u5b8c\u6210, \u5931\u8d25\u6570\uff1a" + errList.size() + "\uff1a" + errList, Color.decode("#FF8800"), true);
            }
        }
        catch (Throwable ex) {
            this.setText("\u5bfc\u51fa\u5f02\u5e38! \u539f\u56e0: " + ex.getMessage(), Color.RED, true);
            ex.printStackTrace();
        }
    }

    private void doImportData(File file) {
        Connection conn = DBTool.getConnection(dbconfig);
        if (conn == null) {
            this.setText("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93", Color.RED, true);
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            DBTool.doImport(dbconfig, file, 10, this);
            this.setText("\u6570\u636e\u5bfc\u5165\u6210\u529f", Color.GREEN, true);
        }
        catch (Throwable ex) {
            this.setText("\u6570\u636e\u5bfc\u5165\u5f02\u5e38! \u539f\u56e0: " + ex.getMessage(), Color.RED, true);
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doOk() {
        File updateFile;
        block14: {
            if (!this.upateButton.isEnabled()) {
                return;
            }
            String txt = this.filePathText.getText();
            updateFile = null;
            if (txt != null && txt.length() > 0) {
                File zf = new File(txt);
                if (this.importData) {
                    if (zf.exists() && zf.isFile()) {
                        if (!zf.getName().endsWith(".db")) {
                            this.msgLabel.setForeground(Color.RED);
                            this.msgLabel.setText("\u4e0d\u662f\u6709\u6548\u7684\u6570\u636e\u6587\u4ef6,\u8bf7\u91cd\u65b0\u9009\u62e9");
                            return;
                        }
                        updateFile = zf;
                        break block14;
                    } else {
                        this.msgLabel.setForeground(Color.RED);
                        this.msgLabel.setText("\u6587\u4ef6\u4e0d\u5b58\u5728\u8bf7\u91cd\u65b0\u9009\u62e9");
                        return;
                    }
                }
                File dir = zf.getParentFile();
                if (dir.exists() && dir.isDirectory()) {
                    if (!zf.getName().endsWith(".db")) {
                        this.msgLabel.setForeground(Color.RED);
                        this.msgLabel.setText("\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u540d\u9519\u8bef");
                        return;
                    }
                    if (zf.exists() && zf.isFile()) {
                        this.msgLabel.setForeground(Color.RED);
                        this.msgLabel.setText("\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                        return;
                    }
                    updateFile = zf;
                } else {
                    this.msgLabel.setForeground(Color.RED);
                    this.msgLabel.setText("\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    return;
                }
            }
        }
        if (updateFile == null) {
            this.msgLabel.setForeground(Color.RED);
            this.msgLabel.setText(this.importData ? "\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6" : "\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6587\u4ef6\u76ee\u5f55");
            return;
        }
        if (!loadDrive) {
            this.msgLabel.setForeground(Color.RED);
            this.msgLabel.setText("\u7f3a\u5c11\u6570\u636e\u5e93\u9a71\u52a8\u6587\u4ef6");
            return;
        }
        if (dbconfig == null || dbconfig.isEmpty()) {
            this.msgLabel.setForeground(Color.RED);
            this.msgLabel.setText("\u7f3a\u5c11\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6");
            return;
        }
        if (!DbToolFrame.canUpgrade()) {
            this.msgLabel.setForeground(Color.RED);
            this.msgLabel.setText("\u8bf7\u5148\u9000\u51fa\u505c\u8f66\u573a\u5e94\u7528\u7a0b\u5e8f,\u518d\u7ee7\u7eed\u64cd\u4f5c");
            return;
        }
        this.msgLabel.setForeground(Color.BLACK);
        this.upateButton.setEnabled(false);
        this.chooseButton.setEnabled(false);
        final File runFile = updateFile;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (DbToolFrame.this.importData) {
                    DbToolFrame.this.doImportData(runFile);
                } else {
                    DbToolFrame.this.doExportData(runFile);
                }
            }
        }).start();
    }

    @Override
    public void dispose() {
        DbToolFrame.clearLock();
    }

    private static boolean canUpgrade() {
        FileLock lock;
        RandomAccessFile lockFile1;
        block9: {
            File runtimeFile = new File(FileUtil.findLocalDir(), "runtime");
            if (!runtimeFile.exists() || !runtimeFile.isDirectory()) {
                return true;
            }
            File fileLockPath = new File(runtimeFile, "runtime.lock");
            if (!fileLockPath.exists() || !fileLockPath.isFile()) {
                return true;
            }
            lockFile1 = new RandomAccessFile(fileLockPath, "rw");
            FileChannel fc = lockFile1.getChannel();
            lock = fc.tryLock();
            if (lock != null) break block9;
            lockFile1.close();
            return false;
        }
        try {
            try {
                lock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                lockFile1.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void setText(final String msg, final Color c2, final boolean enableButton) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DbToolFrame.this.msgLabel != null) {
                    Color c1;
                    if (!(c2 == null || (c1 = DbToolFrame.this.msgLabel.getForeground()) != null && c1.equals(c2))) {
                        DbToolFrame.this.msgLabel.setForeground(c2);
                    }
                    DbToolFrame.this.msgLabel.setText(msg);
                }
                if (enableButton) {
                    if (DbToolFrame.this.upateButton != null) {
                        DbToolFrame.this.upateButton.setEnabled(true);
                    }
                    if (DbToolFrame.this.chooseButton != null) {
                        DbToolFrame.this.chooseButton.setEnabled(true);
                    }
                }
            }
        });
    }

    private static boolean canLaunch() {
        FileLock lock;
        RandomAccessFile lockFile1;
        block4: {
            File runtimeFile = new File(FileUtil.findLocalDir(), "runtime");
            if (!runtimeFile.exists() || !runtimeFile.isDirectory()) {
                runtimeFile.mkdirs();
            }
            File fileLockPath = new File(runtimeFile, "dbTool.lock");
            lockFile1 = new RandomAccessFile(fileLockPath, "rw");
            FileChannel fc = lockFile1.getChannel();
            lock = fc.tryLock();
            if (lock != null) break block4;
            lockFile1.close();
            return false;
        }
        try {
            fileLock = lock;
            lockFile = lockFile1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void clearLock() {
        try {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        try {
            if (lockFile != null) {
                lockFile.close();
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        boolean useDbStructConfig;
        if (!DbToolFrame.canLaunch()) {
            return;
        }
        File postgresqlJar = new File(FileUtil.findHomeDir(), "bin/lib/postgresql-42.2.5.jar");
        if (postgresqlJar.exists() && postgresqlJar.isFile()) {
            LinkedList<URL> list = new LinkedList<URL>();
            list.add(postgresqlJar.toURI().toURL());
            DbToolFrame.loadJarOrClass(list);
            String driver = "org.postgresql.Driver";
            Class.forName(driver);
            loadDrive = true;
        }
        byte[] byArray = new byte[141];
        byArray[0] = -84;
        byArray[1] = -19;
        byArray[3] = 5;
        byArray[4] = 115;
        byArray[5] = 114;
        byArray[7] = 31;
        byArray[8] = 106;
        byArray[9] = 97;
        byArray[10] = 118;
        byArray[11] = 97;
        byArray[12] = 120;
        byArray[13] = 46;
        byArray[14] = 99;
        byArray[15] = 114;
        byArray[16] = 121;
        byArray[17] = 112;
        byArray[18] = 116;
        byArray[19] = 111;
        byArray[20] = 46;
        byArray[21] = 115;
        byArray[22] = 112;
        byArray[23] = 101;
        byArray[24] = 99;
        byArray[25] = 46;
        byArray[26] = 83;
        byArray[27] = 101;
        byArray[28] = 99;
        byArray[29] = 114;
        byArray[30] = 101;
        byArray[31] = 116;
        byArray[32] = 75;
        byArray[33] = 101;
        byArray[34] = 121;
        byArray[35] = 83;
        byArray[36] = 112;
        byArray[37] = 101;
        byArray[38] = 99;
        byArray[39] = 91;
        byArray[40] = 71;
        byArray[41] = 11;
        byArray[42] = 102;
        byArray[43] = -30;
        byArray[44] = 48;
        byArray[45] = 97;
        byArray[46] = 77;
        byArray[47] = 2;
        byArray[49] = 2;
        byArray[50] = 76;
        byArray[52] = 9;
        byArray[53] = 97;
        byArray[54] = 108;
        byArray[55] = 103;
        byArray[56] = 111;
        byArray[57] = 114;
        byArray[58] = 105;
        byArray[59] = 116;
        byArray[60] = 104;
        byArray[61] = 109;
        byArray[62] = 116;
        byArray[64] = 18;
        byArray[65] = 76;
        byArray[66] = 106;
        byArray[67] = 97;
        byArray[68] = 118;
        byArray[69] = 97;
        byArray[70] = 47;
        byArray[71] = 108;
        byArray[72] = 97;
        byArray[73] = 110;
        byArray[74] = 103;
        byArray[75] = 47;
        byArray[76] = 83;
        byArray[77] = 116;
        byArray[78] = 114;
        byArray[79] = 105;
        byArray[80] = 110;
        byArray[81] = 103;
        byArray[82] = 59;
        byArray[83] = 91;
        byArray[85] = 3;
        byArray[86] = 107;
        byArray[87] = 101;
        byArray[88] = 121;
        byArray[89] = 116;
        byArray[91] = 2;
        byArray[92] = 91;
        byArray[93] = 66;
        byArray[94] = 120;
        byArray[95] = 112;
        byArray[96] = 116;
        byArray[98] = 3;
        byArray[99] = 65;
        byArray[100] = 69;
        byArray[101] = 83;
        byArray[102] = 117;
        byArray[103] = 114;
        byArray[105] = 2;
        byArray[106] = 91;
        byArray[107] = 66;
        byArray[108] = -84;
        byArray[109] = -13;
        byArray[110] = 23;
        byArray[111] = -8;
        byArray[112] = 6;
        byArray[113] = 8;
        byArray[114] = 84;
        byArray[115] = -32;
        byArray[116] = 2;
        byArray[119] = 120;
        byArray[120] = 112;
        byArray[124] = 16;
        byArray[125] = -85;
        byArray[126] = 118;
        byArray[127] = 78;
        byArray[128] = -62;
        byArray[129] = 69;
        byArray[130] = 17;
        byArray[131] = -110;
        byArray[132] = -15;
        byArray[133] = -104;
        byArray[134] = 85;
        byArray[135] = -21;
        byArray[136] = -117;
        byArray[137] = 12;
        byArray[138] = -58;
        byArray[139] = 99;
        byArray[140] = -8;
        byte[] keyBytes = byArray;
        dbKey = CryptoUtil.readKeyFromInputStream(new ByteArrayInputStream(keyBytes));
        try {
            dbconfig = DbToolFrame.getDBConfigProperties();
        }
        catch (Exception driver) {
            // empty catch block
        }
        final boolean importData = args != null && args.length == 1 && "importData".equals(args[0]);
        boolean exportDbStruct = args != null && args.length == 1 && "exportDbStruct".equals(args[0]);
        boolean exportDbConfig = args != null && args.length == 1 && "exportDbConfig".equals(args[0]);
        boolean bl = useDbStructConfig = args != null && args.length == 1 && "useDbStructConfig".equals(args[0]);
        if (exportDbConfig) {
            File file = new File(FileUtil.findHomeDir(), "DBConfig.properties");
            try (FileOutputStream out = new FileOutputStream(file);){
                dbconfig.store(out, "");
            }
            System.out.println("\u6587\u4ef6\u8f93\u51fa=====>" + file.getAbsolutePath());
            return;
        }
        if (exportDbStruct) {
            Connection conn = DBTool.getConnection(dbconfig);
            if (conn == null) {
                System.err.println("\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93");
                return;
            }
            try {
                try {
                    String s;
                    int n;
                    int n2;
                    String[] stringArray;
                    StringBuilder sbr;
                    JdbcStructTool struct = new JdbcStructTool();
                    struct.loadAllTableStructs(conn, dbconfig.getProperty("dbname"));
                    Properties px = new Properties();
                    for (Map.Entry<String, String[]> entry : struct.getTableColumnNamesMap().entrySet()) {
                        sbr = new StringBuilder();
                        stringArray = entry.getValue();
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            s = stringArray[n];
                            if (sbr.length() > 0) {
                                sbr.append(',');
                            }
                            sbr.append(s);
                            ++n;
                        }
                        px.put("column." + entry.getKey(), sbr.toString());
                    }
                    for (Map.Entry<String, String[]> entry : struct.getTablePrimaryKeyNamesMap().entrySet()) {
                        sbr = new StringBuilder();
                        stringArray = entry.getValue();
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            s = stringArray[n];
                            if (sbr.length() > 0) {
                                sbr.append(',');
                            }
                            sbr.append(s);
                            ++n;
                        }
                        px.put("primaryKey." + entry.getKey(), sbr.toString());
                    }
                    File file = new File(FileUtil.findHomeDir(), "DBStruct.properties");
                    try (FileOutputStream out = new FileOutputStream(file);){
                        px.store(out, "");
                    }
                    System.out.println("\u6587\u4ef6\u8f93\u51fa=====>" + file.getAbsolutePath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    conn.close();
                }
            }
            finally {
                conn.close();
            }
            return;
        }
        if (useDbStructConfig) {
            File file = new File(FileUtil.findHomeDir(), "DBStruct.properties");
            if (!file.exists() || !file.isFile()) {
                System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728=====>" + file.getAbsolutePath());
                return;
            }
            Properties px = new Properties();
            try (FileInputStream fin = new FileInputStream(file);){
                px.load(fin);
            }
            JdbcStructTool jdbcStructTool = new JdbcStructTool();
            String columnHead = "column.";
            String primaryKeyHead = "primaryKey.";
            for (Map.Entry<Object, Object> entry : px.entrySet()) {
                String key = entry.getKey().toString();
                String values = entry.getValue().toString();
                if (key.startsWith(columnHead)) {
                    jdbcStructTool.getTableColumnNamesMap().put(key.substring(columnHead.length()), values.split(","));
                    continue;
                }
                if (!key.startsWith(primaryKeyHead)) continue;
                jdbcStructTool.getTablePrimaryKeyNamesMap().put(key.substring(primaryKeyHead.length()), values.split(","));
            }
            fileJdbcStructTool = jdbcStructTool;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtil.setLookAndFeel("Nimbus");
                Dimension screenSize = SwingUtil.getScreenSize();
                int font12Size = (int)Math.round(screenSize.getHeight() * 12.0 / 768.0);
                String fontName = SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,\u5fae\u8edf\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53");
                Font font = new Font(fontName, 0, font12Size);
                UIManager.put("Button.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("RadioButton.font", font);
                UIManager.put("CheckBox.font", font);
                UIManager.put("ColorChooser.font", font);
                UIManager.put("ToggleButton.font", font);
                UIManager.put("ComboBox.font", font);
                UIManager.put("ComboBoxItem.font", font);
                UIManager.put("InternalFrame.titleFont", font);
                UIManager.put("Label.font", font);
                UIManager.put("List.font", font);
                UIManager.put("MenuBar.font", font);
                UIManager.put("Menu.font", font);
                UIManager.put("MenuItem.font", font);
                UIManager.put("RadioButtonMenuItem.font", font);
                UIManager.put("CheckBoxMenuItem.font", font);
                UIManager.put("PopupMenu.font", font);
                UIManager.put("OptionPane.font", font);
                UIManager.put("Panel.font", font);
                UIManager.put("ProgressBar.font", font);
                UIManager.put("ScrollPane.font", font);
                UIManager.put("Viewport", font);
                UIManager.put("TabbedPane.font", font);
                UIManager.put("TableHeader.font", font);
                UIManager.put("TextField.font", font);
                UIManager.put("PasswordFiled.font", font);
                UIManager.put("TextArea.font", font);
                UIManager.put("TextPane.font", font);
                UIManager.put("EditorPane.font", font);
                UIManager.put("TitledBorder.font", font);
                UIManager.put("ToolBar.font", font);
                UIManager.put("ToolTip.font", font);
                UIManager.put("Tree.font", font);
                UIManager.put("FilePane.font", font);
                UIManager.put("CellRendererPane.font", font);
                UIManager.put("Component.font", font);
                int frameWidth = (int)Math.round(screenSize.getHeight() * 360.0 / 768.0);
                int frameHeight = (int)Math.round(screenSize.getHeight() * 240.0 / 768.0);
                DbToolFrame fram = new DbToolFrame(new Dimension(frameWidth, frameHeight), screenSize, importData);
                fram.setVisible(true);
                fram.toFront();
            }
        });
    }

    public static void loadJarOrClass(Collection<URL> urlset) throws Exception {
        Method addURLMethod = null;
        addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURLMethod.setAccessible(true);
        for (URL url : urlset) {
            addURLMethod.invoke((Object)ClassLoader.getSystemClassLoader(), url);
        }
    }

    private static Properties readPropeties(File file) throws IOException {
        Properties p = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            p.load(in);
        }
        return p;
    }

    private static Properties getDBConfigProperties() throws Exception {
        String EMPTY_STRING = "";
        File dbconfigFile = new File(FileUtil.findLocalDir(), "conf/db.conf");
        if (!dbconfigFile.exists() || !dbconfigFile.isFile()) {
            throw new RuntimeException("\u7f3a\u5c11\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6 \u5728\u8def\u5f84:" + dbconfigFile);
        }
        Properties p = DbToolFrame.readPropeties(dbconfigFile);
        boolean encrypt = Boolean.parseBoolean(p.getProperty("z", "true").trim());
        String host = p.getProperty("h", EMPTY_STRING).trim();
        String port = p.getProperty("t", EMPTY_STRING).trim();
        String user = p.getProperty("u", EMPTY_STRING).trim();
        String password = p.getProperty("p", EMPTY_STRING).trim();
        String dbname = p.getProperty("d", EMPTY_STRING).trim();
        String localInstallDb = p.getProperty("l", EMPTY_STRING).trim();
        if (encrypt) {
            Key key = dbKey;
            if (host.length() > 0) {
                host = CryptoUtil.decrypt(host, UTF8, key, key.getAlgorithm());
            }
            if (port.length() > 0) {
                port = CryptoUtil.decrypt(port, UTF8, key, key.getAlgorithm());
            }
            if (user.length() > 0) {
                user = CryptoUtil.decrypt(user, UTF8, key, key.getAlgorithm());
            }
            if (password.length() > 0) {
                password = CryptoUtil.decrypt(password, UTF8, key, key.getAlgorithm());
            }
            if (dbname.length() > 0) {
                dbname = CryptoUtil.decrypt(dbname, UTF8, key, key.getAlgorithm());
            }
            if (localInstallDb.length() > 0) {
                localInstallDb = CryptoUtil.decrypt(localInstallDb, UTF8, key, key.getAlgorithm());
            }
        }
        Properties returnP = new Properties();
        returnP.put("host", host);
        returnP.put("port", port);
        returnP.put("user", user);
        returnP.put("pwd", password);
        returnP.put("dbname", dbname);
        returnP.put("locbd", localInstallDb);
        return returnP;
    }

    @Override
    public void printMessage(String message) {
        this.setText(message, Color.BLUE, false);
    }
}

