/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool;

import java.io.Serializable;

public class Pagination
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6950405057616153833L;
    private int pageSize = 10;
    private int gotoPage = 1;
    private boolean gotoFirstPage;
    private boolean gotoLastPage;
    private long recordsCount;
    private int limitCount;
    private int offset;
    private int currentPage;
    private int previousPage;
    private int nextPage;
    private int totalPages;
    private boolean havePrevious;
    private boolean haveNext;
    private boolean needQueryCount = true;

    public void resetParameters() {
        this.pageSize = 10;
        this.gotoPage = 1;
        this.gotoFirstPage = false;
        this.gotoLastPage = false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\u603b\u8bb0\u5f55\u6570:").append(this.recordsCount).append(' ').append("\u662f\u5426\u6709\u4e0a\u4e00\u9875 :").append(this.havePrevious).append(' ');
        builder.append("\u662f\u5426\u6709\u4e0b\u4e00\u9875 :").append(this.haveNext).append(' ').append("\u5f53\u524d\u9875 :").append(this.currentPage).append(' ');
        builder.append("\u4e0a\u4e00\u9875 :").append(this.previousPage).append(' ').append("\u4e0b\u4e00\u9875 :").append(this.nextPage).append(' ');
        builder.append("\u603b\u9875\u6570 :").append(this.totalPages).append(' ').append("\u4e00\u9875\u663e\u793a\u7684\u8bb0\u5f55\u6570 :").append(this.pageSize).append(' ');
        builder.append("\u8df3\u8f6c\u5230\u9875\u6570 :").append(this.gotoPage).append(' ').append("\u662f\u5426\u8df3\u8f6c\u7b2c\u4e00\u9875 :").append(this.gotoFirstPage).append(' ').append("\u662f\u5426\u8df3\u8f6c\u6700\u540e\u4e00\u9875 :").append(this.gotoLastPage).append(' ');
        return builder.toString();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isHavePrevious() {
        return this.havePrevious;
    }

    public void setHavePrevious(boolean havePrevious) {
        this.havePrevious = havePrevious;
    }

    public boolean isHaveNext() {
        return this.haveNext;
    }

    public void setHaveNext(boolean haveNext) {
        this.haveNext = haveNext;
    }

    public boolean isGotoFirstPage() {
        return this.gotoFirstPage;
    }

    public void setGotoFirstPage(boolean gotoFirstPage) {
        this.gotoFirstPage = gotoFirstPage;
    }

    public boolean isGotoLastPage() {
        return this.gotoLastPage;
    }

    public void setGotoLastPage(boolean gotoLastPage) {
        this.gotoLastPage = gotoLastPage;
    }

    public int getGotoPage() {
        return this.gotoPage;
    }

    public void setGotoPage(int gotoPage) {
        this.gotoPage = gotoPage;
    }

    public long getRecordsCount() {
        return this.recordsCount;
    }

    public void setRecordsCount(long recordsCount) {
        this.recordsCount = recordsCount;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public int getLimit() {
        return this.getLimitCount();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage(int previousPage) {
        this.previousPage = previousPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void calculatePage() {
        if (this.recordsCount <= 0L) {
            this.recordsCount = 0L;
            this.currentPage = 1;
            this.previousPage = 1;
            this.nextPage = 1;
            this.totalPages = 1;
            this.limitCount = 1;
            this.offset = 0;
            this.havePrevious = false;
            this.haveNext = false;
            return;
        }
        if (this.pageSize < 0) {
            this.pageSize = 1;
        }
        this.totalPages = (int)(this.recordsCount % (long)this.pageSize == 0L ? this.recordsCount / (long)this.pageSize : this.recordsCount / (long)this.pageSize + 1L);
        int go = this.gotoPage;
        if (go < 1) {
            go = 1;
        } else if (go > this.totalPages) {
            go = this.totalPages;
        }
        if (this.gotoLastPage) {
            go = this.totalPages;
        }
        if (this.gotoFirstPage) {
            go = 1;
        }
        this.currentPage = go;
        this.previousPage = go;
        this.nextPage = go;
        if (go == 1) {
            this.havePrevious = false;
            if (go < this.totalPages) {
                this.haveNext = true;
            }
        }
        if (go == this.totalPages) {
            this.haveNext = false;
            if (this.totalPages > 1) {
                this.havePrevious = true;
            }
        }
        if (go > 1 && go < this.totalPages) {
            this.havePrevious = true;
            this.haveNext = true;
        }
        if (this.havePrevious) {
            this.previousPage = go - 1;
        }
        if (this.haveNext) {
            this.nextPage = go + 1;
        }
        this.limitCount = this.pageSize;
        this.offset = this.limitCount * (go - 1);
    }

    public boolean isNeedQueryCount() {
        return this.needQueryCount;
    }

    public void setNeedQueryCount(boolean needQueryCount) {
        this.needQueryCount = needQueryCount;
    }

    public Pagination clone() {
        try {
            return (Pagination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

