/*
 * Decompiled with CFR 0.152.
 */
package com.wlyk.carpark.dbtool.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JdbcStructTool {
    private Map<String, String[]> tableColumnNamesMap = new HashMap<String, String[]>();
    private Map<String, String[]> tablePrimaryKeyNamesMap = new HashMap<String, String[]>();

    public Map<String, String[]> getTableColumnNamesMap() {
        return this.tableColumnNamesMap;
    }

    public Map<String, String[]> getTablePrimaryKeyNamesMap() {
        return this.tablePrimaryKeyNamesMap;
    }

    public static Set<String> getAllTableNames(Connection conn, String databaseName) throws SQLException {
        DatabaseMetaData dbdata = conn.getMetaData();
        ResultSet res = dbdata.getTables(databaseName, JdbcStructTool.getSchema(conn), null, new String[]{"TABLE"});
        HashSet<String> tableSet = new HashSet<String>();
        String TABLE_NAME = "TABLE_NAME";
        while (res.next()) {
            String tableName = res.getString(TABLE_NAME);
            if (tableName == null || tableName.length() <= 0) continue;
            tableSet.add(tableName);
        }
        res.close();
        return tableSet;
    }

    public void loadAllTableStructs(Connection conn, String databaseName) throws SQLException {
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        Set<String> tableNames = JdbcStructTool.getAllTableNames(conn, databaseName);
        for (String tableName : tableNames) {
            String[] reutnv;
            ResultSet rs = databaseMetaData.getColumns(databaseName, JdbcStructTool.getSchema(conn), tableName, null);
            ArrayList<String> slist = new ArrayList<String>();
            String COLUMN_NAME = "COLUMN_NAME";
            while (rs.next()) {
                String fieldName = rs.getString("COLUMN_NAME");
                if (fieldName == null || fieldName.length() <= 0) continue;
                slist.add(fieldName);
            }
            if (slist != null && !slist.isEmpty()) {
                reutnv = slist.toArray(new String[slist.size()]);
                this.tableColumnNamesMap.put(tableName, reutnv);
            }
            rs.close();
            rs = databaseMetaData.getPrimaryKeys(databaseName, JdbcStructTool.getSchema(conn), tableName);
            slist = new ArrayList();
            while (rs.next()) {
                String pkName = rs.getString("COLUMN_NAME");
                if (pkName == null || pkName.length() <= 0) continue;
                slist.add(pkName);
            }
            reutnv = slist.toArray(new String[slist.size()]);
            if (!slist.isEmpty()) {
                this.tablePrimaryKeyNamesMap.put(tableName, reutnv);
            }
            rs.close();
        }
    }

    public static String getSchema(Connection conn) throws SQLException {
        DatabaseMetaData dbdata = conn.getMetaData();
        ResultSet res = dbdata.getSchemas();
        String v = null;
        while (res.next()) {
            v = res.getString("TABLE_SCHEM");
        }
        res.close();
        return v;
    }
}

